/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.presubmit;

import com.android.compatibility.common.tradefed.result.ResultReporter;
import com.android.compatibility.common.tradefed.testtype.CompatibilityTest;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.ShardListener;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IntegrationTest {
    private static final String CONFIG = "<configuration description=\"Auto Generated File\">\n<option name=\"config-descriptor:metadata\" key=\"component\" value=\"%s\" />\n<test class=\"com.android.compatibility.common.tradefed.testtype.%s\">\n    <option name=\"report-test\" value=\"%s\" />\n    <option name=\"run-complete\" value=\"%s\" />\n    <option name=\"test-fail\" value=\"%s\" />\n    <option name=\"internal-retry\" value=\"%s\" />\n</test>\n</configuration>";
    private static final String FILENAME = "%s.config";
    private static final String TEST_STUB = "TestStub";
    private static final String SIMPLE_TEST_STUB = "SimpleTestStub";
    private static final String TEST_STUB_SHARDABLE = "TestStubShardable";
    private static final String COMMAND_LINE = "run cts";
    private CompatibilityTest mTest;
    private ResultReporter mReporter;
    private ITestDevice mMockDevice;
    private IBuildInfo mMockBuildInfo;
    private IInvocationContext mContext;
    private File mRootDir;
    private File mAndroidFolder;
    private File mTestDir;
    private Map<String, String> mAttributes;

    @Before
    public void setUp() throws IOException {
        this.mAttributes = new HashMap<String, String>();
        this.mTest = new CompatibilityTest(){

            protected Set<String> getAbisForBuildTargetArch() {
                HashSet<String> abis = new HashSet<String>();
                abis.add("arm64-v8a");
                abis.add("armeabi-v7a");
                return abis;
            }
        };
        this.mReporter = new ResultReporter();
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mMockBuildInfo = (IBuildInfo)EasyMock.createMock(IBuildInfo.class);
        this.mTest.setBuild(this.mMockBuildInfo);
        this.mTest.setDevice(this.mMockDevice);
        this.mRootDir = FileUtil.createTempDir((String)"fake-cts-root-dir");
        this.mAndroidFolder = FileUtil.createTempDir((String)"android-", (File)this.mRootDir);
        this.mTestDir = new File(this.mAndroidFolder, "testcases");
        this.mTestDir.mkdirs();
        String suiteName = this.mAndroidFolder.getName().split("-")[1];
        this.mAttributes.put("ROOT_DIR", this.mRootDir.getAbsolutePath());
        this.mAttributes.put("SUITE_NAME", suiteName);
        this.mAttributes.put("START_TIME_MS", "0");
        this.mAttributes.put("SUITE_VERSION", "10");
        this.mAttributes.put("SUITE_PLAN", "cts");
        this.mAttributes.put("SUITE_BUILD", "good-build");
        this.mAttributes.put("command_line_args", COMMAND_LINE);
        this.mAttributes.put("cts:build_fingerprint", "fingerprint");
        this.mAttributes.put("cts:build_product", "product");
        this.mAttributes.put("cts:build_id", "bid");
        EasyMock.expect((Object)this.mMockBuildInfo.getBuildAttributes()).andStubReturn(this.mAttributes);
        EasyMock.expect((Object)this.mMockDevice.getSerialNumber()).andStubReturn((Object)"SERIAL");
        EasyMock.expect((Object)this.mMockBuildInfo.getDeviceSerial()).andStubReturn((Object)"SERIAL");
        EasyMock.expect((Object)this.mMockBuildInfo.getFiles()).andStubReturn(Collections.emptyList());
        this.mContext = new InvocationContext();
        this.mContext.addAllocatedDevice("default", this.mMockDevice);
        this.mContext.addDeviceBuildInfo("default", this.mMockBuildInfo);
        this.mTest.setInvocationContext(this.mContext);
    }

    @After
    public void tearDown() {
        FileUtil.recursiveDelete((File)this.mRootDir);
    }

    private void createConfig(File testsDir, String name, String moduleClass, boolean reportTest, boolean runComplete, boolean doesOneTestFail, boolean internalRetry) throws IOException {
        this.createConfig(testsDir, name, moduleClass, reportTest, runComplete, doesOneTestFail, internalRetry, "foo");
    }

    private void createConfig(File testsDir, String name, String moduleClass, boolean reportTest, boolean runComplete, boolean doesOneTestFail, boolean internalRetry, String component) throws IOException {
        File config = new File(testsDir, String.format(FILENAME, name));
        FileUtil.deleteFile((File)config);
        if (!config.createNewFile()) {
            throw new IOException(String.format("Failed to create '%s'", config.getAbsolutePath()));
        }
        FileUtil.writeToFile((String)String.format(CONFIG, component, moduleClass, reportTest, runComplete, doesOneTestFail, internalRetry), (File)config);
    }

    @Test
    public void testSingleModuleRun() throws Exception {
        String moduleName = "module_run";
        String mAbi = "arm64-v8a";
        this.createConfig(this.mTestDir, "module_run", TEST_STUB, true, true, true, false);
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_run")));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        IInvocationResult result = this.mReporter.getResult();
        Assert.assertEquals((long)2L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)1L, (long)result.getModules().size());
        Assert.assertEquals((long)1L, (long)result.getModuleCompleteCount());
    }

    @Test
    public void testSingleModuleRun_checkMetadata() throws Exception {
        String moduleName = "AwsomeModule";
        String mAbi = "arm64-v8a";
        String component = "CriticalComponent";
        final ArrayList receivedComponentsTestEnded = new ArrayList();
        final ArrayList receivedModuleNameTestEnded = new ArrayList();
        final ArrayList receivedAbiTestEnded = new ArrayList();
        final ArrayList receivedComponentsTestRunEnded = new ArrayList();
        final ArrayList receivedModuleNameTestRunEnded = new ArrayList();
        final ArrayList receivedAbiTestRunEnded = new ArrayList();
        this.createConfig(this.mTestDir, "AwsomeModule", SIMPLE_TEST_STUB, true, true, true, false, "CriticalComponent");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"AwsomeModule")));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        ITestInvocationListener myListener = new ITestInvocationListener(){
            private IInvocationContext myContext;

            public void invocationStarted(IInvocationContext context) {
                this.myContext = context;
            }

            public void testRunEnded(long elapsedTimeMillis, HashMap<String, MetricMeasurement.Metric> runMetrics) {
                receivedComponentsTestRunEnded.addAll(this.myContext.getModuleInvocationContext().getConfigurationDescriptor().getMetaData("component"));
                receivedModuleNameTestRunEnded.addAll(this.myContext.getModuleInvocationContext().getAttributes().get((Object)"module-name"));
                receivedAbiTestRunEnded.addAll(this.myContext.getModuleInvocationContext().getAttributes().get((Object)"module-abi"));
            }

            public void testEnded(TestDescription test, long endTime, HashMap<String, MetricMeasurement.Metric> testMetrics) {
                receivedComponentsTestEnded.addAll(this.myContext.getModuleInvocationContext().getConfigurationDescriptor().getMetaData("component"));
                receivedModuleNameTestEnded.addAll(this.myContext.getModuleInvocationContext().getAttributes().get((Object)"module-name"));
                receivedAbiTestEnded.addAll(this.myContext.getModuleInvocationContext().getAttributes().get((Object)"module-abi"));
            }
        };
        myListener.invocationStarted(this.mContext);
        this.mTest.run(myListener);
        myListener.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        Assert.assertEquals((String)"[testRunEnded] wrong number of metadata collected", (long)1L, (long)receivedComponentsTestRunEnded.size());
        Assert.assertEquals((String)"[testRunEnded] wrong component metadata field received", (Object)"CriticalComponent", receivedComponentsTestRunEnded.get(0));
        Assert.assertEquals((String)"[testRunEnded] wrong number of module name collected", (long)1L, (long)receivedModuleNameTestRunEnded.size());
        Assert.assertEquals((Object)"AwsomeModule", receivedModuleNameTestRunEnded.get(0));
        Assert.assertEquals((String)"[testEnded] wrong number of module abi collected", (long)1L, (long)receivedAbiTestRunEnded.size());
        Assert.assertEquals((Object)"arm64-v8a", receivedAbiTestRunEnded.get(0));
        Assert.assertEquals((String)"[testEnded] wrong number of metadata collected", (long)1L, (long)receivedComponentsTestEnded.size());
        Assert.assertEquals((String)"[testEnded] wrong component metadata field received", (Object)"CriticalComponent", receivedComponentsTestEnded.get(0));
        Assert.assertEquals((String)"[testEnded] wrong number of module name collected", (long)1L, (long)receivedModuleNameTestEnded.size());
        Assert.assertEquals((Object)"AwsomeModule", receivedModuleNameTestEnded.get(0));
        Assert.assertEquals((String)"[testEnded] wrong number of module abi collected", (long)1L, (long)receivedAbiTestEnded.size());
        Assert.assertEquals((Object)"arm64-v8a", receivedAbiTestEnded.get(0));
    }

    @Test
    public void testSingleModuleRun_incomplete() throws Exception {
        String moduleName = "module_run_incomplete";
        String mAbi = "arm64-v8a";
        this.createConfig(this.mTestDir, "module_run_incomplete", TEST_STUB, true, false, true, false);
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_run_incomplete")));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        IInvocationResult result = this.mReporter.getResult();
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)1L, (long)result.getModules().size());
        Assert.assertEquals((long)0L, (long)result.getModuleCompleteCount());
    }

    @Test
    public void testSingleModuleRun_completeAfterInternalRetry() throws Exception {
        String moduleName = "module_completeAfterRetry";
        String mAbi = "arm64-v8a";
        this.createConfig(this.mTestDir, "module_completeAfterRetry", TEST_STUB, true, true, true, true);
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_completeAfterRetry")));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        IInvocationResult result = this.mReporter.getResult();
        Assert.assertEquals((long)2L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)1L, (long)result.getModules().size());
        Assert.assertEquals((long)0L, (long)result.getModuleCompleteCount());
    }

    @Test
    public void testSingleModuleRun_incomplete_rerun_incomplete() throws Exception {
        String moduleName = "module_incomplete_rerun";
        String mAbi = "arm64-v8a";
        this.createConfig(this.mTestDir, "module_incomplete_rerun", TEST_STUB, true, false, true, false);
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_incomplete_rerun")));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.build.fingerprint")).andReturn((Object)"fingerprint");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_incomplete_rerun")));
        EasyMock.expectLastCall();
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"retry_command_line_args"), (String)EasyMock.eq((Object)COMMAND_LINE));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        IInvocationResult result = this.mReporter.getResult();
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)0L, (long)result.getModuleCompleteCount());
        this.mReporter = new ResultReporter();
        this.mTest = new CompatibilityTest(){

            protected Set<String> getAbisForBuildTargetArch() {
                HashSet<String> abis = new HashSet<String>();
                abis.add("arm64-v8a");
                return abis;
            }
        };
        this.mTest.setDevice(this.mMockDevice);
        this.mTest.setBuild(this.mMockBuildInfo);
        this.mTest.setInvocationContext(this.mContext);
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest, this.mReporter});
        setter.setOptionValue("retry", "0");
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        result = this.mReporter.getResult();
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)1L, (long)result.getModules().size());
        Assert.assertEquals((long)0L, (long)result.getModuleCompleteCount());
    }

    @Test
    public void testSingleModuleRun_incomplete_rerun_complete() throws Exception {
        String moduleName = "module_incom_rerun_complete";
        String mAbi = "arm64-v8a";
        this.createConfig(this.mTestDir, "module_incom_rerun_complete", TEST_STUB, true, false, true, false);
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_incom_rerun_complete")));
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.build.fingerprint")).andReturn((Object)"fingerprint");
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.product.cpu.abilist")).andReturn((Object)"arm64-v8a");
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"MODULE_IDS"), (String)EasyMock.eq((Object)AbiUtils.createId((String)"arm64-v8a", (String)"module_incom_rerun_complete")));
        EasyMock.expectLastCall();
        this.mMockBuildInfo.addBuildAttribute((String)EasyMock.eq((Object)"retry_command_line_args"), (String)EasyMock.eq((Object)COMMAND_LINE));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        IInvocationResult result = this.mReporter.getResult();
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)1L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)0L, (long)result.getModuleCompleteCount());
        this.createConfig(this.mTestDir, "module_incom_rerun_complete", TEST_STUB, true, true, false, false);
        ((ConfigurationFactory)ConfigurationFactory.getInstance()).clearMapConfig();
        this.mReporter = new ResultReporter();
        this.mTest = new CompatibilityTest(){

            protected Set<String> getAbisForBuildTargetArch() {
                HashSet<String> abis = new HashSet<String>();
                abis.add("arm64-v8a");
                return abis;
            }
        };
        this.mTest.setDevice(this.mMockDevice);
        this.mTest.setBuild(this.mMockBuildInfo);
        this.mTest.setInvocationContext(this.mContext);
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest, this.mReporter});
        setter.setOptionValue("retry", "0");
        this.mReporter.invocationStarted(this.mContext);
        this.mTest.run((ITestInvocationListener)this.mReporter);
        this.mReporter.invocationEnded(500L);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        result = this.mReporter.getResult();
        Assert.assertEquals((long)3L, (long)result.countResults(TestStatus.PASS));
        Assert.assertEquals((long)0L, (long)result.countResults(TestStatus.FAIL));
        Assert.assertEquals((long)1L, (long)result.getModules().size());
        Assert.assertEquals((long)1L, (long)result.getModuleCompleteCount());
    }

    private ITestInvocationListener getShardListener(ResultReporter masterReporter) {
        ArrayList<Object> shardListeners = new ArrayList<Object>();
        ShardListener origConfigListener = new ShardListener((ITestInvocationListener)masterReporter);
        ResultReporter reporterClone = (ResultReporter)masterReporter.clone();
        shardListeners.add(reporterClone);
        shardListeners.add(origConfigListener);
        ResultForwarder shard = new ResultForwarder(shardListeners);
        return shard;
    }

    private class ShardThread
    extends Thread {
        private IRemoteTest mShardTest;
        private ResultReporter mMasterReporter;
        private IBuildInfo mBuild;
        private ITestDevice mDevice;
        private IInvocationContext mShardContext;

        public ShardThread(IRemoteTest test, ResultReporter masterReporter, IBuildInfo build, ITestDevice device, IInvocationContext context) {
            this.mShardTest = test;
            this.mMasterReporter = masterReporter;
            this.mBuild = build;
            this.mDevice = device;
            this.mShardContext = context;
        }

        @Override
        public void run() {
            ITestInvocationListener listener = IntegrationTest.this.getShardListener(this.mMasterReporter);
            ((IBuildReceiver)this.mShardTest).setBuild(this.mBuild);
            ((IDeviceTest)this.mShardTest).setDevice(this.mDevice);
            ((IInvocationContextReceiver)this.mShardTest).setInvocationContext(IntegrationTest.this.mContext);
            listener.invocationStarted(this.mShardContext);
            try {
                this.mShardTest.run(listener);
            }
            catch (DeviceNotAvailableException e) {
                throw new RuntimeException(e);
            }
            finally {
                listener.invocationEnded(500L);
            }
        }
    }
}

