/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.presubmit;

import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.AbiUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ValidateTestsAbi {
    private static final Set<String> MODULE_EXCEPTIONS = new HashSet<String>();
    private static final Set<String> BINARY_EXCEPTIONS;

    @Test
    public void testApksAbis() {
        String ctsRoot = System.getProperty("CTS_ROOT");
        File testcases = new File(ctsRoot, "/android-cts/testcases/");
        if (!testcases.exists()) {
            Assert.fail((String)String.format("%s does not exists", testcases));
            return;
        }
        File[] listApks = testcases.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String module : MODULE_EXCEPTIONS) {
                    if (!name.startsWith(module)) continue;
                    return false;
                }
                return name.endsWith(".apk");
            }
        });
        Assert.assertTrue((listApks.length > 0 ? 1 : 0) != 0);
        int maxAbi = 0;
        HashMap<String, Integer> apkToAbi = new HashMap<String, Integer>();
        for (File testApk : listApks) {
            AaptParser result = AaptParser.parse((File)testApk);
            if (result == null) {
                for (int i = 0; i < 2 && (result = AaptParser.parse((File)testApk)) == null; ++i) {
                }
                if (result == null) {
                    Assert.fail((String)String.format("Fail to run 'aapt dump badging %s'", testApk.getAbsolutePath()));
                }
            }
            if (result.getNativeCode().isEmpty()) continue;
            List supportedAbiApk = result.getNativeCode();
            Set buildTarget = AbiUtils.getAbisForArch((String)((String)TestSuiteInfo.getInstance().getTargetArchs().get(0)));
            for (String abi : supportedAbiApk) {
                if (buildTarget.contains(abi)) continue;
                Assert.fail((String)String.format("apk %s %s does not support our abis [%s]", testApk.getName(), supportedAbiApk, buildTarget));
            }
            apkToAbi.put(testApk.getName(), supportedAbiApk.size());
            maxAbi = Math.max(maxAbi, supportedAbiApk.size());
        }
        for (Map.Entry entry : apkToAbi.entrySet()) {
            if ((Integer)entry.getValue() >= maxAbi) continue;
            Assert.fail((String)String.format("apk %s only has %s abi when it should have %s", entry.getKey(), entry.getValue(), maxAbi));
        }
    }

    @Test
    public void testBinariesAbis() {
        String ctsRoot = System.getProperty("CTS_ROOT");
        File testcases = new File(ctsRoot, "/android-cts/testcases/");
        if (!testcases.exists()) {
            Assert.fail((String)String.format("%s does not exist", testcases));
            return;
        }
        String[] listBinaries = testcases.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.contains(".")) {
                    return false;
                }
                if (BINARY_EXCEPTIONS.contains(name)) {
                    return false;
                }
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    return false;
                }
                return file.canExecute();
            }
        });
        Assert.assertTrue((listBinaries.length > 0 ? 1 : 0) != 0);
        List<String> orderedList = Arrays.asList(listBinaries);
        Collections.sort(orderedList);
        Set buildTarget = AbiUtils.getAbisForArch((String)((String)TestSuiteInfo.getInstance().getTargetArchs().get(0)));
        for (int i = 0; i < orderedList.size(); i += buildTarget.size()) {
            List<String> subSet = orderedList.subList(i, i + buildTarget.size());
            if (subSet.size() > 1) {
                String base = subSet.get(0).substring(0, subSet.get(0).length() - 2);
                for (int j = 0; j < subSet.size(); ++j) {
                    Assert.assertEquals((Object)base, (Object)subSet.get(j).substring(0, subSet.get(j).length() - 2));
                }
                continue;
            }
            String bitness = AbiUtils.getBitness((String)((String)buildTarget.iterator().next()));
            Assert.assertTrue((boolean)subSet.get(i).endsWith(bitness));
        }
    }

    static {
        MODULE_EXCEPTIONS.add("CtsSplitApp");
        MODULE_EXCEPTIONS.add("CtsCorruptApkTests");
        MODULE_EXCEPTIONS.add("CtsExtractNativeLibsAppTrue32");
        MODULE_EXCEPTIONS.add("CtsExtractNativeLibsAppTrue64");
        BINARY_EXCEPTIONS = new HashSet<String>();
        BINARY_EXCEPTIONS.add("sepolicy-analyze");
    }
}

