/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.compatibility.common.tradefed.result.ResultReporter;
import com.android.compatibility.common.util.ChecksumReporter;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;

public class ChecksumReporterTest
extends TestCase {
    private static final String ROOT_PROPERTY = "TESTS_ROOT";
    private static final String ROOT_DIR_NAME = "root";
    private static final String SUITE_NAME = "TESTS";
    private static final String BUILD_NUMBER = "2";
    private static final String SUITE_PLAN = "cts";
    private static final String BASE_DIR_NAME = "android-tests";
    private static final String TESTCASES = "testcases";
    private ChecksumReporter mReporter;
    private File mRoot = null;
    private IBuildInfo mBuildInfo;
    private ReportLog mReportLog = null;
    private IInvocationResult mInvocationResult;
    private IModuleResult mModuleResult;
    private ITestResult mFailedTest;

    public void setUp() throws Exception {
        this.mReporter = new ChecksumReporter(100, 0.001, 1);
        this.mRoot = FileUtil.createTempDir((String)ROOT_DIR_NAME);
        File baseDir = new File(this.mRoot, BASE_DIR_NAME);
        baseDir.mkdirs();
        File testDir = new File(baseDir, TESTCASES);
        testDir.mkdirs();
        System.setProperty(ROOT_PROPERTY, this.mRoot.getAbsolutePath());
        ResultReporter resultReporter = new ResultReporter();
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return ChecksumReporterTest.SUITE_NAME;
            }

            protected String getSuiteInfoBuildNumber() {
                return ChecksumReporterTest.BUILD_NUMBER;
            }

            protected String getSuiteInfoVersion() {
                return ChecksumReporterTest.BUILD_NUMBER;
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{provider});
        setter.setOptionValue("plan", SUITE_PLAN);
        setter.setOptionValue("dynamic-config-url", "");
        this.mBuildInfo = provider.getBuild();
        InvocationContext context = new InvocationContext();
        context.addDeviceBuildInfo("fakeDevice", this.mBuildInfo);
        resultReporter.invocationStarted((IInvocationContext)context);
        this.mInvocationResult = resultReporter.getResult();
        this.mModuleResult = this.mInvocationResult.getOrCreateModule("Module-1");
        this.mModuleResult.setDone(true);
        ICaseResult caseResult = this.mModuleResult.getOrCreateResult("Case-1");
        ITestResult test1 = caseResult.getOrCreateResult("Test1");
        test1.passed(this.mReportLog);
        this.mFailedTest = caseResult.getOrCreateResult("Test2");
        this.mFailedTest.failed("stack-trace - error happened");
        IModuleResult moduleResult2 = this.mInvocationResult.getOrCreateModule("Module-2");
        ICaseResult caseResult2 = moduleResult2.getOrCreateResult("Case-2");
        this.mModuleResult.setDone(false);
        ITestResult test3 = caseResult2.getOrCreateResult("Test3");
        test3.passed(this.mReportLog);
    }

    public void tearDown() throws Exception {
        this.mReporter = null;
        FileUtil.recursiveDelete((File)this.mRoot);
    }

    public void testStoreAndRetrieveTestResults() {
        this.mReporter.addInvocation(this.mInvocationResult);
        this.VerifyInvocationResults(this.mInvocationResult, this.mReporter);
    }

    public void testInvalidChecksums() {
        this.mReporter.addInvocation(this.mInvocationResult);
        IModuleResult module = (IModuleResult)this.mInvocationResult.getModules().get(1);
        module.setDone(!module.isDone());
        String fingerprint = this.mInvocationResult.getBuildFingerprint();
        ChecksumReporterTest.assertFalse((String)("Checksum should contain module: " + module.getName()), (boolean)this.mReporter.containsModuleResult(module, fingerprint));
        this.mFailedTest.setResultStatus(TestStatus.PASS);
        ChecksumReporterTest.assertFalse((String)("Checksum should not contain test: " + this.mFailedTest.getName()), (boolean)this.mReporter.containsTestResult(this.mFailedTest, this.mModuleResult, fingerprint));
        ChecksumReporterTest.assertFalse((String)"Module checksum should verify number of tests", (boolean)this.mReporter.containsModuleResult(this.mModuleResult, fingerprint));
    }

    public void testFileSerialization() throws IOException, ChecksumReporter.ChecksumValidationException {
        this.mReporter.addInvocation(this.mInvocationResult);
        File file1 = new File(this.mRoot, "file1.txt");
        try (FileWriter fileWriter = new FileWriter(file1, false);){
            fileWriter.append("This is a test file");
        }
        this.mReporter.addDirectory(this.mRoot);
        this.mReporter.saveToFile(this.mRoot);
        ChecksumReporter storedChecksum = ChecksumReporter.load((File)this.mRoot);
        this.VerifyInvocationResults(this.mInvocationResult, storedChecksum);
        ChecksumReporterTest.assertTrue((String)"Serializing checksum maintains file hash", (boolean)storedChecksum.containsFile(file1, this.mRoot.getName()));
    }

    public void testFileCRCOperations() throws IOException {
        File subDirectory = new File(this.mRoot, "child");
        subDirectory.mkdir();
        File file1 = new File(this.mRoot, "file1.txt");
        try (FileWriter fileWriter = new FileWriter(file1, false);){
            fileWriter.append("This is a test file");
        }
        File file2 = new File(subDirectory, "file2.txt");
        try (FileWriter fileWriter = new FileWriter(file2, false);){
            fileWriter.append("This is another test file with a different crc");
        }
        this.mReporter.addDirectory(this.mRoot);
        String folderName = this.mRoot.getName();
        ChecksumReporterTest.assertTrue((boolean)this.mReporter.containsFile(file1, folderName));
        ChecksumReporterTest.assertTrue((boolean)this.mReporter.containsFile(file2, folderName + "/child"));
        ChecksumReporterTest.assertFalse((String)"Should not contain non-existent file", (boolean)this.mReporter.containsFile(new File(this.mRoot, "fake.txt"), folderName));
        File file3 = new File(this.mRoot, "file3.txt");
        try (FileWriter fileWriter = new FileWriter(file3, false);){
            fileWriter.append("This is a test file added after crc calculated");
        }
        ChecksumReporterTest.assertFalse((String)"Should not contain file created after crc calculated", (boolean)this.mReporter.containsFile(file3, this.mRoot + "/"));
    }

    private void VerifyInvocationResults(IInvocationResult invocation, ChecksumReporter reporter) {
        for (IModuleResult module : invocation.getModules()) {
            String buildFingerprint = invocation.getBuildFingerprint();
            ChecksumReporterTest.assertTrue((String)("Checksum should contain module: " + module.getName()), (boolean)reporter.containsModuleResult(module, buildFingerprint));
            for (ICaseResult caseResult : module.getResults()) {
                for (ITestResult result : caseResult.getResults()) {
                    ChecksumReporterTest.assertTrue((String)("Checksum should contain test: " + result.getName()), (boolean)reporter.containsTestResult(result, module, buildFingerprint));
                }
            }
        }
    }
}

