/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.result.MetadataReporter;
import com.android.compatibility.common.util.AbiUtils;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;

public class MetadataReporterTest
extends TestCase {
    private static final String MIN_TEST_DURATION = "10";
    private static final String BUILD_NUMBER = "2";
    private static final String ROOT_DIR_NAME = "root";
    private static final String BASE_DIR_NAME = "android-tests";
    private static final String TESTCASES = "testcases";
    private static final String NAME = "ModuleName";
    private static final String ABI = "mips64";
    private static final String ID = AbiUtils.createId((String)"mips64", (String)"ModuleName");
    private static final String CLASS = "android.test.FoorBar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private MetadataReporter mReporter;
    private IBuildInfo mBuildInfo;
    private IInvocationContext mContext;
    private File mRoot = null;
    private File mBase = null;
    private File mTests = null;

    public void setUp() throws Exception {
        this.mReporter = new MetadataReporter();
        OptionSetter setter = new OptionSetter(new Object[]{this.mReporter});
        setter.setOptionValue("min-test-duration", MIN_TEST_DURATION);
        this.mRoot = FileUtil.createTempDir((String)ROOT_DIR_NAME);
        this.mBase = new File(this.mRoot, BASE_DIR_NAME);
        this.mBase.mkdirs();
        this.mTests = new File(this.mBase, TESTCASES);
        this.mTests.mkdirs();
        this.mBuildInfo = new BuildInfo(BUILD_NUMBER, "");
        this.mBuildInfo.addBuildAttribute("ROOT_DIR", this.mRoot.getAbsolutePath());
        this.mBuildInfo.addBuildAttribute("SUITE_NAME", "tests");
        this.mBuildInfo.addBuildAttribute("START_TIME_MS", "0");
        this.mContext = new InvocationContext();
        this.mContext.addDeviceBuildInfo("fakeDevice", this.mBuildInfo);
    }

    public void tearDown() throws Exception {
        this.mReporter = null;
        FileUtil.recursiveDelete((File)this.mRoot);
    }

    public void testResultReportingFastTests() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 3);
        this.runTests(0L);
        Collection metadata = this.mReporter.getTestMetadata();
        MetadataReporterTest.assertTrue((boolean)metadata.isEmpty());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
    }

    public void testResultReportingSlowTests() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 3);
        this.runTests(50L);
        Collection metadata = this.mReporter.getTestMetadata();
        MetadataReporterTest.assertEquals((int)metadata.size(), (int)2);
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
    }

    private void runTests(long waitTime) {
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        RunUtil.getDefault().sleep(waitTime);
        this.mReporter.testEnded(test1, new HashMap());
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        RunUtil.getDefault().sleep(waitTime);
        this.mReporter.testEnded(test1, new HashMap());
        TestDescription test3 = new TestDescription(CLASS, METHOD_3);
        this.mReporter.testStarted(test3);
        RunUtil.getDefault().sleep(waitTime);
        this.mReporter.testFailed(test3, STACK_TRACE);
        this.mReporter.testEnded(test3, new HashMap());
        TestDescription test4 = new TestDescription(CLASS, METHOD_3);
        this.mReporter.testStarted(test4);
        RunUtil.getDefault().sleep(waitTime);
        this.mReporter.testIgnored(test4);
        this.mReporter.testEnded(test4, new HashMap());
    }
}

