/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.compatibility.common.tradefed.result.ResultReporter;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.result.ByteArrayInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;

public class ResultReporterTest
extends TestCase {
    private static final String ROOT_PROPERTY = "TESTS_ROOT";
    private static final String SUITE_NAME = "TESTS";
    private static final String BUILD_NUMBER = "2";
    private static final String SUITE_PLAN = "cts";
    private static final String DYNAMIC_CONFIG_URL = "";
    private static final String ROOT_DIR_NAME = "root";
    private static final String BASE_DIR_NAME = "android-tests";
    private static final String TESTCASES = "testcases";
    private static final String NAME = "ModuleName";
    private static final String ABI = "mips64";
    private static final String ID = AbiUtils.createId((String)"mips64", (String)"ModuleName");
    private static final String CLASS = "android.test.FoorBar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String TEST_1 = String.format("%s#%s", "android.test.FoorBar", "testBlah1");
    private static final String TEST_2 = String.format("%s#%s", "android.test.FoorBar", "testBlah2");
    private static final String TEST_3 = String.format("%s#%s", "android.test.FoorBar", "testBlah3");
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private static final String RESULT_DIR = "result123";
    private static final String[] FORMATTING_FILES = new String[]{"compatibility_result.css", "compatibility_result.xsl", "logo.png"};
    private ResultReporter mReporter;
    private IBuildInfo mBuildInfo;
    private IInvocationContext mContext;
    private CompatibilityBuildHelper mBuildHelper;
    private File mRoot = null;
    private File mBase = null;
    private File mTests = null;

    public void setUp() throws Exception {
        this.mReporter = new ResultReporter();
        this.mRoot = FileUtil.createTempDir((String)ROOT_DIR_NAME);
        this.mBase = new File(this.mRoot, BASE_DIR_NAME);
        this.mBase.mkdirs();
        this.mTests = new File(this.mBase, TESTCASES);
        this.mTests.mkdirs();
        System.setProperty(ROOT_PROPERTY, this.mRoot.getAbsolutePath());
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return ResultReporterTest.SUITE_NAME;
            }

            protected String getSuiteInfoBuildNumber() {
                return ResultReporterTest.BUILD_NUMBER;
            }

            protected String getSuiteInfoVersion() {
                return ResultReporterTest.BUILD_NUMBER;
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{provider});
        setter.setOptionValue("plan", SUITE_PLAN);
        setter.setOptionValue("dynamic-config-url", DYNAMIC_CONFIG_URL);
        this.mBuildInfo = provider.getBuild();
        this.mBuildHelper = new CompatibilityBuildHelper(this.mBuildInfo);
        this.mContext = new InvocationContext();
        this.mContext.addDeviceBuildInfo("fakeDevice", this.mBuildInfo);
    }

    public void tearDown() throws Exception {
        this.mReporter = null;
        FileUtil.recursiveDelete((File)this.mRoot);
    }

    public void testSetup() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        File[] children = this.mBuildHelper.getLogsDir().listFiles();
        ResultReporterTest.assertTrue((String)"Didn't create logs dir", (children.length == 1 && children[0].isDirectory() ? 1 : 0) != 0);
        children = this.mBuildHelper.getResultsDir().listFiles();
        ResultReporterTest.assertTrue((String)"Didn't create results dir", (children.length == 1 && children[0].isDirectory() ? 1 : 0) != 0);
        this.mReporter.invocationEnded(10L);
        children = this.mBuildHelper.getResultsDir().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".zip");
            }
        });
        ResultReporterTest.assertTrue((String)"Didn't create results zip", (children.length == 1 && children[0].isFile() && children[0].length() > 0L ? 1 : 0) != 0);
    }

    public void testResultReporting() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 2);
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        this.mReporter.testEnded(test1, new HashMap());
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        this.mReporter.testFailed(test2, STACK_TRACE);
        TestDescription test3 = new TestDescription(CLASS, METHOD_3);
        this.mReporter.testStarted(test3);
        this.mReporter.testFailed(test3, STACK_TRACE);
        this.mReporter.testEnded(test3, new HashMap());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 1 pass", (int)1, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 2 failures", (int)2, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertTrue((boolean)module.isDone());
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        List caseResults = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test case", (int)1, (int)caseResults.size());
        ICaseResult caseResult = (ICaseResult)caseResults.get(0);
        List testResults = caseResult.getResults();
        ResultReporterTest.assertEquals((String)"Expected 3 tests", (int)3, (int)testResults.size());
        ITestResult result1 = caseResult.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)result1);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_1), (Object)TestStatus.PASS, (Object)result1.getResultStatus());
        ITestResult result2 = caseResult.getResult(METHOD_2);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_2), (Object)result2);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_2), (Object)TestStatus.FAIL, (Object)result2.getResultStatus());
        ITestResult result3 = caseResult.getResult(METHOD_3);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_3), (Object)result3);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_3), (Object)TestStatus.FAIL, (Object)result3.getResultStatus());
    }

    private void makeTestRun(String[] methods, boolean[] passes) {
        this.mReporter.testRunStarted(ID, methods.length);
        for (int i = 0; i < methods.length; ++i) {
            TestDescription test = new TestDescription(CLASS, methods[i]);
            this.mReporter.testStarted(test);
            if (!passes[i]) {
                this.mReporter.testFailed(test, STACK_TRACE);
            }
            this.mReporter.testEnded(test, new HashMap());
        }
        this.mReporter.testRunEnded(10L, new HashMap());
    }

    public void testRepeatedExecutions() throws Exception {
        String[] methods = new String[]{METHOD_1, METHOD_2, METHOD_3};
        this.mReporter.invocationStarted(this.mContext);
        this.makeTestRun(methods, new boolean[]{true, false, true});
        this.makeTestRun(methods, new boolean[]{true, false, false});
        this.makeTestRun(methods, new boolean[]{true, true, true});
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 1 pass", (int)1, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 2 failures", (int)2, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        List caseResults = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test case", (int)1, (int)caseResults.size());
        ICaseResult caseResult = (ICaseResult)caseResults.get(0);
        List testResults = caseResult.getResults();
        ResultReporterTest.assertEquals((String)"Expected 3 tests", (int)3, (int)testResults.size());
        ITestResult result1 = caseResult.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)result1);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_1), (Object)TestStatus.PASS, (Object)result1.getResultStatus());
        ITestResult result2 = caseResult.getResult(METHOD_2);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_2), (Object)result2);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_2), (Object)TestStatus.FAIL, (Object)result2.getResultStatus());
        ResultReporterTest.assertEquals((String)result2.getStackTrace(), (String)STACK_TRACE);
        ITestResult result3 = caseResult.getResult(METHOD_3);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_3), (Object)result3);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_3), (Object)TestStatus.FAIL, (Object)result3.getResultStatus());
        ResultReporterTest.assertEquals((String)result3.getStackTrace(), (String)STACK_TRACE);
    }

    public void testRetry() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 2);
        IInvocationResult invocationResult = this.mReporter.getResult();
        IModuleResult moduleResult = invocationResult.getOrCreateModule(ID);
        ICaseResult caseResult = moduleResult.getOrCreateResult(CLASS);
        ITestResult testResult1 = caseResult.getOrCreateResult(METHOD_1);
        testResult1.setResultStatus(TestStatus.PASS);
        testResult1.setRetry(true);
        ITestResult testResult2 = caseResult.getOrCreateResult(METHOD_2);
        testResult2.setResultStatus(TestStatus.FAIL);
        testResult2.setStackTrace(STACK_TRACE);
        testResult2.setRetry(true);
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        this.mReporter.testFailed(test1, STACK_TRACE);
        this.mReporter.testEnded(test1, new HashMap());
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        this.mReporter.testEnded(test2, new HashMap());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 1 pass", (int)1, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 1 failure", (int)1, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        List cases = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test case", (int)1, (int)cases.size());
        ICaseResult case1 = (ICaseResult)cases.get(0);
        List testResults = case1.getResults();
        ResultReporterTest.assertEquals((String)"Expected 2 tests", (int)2, (int)testResults.size());
        ITestResult finalTestResult1 = case1.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)finalTestResult1);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_1), (Object)TestStatus.FAIL, (Object)finalTestResult1.getResultStatus());
        ResultReporterTest.assertEquals((String)finalTestResult1.getStackTrace(), (String)STACK_TRACE);
        ITestResult finalTestResult2 = case1.getResult(METHOD_2);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_2), (Object)finalTestResult2);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_2), (Object)TestStatus.PASS, (Object)finalTestResult2.getResultStatus());
    }

    public void testRetryCanSetDone() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.mCanMarkDone = true;
        IInvocationResult invocationResult = this.mReporter.getResult();
        IModuleResult moduleResult = invocationResult.getOrCreateModule(ID);
        moduleResult.initializeDone(false);
        ICaseResult caseResult = moduleResult.getOrCreateResult(CLASS);
        ITestResult testResult1 = caseResult.getOrCreateResult(METHOD_1);
        testResult1.setResultStatus(TestStatus.PASS);
        testResult1.setRetry(true);
        ITestResult testResult2 = caseResult.getOrCreateResult(METHOD_2);
        testResult2.setResultStatus(TestStatus.FAIL);
        testResult2.setStackTrace(STACK_TRACE);
        testResult2.setRetry(true);
        this.mReporter.testRunStarted(ID, 1);
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        this.mReporter.testEnded(test2, new HashMap());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 2 pass", (int)2, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertTrue((String)"Module should be marked done", (boolean)module.isDone());
    }

    public void testRetryCannotSetDone() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.mCanMarkDone = false;
        IInvocationResult invocationResult = this.mReporter.getResult();
        IModuleResult moduleResult = invocationResult.getOrCreateModule(ID);
        moduleResult.setDone(false);
        ICaseResult caseResult = moduleResult.getOrCreateResult(CLASS);
        ITestResult testResult1 = caseResult.getOrCreateResult(METHOD_1);
        testResult1.setResultStatus(TestStatus.PASS);
        testResult1.setRetry(true);
        ITestResult testResult2 = caseResult.getOrCreateResult(METHOD_2);
        testResult2.setResultStatus(TestStatus.FAIL);
        testResult2.setStackTrace(STACK_TRACE);
        testResult2.setRetry(true);
        this.mReporter.testRunStarted(ID, 1);
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        this.mReporter.testEnded(test2, new HashMap());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 2 pass", (int)2, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertFalse((String)"Module should not be marked done", (boolean)module.isDone());
    }

    public void testResultReporting_moduleNotDone() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 2);
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        this.mReporter.testEnded(test1, new HashMap());
        this.mReporter.testRunFailed("error");
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 1 pass", (int)1, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertFalse((boolean)module.isDone());
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        List caseResults = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test case", (int)1, (int)caseResults.size());
        ICaseResult caseResult = (ICaseResult)caseResults.get(0);
        List testResults = caseResult.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 tests", (int)1, (int)testResults.size());
        ITestResult result1 = caseResult.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)result1);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_1), (Object)TestStatus.PASS, (Object)result1.getResultStatus());
    }

    public void testResultReporting_moduleNotDone_noTests() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 0);
        this.mReporter.testRunFailed("error");
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 0 pass", (int)0, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        ResultReporterTest.assertFalse((boolean)module.isDone());
    }

    public void testResultReporting_moduleDone_noTests() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 0);
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 0 pass", (int)0, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        ResultReporterTest.assertTrue((boolean)module.isDone());
    }

    public void testCopyFormattingFiles() throws Exception {
        File resultDir = new File(this.mBuildHelper.getResultsDir(), RESULT_DIR);
        resultDir.mkdirs();
        ResultReporter.copyFormattingFiles((File)resultDir, (String)SUITE_NAME);
        for (String filename : FORMATTING_FILES) {
            File file = new File(resultDir, filename);
            ResultReporterTest.assertTrue((String)String.format("%s (%s) was not created", filename, file.getAbsolutePath()), (file.exists() && file.isFile() && file.length() > 0L ? 1 : 0) != 0);
        }
    }

    public void testTestLog() throws Exception {
        ByteArrayInputStreamSource fakeData = new ByteArrayInputStreamSource("test".getBytes());
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testLog("test1", LogDataType.LOGCAT, (InputStreamSource)fakeData);
        ResultReporterTest.assertEquals((int)1, (int)this.mBuildHelper.getLogsDir().list().length);
        ResultReporterTest.assertEquals((int)1, (int)this.mBuildHelper.getLogsDir().listFiles()[0].list().length);
        ResultReporterTest.assertEquals((int)1, (int)this.mBuildHelper.getLogsDir().listFiles()[0].listFiles()[0].list().length);
        this.mReporter.testLog("test2", LogDataType.LOGCAT, (InputStreamSource)fakeData);
        ResultReporterTest.assertEquals((int)1, (int)this.mBuildHelper.getLogsDir().list().length);
        ResultReporterTest.assertEquals((int)1, (int)this.mBuildHelper.getLogsDir().listFiles()[0].list().length);
        ResultReporterTest.assertEquals((int)2, (int)this.mBuildHelper.getLogsDir().listFiles()[0].listFiles()[0].list().length);
    }

    public void testTestLogWithDeviceInfo() throws Exception {
        ByteArrayInputStreamSource fakeData = new ByteArrayInputStreamSource("test".getBytes());
        String deviceInfoName = String.format("Test%s", ".deviceinfo.json");
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testLog(deviceInfoName, LogDataType.TEXT, (InputStreamSource)fakeData);
        File deviceInfoFolder = new File(this.mBuildHelper.getResultDir(), "device-info-files");
        ResultReporterTest.assertTrue((boolean)deviceInfoFolder.exists());
        File[] deviceInfoFiles = deviceInfoFolder.listFiles();
        ResultReporterTest.assertEquals((int)1, (int)deviceInfoFiles.length);
        File deviceInfoFile = deviceInfoFiles[0];
        ResultReporterTest.assertEquals((String)deviceInfoName, (String)deviceInfoFile.getName());
        ResultReporterTest.assertEquals((String)"test", (String)FileUtil.readStringFromFile((File)deviceInfoFile));
    }

    public void testResultReporter_sharded() throws Exception {
        ResultReporter shard1 = new ResultReporter(this.mReporter);
        ResultReporter shard2 = new ResultReporter(this.mReporter);
        this.mReporter.invocationStarted(this.mContext);
        shard1.invocationStarted(this.mContext);
        shard2.invocationStarted(this.mContext);
        shard1.testRunStarted(ID, 1);
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        shard1.testStarted(test1);
        shard1.testEnded(test1, new HashMap());
        shard1.testRunEnded(10L, new HashMap());
        shard1.invocationEnded(10L);
        shard2.testRunStarted(ID, 2);
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        shard2.testStarted(test2);
        shard2.testEnded(test2, new HashMap());
        shard2.testRunFailed("error");
        shard2.testRunEnded(10L, new HashMap());
        shard2.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 2 pass", (int)2, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 0 failures", (int)0, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        ResultReporterTest.assertFalse((boolean)module.isDone());
        ResultReporterTest.assertTrue((boolean)module.isFailed());
        ResultReporterTest.assertEquals((String)"Incorrect ID", (String)ID, (String)module.getId());
        List caseResults = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test run", (int)1, (int)caseResults.size());
        ICaseResult caseResult = (ICaseResult)caseResults.get(0);
        List testResults = caseResult.getResults();
        ResultReporterTest.assertEquals((String)"Expected 2 test cases", (int)2, (int)testResults.size());
        ITestResult result1 = caseResult.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)result1);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_1), (Object)TestStatus.PASS, (Object)result1.getResultStatus());
    }

    public void testRetryWithRunHistory() throws Exception {
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.testRunStarted(ID, 2);
        IInvocationResult invocationResult = this.mReporter.getResult();
        IModuleResult moduleResult = invocationResult.getOrCreateModule(ID);
        ICaseResult caseResult = moduleResult.getOrCreateResult(CLASS);
        ITestResult testResult1 = caseResult.getOrCreateResult(METHOD_1);
        testResult1.setResultStatus(TestStatus.PASS);
        testResult1.setRetry(true);
        ITestResult testResult2 = caseResult.getOrCreateResult(METHOD_2);
        testResult2.setResultStatus(TestStatus.FAIL);
        testResult2.setStackTrace(STACK_TRACE);
        testResult2.setRetry(true);
        invocationResult.addInvocationInfo("run_history", "[{\"startTime\":1,\"endTime\":2},{\"startTime\":3,\"endTime\":4}]");
        TestDescription test1 = new TestDescription(CLASS, METHOD_1);
        this.mReporter.testStarted(test1);
        this.mReporter.testFailed(test1, STACK_TRACE);
        this.mReporter.testEnded(test1, new HashMap());
        TestDescription test2 = new TestDescription(CLASS, METHOD_2);
        this.mReporter.testStarted(test2);
        this.mReporter.testEnded(test2, new HashMap());
        this.mReporter.testRunEnded(10L, new HashMap());
        this.mReporter.invocationEnded(10L);
        IInvocationResult result = this.mReporter.getResult();
        ResultReporterTest.assertEquals((String)"Expected 1 pass", (int)1, (int)result.countResults(TestStatus.PASS));
        ResultReporterTest.assertEquals((String)"Expected 1 failure", (int)1, (int)result.countResults(TestStatus.FAIL));
        List modules = result.getModules();
        ResultReporterTest.assertEquals((String)"Expected 1 module", (int)1, (int)modules.size());
        IModuleResult module = (IModuleResult)modules.get(0);
        List cases = module.getResults();
        ResultReporterTest.assertEquals((String)"Expected 1 test case", (int)1, (int)cases.size());
        ICaseResult case1 = (ICaseResult)cases.get(0);
        List testResults = case1.getResults();
        ResultReporterTest.assertEquals((String)"Expected 2 tests", (int)2, (int)testResults.size());
        long startTime = this.mReporter.getResult().getStartTime();
        String expectedRunHistory = String.format("[{\"startTime\":1,\"endTime\":2},{\"startTime\":3,\"endTime\":4},{\"startTime\":%d,\"endTime\":%d}]", startTime, startTime + 10L);
        ResultReporterTest.assertEquals((String)expectedRunHistory, (String)((String)invocationResult.getInvocationInfo().get("run_history")));
        ITestResult finalTestResult1 = case1.getResult(METHOD_1);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_1), (Object)finalTestResult1);
        ResultReporterTest.assertEquals((String)String.format("Expected fail for %s", TEST_1), (Object)TestStatus.FAIL, (Object)finalTestResult1.getResultStatus());
        ResultReporterTest.assertEquals((String)finalTestResult1.getStackTrace(), (String)STACK_TRACE);
        ITestResult finalTestResult2 = case1.getResult(METHOD_2);
        ResultReporterTest.assertNotNull((String)String.format("Expected result for %s", TEST_2), (Object)finalTestResult2);
        ResultReporterTest.assertEquals((String)String.format("Expected pass for %s", TEST_2), (Object)TestStatus.PASS, (Object)finalTestResult2.getResultStatus());
    }
}

