/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.result.suite.CertificationChecksumHelper;
import com.android.compatibility.common.util.ChecksumReporter;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CertificationChecksumHelperTest {
    private static final String FINGERPRINT = "thisismyfingerprint";
    private File mWorkingDir;
    private File mFakeLogFile;

    @Before
    public void setUp() throws Exception {
        this.mWorkingDir = FileUtil.createTempDir((String)"certification-tests");
        this.mFakeLogFile = FileUtil.createTempFile((String)"fake-log-file", (String)".xml", (File)this.mWorkingDir);
        FileUtil.writeToFile((String)"Bunch of data to make the file unique", (File)this.mFakeLogFile);
    }

    @After
    public void tearDown() {
        FileUtil.recursiveDelete((File)this.mWorkingDir);
    }

    @Test
    public void testCreateChecksum() throws ChecksumReporter.ChecksumValidationException {
        ArrayList<TestRunResult> results = new ArrayList<TestRunResult>();
        TestRunResult run1 = this.createFakeResults("run1", 2);
        results.add(run1);
        TestRunResult run2 = this.createFakeResults("run2", 3);
        results.add(run2);
        boolean res = CertificationChecksumHelper.tryCreateChecksum((File)this.mWorkingDir, results, (String)FINGERPRINT);
        Assert.assertTrue((boolean)res);
        File checksum = new File(this.mWorkingDir, "checksum-suite.data");
        Assert.assertTrue((boolean)checksum.exists());
        CertificationChecksumHelper parser = new CertificationChecksumHelper(this.mWorkingDir, FINGERPRINT);
        Assert.assertTrue((boolean)parser.containsFile(this.mFakeLogFile, this.mWorkingDir.getName()));
        for (Map.Entry entry : run1.getTestResults().entrySet()) {
            Assert.assertTrue((boolean)parser.containsTestResult(entry, run1, FINGERPRINT));
        }
        for (Map.Entry entry : run2.getTestResults().entrySet()) {
            Assert.assertTrue((boolean)parser.containsTestResult(entry, run2, FINGERPRINT));
        }
    }

    private TestRunResult createFakeResults(String runName, int testCount) {
        TestRunResult results = new TestRunResult();
        results.testRunStarted(runName, testCount);
        for (int i = 0; i < testCount; ++i) {
            TestDescription test = new TestDescription("com.class.path", "testMethod" + i);
            results.testStarted(test);
            results.testEnded(test, new HashMap());
        }
        results.testRunEnded(500L, new HashMap());
        return results;
    }
}

