/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationSuiteResultReporter;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CertificationSuiteResultReporterTest {
    private CertificationSuiteResultReporter mReporter;
    private IConfiguration mConfiguration;
    private IInvocationContext mContext;
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir;
    private File mFakeDir;

    @Before
    public void setUp() throws Exception {
        this.mFakeDir = FileUtil.createTempDir((String)"result-dir");
        this.mResultDir = new File(this.mFakeDir, "android-cts/results");
        this.mResultDir.mkdirs();
        BuildInfo info = new BuildInfo();
        info.addBuildAttribute("ROOT_DIR", this.mFakeDir.getAbsolutePath());
        info.addBuildAttribute("START_TIME_MS", Long.toString(System.currentTimeMillis()));
        this.mContext = new InvocationContext();
        this.mContext.addDeviceBuildInfo("DEFAULT_DEVICE", (IBuildInfo)info);
        this.mBuildHelper = new CompatibilityBuildHelper((IBuildInfo)info){

            public String getSuiteName() {
                return "CTS";
            }

            public String getSuiteVersion() {
                return "version";
            }

            public String getSuitePlan() {
                return "cts";
            }

            public String getSuiteBuild() {
                return "R1";
            }
        };
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.mFakeDir);
    }

    @Test
    public void testSuiteVariant() throws Exception {
        this.mConfiguration = new Configuration("test", "test");
        this.mConfiguration.setCommandLine(new String[]{"cts", "-m", "CtsGestureTestCases"});
        this.mReporter = new CertificationSuiteResultReporter(){

            CompatibilityBuildHelper createBuildHelper() {
                return CertificationSuiteResultReporterTest.this.mBuildHelper;
            }
        };
        this.mReporter.setConfiguration(this.mConfiguration);
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.invocationEnded(500L);
        File reportFile = new File(this.mBuildHelper.getResultDir(), "test_result.xml");
        Assert.assertTrue((boolean)reportFile.exists());
        String content = FileUtil.readStringFromFile((File)reportFile);
        Assert.assertTrue((boolean)content.contains("suite_name=\"CTS\""));
        Assert.assertTrue((boolean)content.contains("suite_variant=\"CTS\""));
        Assert.assertTrue((boolean)content.contains("suite_version=\"version\""));
    }

    @Test
    public void testSuiteVariantGSI() throws Exception {
        this.mConfiguration = new Configuration("test", "test");
        this.mConfiguration.setCommandLine(new String[]{"cts-on-gsi"});
        this.mReporter = new CertificationSuiteResultReporter(){

            CompatibilityBuildHelper createBuildHelper() {
                return CertificationSuiteResultReporterTest.this.mBuildHelper;
            }
        };
        this.mReporter.setConfiguration(this.mConfiguration);
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.invocationEnded(500L);
        File reportFile = new File(this.mBuildHelper.getResultDir(), "test_result.xml");
        Assert.assertTrue((boolean)reportFile.exists());
        String content = FileUtil.readStringFromFile((File)reportFile);
        Assert.assertTrue((boolean)content.contains("suite_name=\"CTS\""));
        Assert.assertTrue((boolean)content.contains("suite_variant=\"CTS_ON_GSI\""));
        Assert.assertTrue((boolean)content.contains("suite_version=\"version\""));
    }

    @Test
    public void testSuiteVariantGSI_R_Compatibility() throws Exception {
        this.mConfiguration = new Configuration("test", "test");
        this.mConfiguration.setCommandLine(new String[]{"cts-on-gsi"});
        this.mReporter = new CertificationSuiteResultReporter(){

            CompatibilityBuildHelper createBuildHelper() {
                return CertificationSuiteResultReporterTest.this.mBuildHelper;
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{this.mReporter});
        setter.setOptionValue("cts-on-gsi-variant", "true");
        this.mReporter.setConfiguration(this.mConfiguration);
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.invocationEnded(500L);
        File reportFile = new File(this.mBuildHelper.getResultDir(), "test_result.xml");
        Assert.assertTrue((boolean)reportFile.exists());
        String content = FileUtil.readStringFromFile((File)reportFile);
        Assert.assertTrue((boolean)content.contains("suite_name=\"VTS\""));
        Assert.assertTrue((boolean)content.contains("suite_variant=\"CTS_ON_GSI\""));
        Assert.assertTrue((boolean)content.contains("suite_version=\"version\""));
        Assert.assertTrue((boolean)new File(this.mBuildHelper.getResultDir(), "test_result.html").exists());
    }

    @Test
    public void testSuiteVariantGSI_R_Compatibility_ATS() throws Exception {
        this.mConfiguration = new Configuration("test", "test");
        this.mConfiguration.setCommandLine(new String[]{"_cts-on-gsi.xml"});
        this.mReporter = new CertificationSuiteResultReporter(){

            CompatibilityBuildHelper createBuildHelper() {
                return CertificationSuiteResultReporterTest.this.mBuildHelper;
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{this.mReporter});
        setter.setOptionValue("cts-on-gsi-variant", "true");
        this.mReporter.setConfiguration(this.mConfiguration);
        this.mReporter.invocationStarted(this.mContext);
        this.mReporter.invocationEnded(500L);
        File reportFile = new File(this.mBuildHelper.getResultDir(), "test_result.xml");
        Assert.assertTrue((boolean)reportFile.exists());
        String content = FileUtil.readStringFromFile((File)reportFile);
        Assert.assertTrue((boolean)content.contains("suite_name=\"VTS\""));
        Assert.assertTrue((boolean)content.contains("suite_version=\"version\""));
    }
}

