/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.PreviousResultLoader;
import com.android.compatibility.common.tradefed.targetprep.BuildFingerPrintPreparer;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IBuildProvider;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.proto.TestRecordProto;
import com.android.tradefed.targetprep.ITargetPreparer;
import com.android.tradefed.util.FileUtil;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PreviousResultLoaderTest {
    public static final String RUN_HISTORY_KEY = "run_history";
    private PreviousResultLoader mLoader;
    private IInvocationContext mContext;
    private File mRootDir;
    private File mProtoFile;
    private ITestDevice mMockDevice;
    private IBuildProvider mMockProvider;

    @Before
    public void setUp() throws Exception {
        this.mMockProvider = (IBuildProvider)EasyMock.createMock(IBuildProvider.class);
        this.mLoader = new PreviousResultLoader();
        this.mLoader.setProvider(this.mMockProvider);
        OptionSetter setter = new OptionSetter(new Object[]{this.mLoader});
        setter.setOptionValue("retry", "0");
        this.mContext = new InvocationContext();
        this.mContext.setConfigurationDescriptor(new ConfigurationDescriptor());
        this.mContext.addInvocationAttribute("command_line_args", "cts -m CtsGesture --skip-all-system-status-check");
        this.mContext.addDeviceBuildInfo("DEFAULT_DEVICE", (IBuildInfo)new BuildInfo());
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.mRootDir);
    }

    @Test
    public void testReloadTests_failed() throws Exception {
        EasyMock.expect((Object)this.mMockProvider.getBuild()).andReturn((Object)this.createFakeBuild("", false));
        this.mProtoFile.delete();
        try {
            EasyMock.replay((Object[])new Object[]{this.mMockProvider});
            this.mLoader.init();
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException expected) {
            Assert.assertEquals((Object)"Could not find any test-record.pb to load.", (Object)expected.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.mMockProvider});
    }

    @Test
    public void testReloadTests() throws Exception {
        String EXPECTED_RUN_HISTORY = "[{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user.android.com\"}]";
        EasyMock.expect((Object)this.mMockProvider.getBuild()).andReturn((Object)this.createFakeBuild(this.createBasicResults(), false));
        this.mContext.addAllocatedDevice("DEFAULT_DEVICE", this.mMockDevice);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
        this.mLoader.init();
        Assert.assertEquals((Object)"cts -m CtsGesture --skip-all-system-status-check", (Object)this.mLoader.getCommandLine());
        Configuration config = new Configuration("name", "desc");
        Assert.assertEquals((long)0L, (long)config.getTargetPreparers().size());
        this.mLoader.customizeConfiguration((IConfiguration)config);
        Assert.assertEquals((long)1L, (long)config.getTargetPreparers().size());
        ITargetPreparer preparer = (ITargetPreparer)config.getTargetPreparers().get(0);
        Assert.assertTrue((boolean)(preparer instanceof BuildFingerPrintPreparer));
        Assert.assertEquals((Object)"testfingerprint", (Object)((BuildFingerPrintPreparer)preparer).getExpectedFingerprint());
        String runHistory = (String)config.getCommandOptions().getInvocationData().getUniqueMap().get(RUN_HISTORY_KEY);
        Assert.assertEquals((Object)"[{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user.android.com\"}]", (Object)runHistory);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
    }

    @Test
    public void testReloadTests_withMultiProto() throws Exception {
        String EXPECTED_RUN_HISTORY = "[{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user.android.com\"}]";
        EasyMock.expect((Object)this.mMockProvider.getBuild()).andReturn((Object)this.createFakeBuild(this.createBasicResults(), true));
        this.mContext.addAllocatedDevice("DEFAULT_DEVICE", this.mMockDevice);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
        this.mLoader.init();
        Assert.assertEquals((Object)"cts -m CtsGesture --skip-all-system-status-check", (Object)this.mLoader.getCommandLine());
        CollectingTestListener listener = this.mLoader.loadPreviousResults();
        Assert.assertNotNull((Object)listener);
        Configuration config = new Configuration("name", "desc");
        Assert.assertEquals((long)0L, (long)config.getTargetPreparers().size());
        this.mLoader.customizeConfiguration((IConfiguration)config);
        Assert.assertEquals((long)1L, (long)config.getTargetPreparers().size());
        ITargetPreparer preparer = (ITargetPreparer)config.getTargetPreparers().get(0);
        Assert.assertTrue((boolean)(preparer instanceof BuildFingerPrintPreparer));
        Assert.assertEquals((Object)"testfingerprint", (Object)((BuildFingerPrintPreparer)preparer).getExpectedFingerprint());
        String runHistory = (String)config.getCommandOptions().getInvocationData().getUniqueMap().get(RUN_HISTORY_KEY);
        Assert.assertEquals((Object)"[{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user.android.com\"}]", (Object)runHistory);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
    }

    @Test
    public void testReloadTests_withRunHistory() throws Exception {
        String RUN_HISTORY_1 = "{\"startTime\":1000000000000,\"endTime\":1000000010000,\"passedTests\":10,\"failedTests\":5,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user1.android.com\"}";
        String RUN_HISTORY_2 = "{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check --shard-count 5\",\"hostName\":\"user2.android.com\"}";
        String OLD_RUN_HISTORY = String.format("[%s]", "{\"startTime\":1000000000000,\"endTime\":1000000010000,\"passedTests\":10,\"failedTests\":5,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user1.android.com\"}");
        String EXPECTED_RUN_HISTORY = String.format("[%s,%s]", "{\"startTime\":1000000000000,\"endTime\":1000000010000,\"passedTests\":10,\"failedTests\":5,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check\",\"hostName\":\"user1.android.com\"}", "{\"startTime\":1530218251501,\"endTime\":1530218261061,\"passedTests\":0,\"failedTests\":0,\"commandLineArgs\":\"cts -m CtsGesture --skip-all-system-status-check --shard-count 5\",\"hostName\":\"user2.android.com\"}");
        this.mContext.addInvocationAttribute(RUN_HISTORY_KEY, OLD_RUN_HISTORY);
        EasyMock.expect((Object)this.mMockProvider.getBuild()).andReturn((Object)this.createFakeBuild(this.createResultsWithRunHistory(), false));
        this.mContext.addAllocatedDevice("DEFAULT_DEVICE", this.mMockDevice);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
        this.mLoader.init();
        Configuration config = new Configuration("name", "desc");
        this.mLoader.customizeConfiguration((IConfiguration)config);
        String runHistory = (String)config.getCommandOptions().getInvocationData().getUniqueMap().get(RUN_HISTORY_KEY);
        Assert.assertEquals((Object)EXPECTED_RUN_HISTORY, (Object)runHistory);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockProvider});
    }

    private IBuildInfo createFakeBuild(String resultContent, boolean index) throws Exception {
        DeviceBuildInfo build = new DeviceBuildInfo();
        build.addBuildAttribute("SUITE_NAME", "CTS");
        this.mRootDir = FileUtil.createTempDir((String)"cts-root-dir");
        new File(this.mRootDir, "android-cts/results/").mkdirs();
        build.addBuildAttribute("ROOT_DIR", this.mRootDir.getAbsolutePath());
        long time = System.currentTimeMillis();
        build.addBuildAttribute("START_TIME_MS", Long.toString(time));
        new CompatibilityBuildHelper((IBuildInfo)build).getResultDir().mkdirs();
        File testResult = new File(new CompatibilityBuildHelper((IBuildInfo)build).getResultDir(), "test_result.xml");
        testResult.createNewFile();
        File protoDir = new File(new CompatibilityBuildHelper((IBuildInfo)build).getResultDir(), "proto");
        protoDir.mkdir();
        this.mProtoFile = index ? new File(protoDir, "test-record.pb0") : new File(protoDir, "test-record.pb");
        TestRecordProto.TestRecord.Builder builder = TestRecordProto.TestRecord.newBuilder();
        builder.setDescription(Any.pack((Message)this.mContext.toProto()));
        builder.build().writeDelimitedTo((OutputStream)new FileOutputStream(this.mProtoFile));
        FileUtil.writeToFile((String)resultContent, (File)testResult);
        return build;
    }

    private String createBasicResults() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='UTF-8' standalone='no' ?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"?>\n");
        sb.append("<Result start=\"1530218251501\" end=\"1530218261061\" start_display=\"Thu Jun 28 13:37:31 PDT 2018\" end_display=\"Thu Jun 28 13:37:41 PDT 2018\" command_line_args=\"cts -m CtsGesture --skip-all-system-status-check\" suite_name=\"CTS\" suite_version=\"9.0_r1\" suite_plan=\"cts\" suite_build_number=\"8888\" report_version=\"5.0\" devices=\"HT6570300047\" host_name=\"user.android.com\">\n");
        sb.append("  <Build command_line_args=\"cts -m CtsGesture --skip-all-system-status-check\" build_vendor_fingerprint=\"vendorFingerprint\"  build_reference_fingerprint=\"\"  build_fingerprint=\"testfingerprint\"/>\n");
        sb.append("  <Summary pass=\"0\" failed=\"0\" modules_done=\"2\" modules_total=\"2\" />\n");
        sb.append("  <Module name=\"CtsGestureTestCases\" abi=\"arm64-v8a\" runtime=\"2776\" done=\"true\" pass=\"0\" total_tests=\"0\" />\n");
        sb.append("  <Module name=\"CtsGestureTestCases\" abi=\"armeabi-v7a\" runtime=\"2776\" done=\"true\" pass=\"0\" total_tests=\"0\" />\n");
        sb.append("</Result>");
        return sb.toString();
    }

    private String createResultsWithRunHistory() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version='1.0' encoding='UTF-8' standalone='no' ?>\n");
        sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"?>\n");
        sb.append("<Result start=\"1530218251501\" end=\"1530218261061\" start_display=\"Thu Jun 28 13:37:31 PDT 2018\" end_display=\"Thu Jun 28 13:37:41 PDT 2018\" command_line_args=\"cts -m CtsGesture --skip-all-system-status-check --shard-count 5\" suite_name=\"CTS\" suite_version=\"9.0_r1\" suite_plan=\"cts\" suite_build_number=\"8888\" report_version=\"5.0\" devices=\"HT6570300047\" host_name=\"user2.android.com\" >\n");
        String RUN_HISTORY_JSON = "[{'startTime':1000000000000,'endTime':1000000010000,'pass':10,'failed':5,'commandLineArgs':'cts -m CtsGesture --skip-all-system-status-check','hostName':'user1.android.com'}]";
        sb.append("  <Build command_line_args=\"cts -m CtsGesture --skip-all-system-status-check\" build_vendor_fingerprint=\"vendorFingerprint\"  build_reference_fingerprint=\"\"  build_fingerprint=\"testfingerprint\" run_history=\"[{'startTime':1000000000000,'endTime':1000000010000,'pass':10,'failed':5,'commandLineArgs':'cts -m CtsGesture --skip-all-system-status-check','hostName':'user1.android.com'}]\"/>\n");
        sb.append("  <RunHistory>\n    <Run start=\"1000000000000\" end=\"1000000010000\" pass=\"10\" failed=\"5\" command_line_args=\"cts -m CtsGesture --skip-all-system-status-check\" hostName=\"user1.android.com\" />\n  </RunHistory>\n");
        sb.append("  <Summary pass=\"0\" failed=\"0\" modules_done=\"2\" modules_total=\"2\" />\n");
        sb.append("  <Module name=\"CtsGestureTestCases\" abi=\"arm64-v8a\" runtime=\"2776\" done=\"true\" pass=\"0\" total_tests=\"0\" />\n");
        sb.append("  <Module name=\"CtsGestureTestCases\" abi=\"armeabi-v7a\" runtime=\"2776\" done=\"true\" pass=\"0\" total_tests=\"0\" />\n");
        sb.append("</Result>");
        return sb.toString();
    }
}

