/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.suite.PreviousSessionFileCopier;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PreviousSessionFileCopierTest {
    private PreviousSessionFileCopier mCopier;
    private File mPreviousDir;
    private File mCurrentDir;
    private IInvocationContext mContext;

    @Before
    public void setUp() throws Exception {
        this.mCurrentDir = FileUtil.createTempDir((String)"current-copier-tests");
        this.mCopier = new PreviousSessionFileCopier(){

            protected CompatibilityBuildHelper createCompatibilityHelper(IBuildInfo info) {
                return new CompatibilityBuildHelper(info){

                    public File getResultDir() throws FileNotFoundException {
                        return PreviousSessionFileCopierTest.this.mCurrentDir;
                    }
                };
            }
        };
        this.mPreviousDir = FileUtil.createTempDir((String)"previous-copier-tests");
        this.mContext = new InvocationContext();
        this.mContext.addDeviceBuildInfo("DEFAULT_DEVICE", (IBuildInfo)new BuildInfo());
        this.mCopier.setPreviousSessionDir(this.mPreviousDir);
    }

    @After
    public void tearDown() {
        FileUtil.recursiveDelete((File)this.mPreviousDir);
    }

    @Test
    public void testCopy() throws Exception {
        new File(this.mPreviousDir, "newFile").createNewFile();
        Assert.assertEquals((long)0L, (long)this.mCurrentDir.listFiles().length);
        this.mCopier.invocationStarted(this.mContext);
        this.mCopier.invocationEnded(500L);
        Assert.assertEquals((long)1L, (long)this.mCurrentDir.listFiles().length);
    }

    @Test
    public void testCopy_fileExists() throws Exception {
        File original = new File(this.mCurrentDir, "newFile");
        original.createNewFile();
        FileUtil.writeToFile((String)"CURRENT", (File)original);
        File previous = new File(this.mPreviousDir, "newFile");
        previous.createNewFile();
        FileUtil.writeToFile((String)"PREVIOUS", (File)previous);
        Assert.assertEquals((long)1L, (long)this.mCurrentDir.listFiles().length);
        this.mCopier.invocationStarted(this.mContext);
        this.mCopier.invocationEnded(500L);
        Assert.assertEquals((long)1L, (long)this.mCurrentDir.listFiles().length);
        Assert.assertEquals((Object)"CURRENT", (Object)FileUtil.readStringFromFile((File)original));
    }

    @Test
    public void testCopy_fileExcluded() throws Exception {
        new File(this.mPreviousDir, "proto").mkdir();
        this.mCopier.invocationStarted(this.mContext);
        this.mCopier.invocationEnded(500L);
        Assert.assertEquals((long)0L, (long)this.mCurrentDir.listFiles().length);
    }
}

