/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.ApkInstrumentationPreparer;
import com.android.compatibility.common.tradefed.targetprep.DeviceInfoCollector;
import com.android.compatibility.common.util.FileUtil;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import java.io.File;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DeviceInfoCollectorTest {
    private DeviceInfoCollector mCollector;
    private ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private TestInformation mTestInfo;

    @Before
    public void setUp() throws Exception {
        this.mCollector = new DeviceInfoCollector();
        this.mDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mBuildInfo = new BuildInfo();
        InvocationContext context = new InvocationContext();
        context.addDeviceBuildInfo("device", this.mBuildInfo);
        context.addAllocatedDevice("device", this.mDevice);
        OptionSetter setter = new OptionSetter(new Object[]{this.mCollector});
        setter.setOptionValue("src-dir", "/sdcard/device-info-files/");
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    @After
    public void tearDown() {
        this.mBuildInfo.cleanUp();
    }

    @Test
    public void pullDeviceInfo_fail() throws Exception {
        this.mCollector.mWhen = ApkInstrumentationPreparer.When.AFTER;
        EasyMock.expect((Object)this.mDevice.getProperty((String)EasyMock.anyObject())).andStubReturn((Object)"value");
        EasyMock.expect((Object)this.mDevice.pullDir((String)EasyMock.eq((Object)"/sdcard/device-info-files/"), (File)EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Boolean>(){

            public Boolean answer() throws Throwable {
                File dir = (File)EasyMock.getCurrentArguments()[1];
                FileUtil.recursiveDelete((File)dir);
                return true;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.mDevice});
        this.mCollector.setUp(this.mTestInfo);
        EasyMock.verify((Object[])new Object[]{this.mDevice});
        Assert.assertNull((Object)this.mBuildInfo.getFile("device_info_dir"));
    }

    @Test
    public void pullDeviceInfo() throws Exception {
        this.mCollector.mWhen = ApkInstrumentationPreparer.When.AFTER;
        EasyMock.expect((Object)this.mDevice.getProperty((String)EasyMock.anyObject())).andStubReturn((Object)"value");
        EasyMock.expect((Object)this.mDevice.pullDir((String)EasyMock.eq((Object)"/sdcard/device-info-files/"), (File)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.mDevice});
        this.mCollector.setUp(this.mTestInfo);
        EasyMock.verify((Object[])new Object[]{this.mDevice});
        File infoDir = this.mBuildInfo.getFile("device_info_dir");
        Assert.assertNotNull((Object)infoDir);
        Assert.assertTrue((boolean)infoDir.isDirectory());
    }
}

