/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.DeviceInteractionHelperInstaller;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DeviceInteractionHelperInstallerTest {
    private DeviceInteractionHelperInstaller mPreparer = null;
    private ITestDevice mMockDevice = null;
    private OptionSetter mOptionSetter = null;
    private Map<File, AaptParser> mAaptParsers = new HashMap<File, AaptParser>();

    @Before
    public void setUp() throws Exception {
        this.mMockDevice = (ITestDevice)EasyMock.createStrictMock(ITestDevice.class);
        EasyMock.expect((Object)this.mMockDevice.getDeviceDescriptor()).andStubReturn(null);
        EasyMock.expect((Object)this.mMockDevice.getSerialNumber()).andStubReturn((Object)"SERIAL");
        this.mPreparer = new DeviceInteractionHelperInstaller(){

            protected AaptParser parseApk(File apkFile) {
                return DeviceInteractionHelperInstallerTest.this.mAaptParsers.getOrDefault(apkFile, AaptParser.parse((File)apkFile));
            }
        };
        this.mOptionSetter = new OptionSetter(new Object[]{this.mPreparer});
    }

    private void expectHelperInstall(File file) throws DeviceNotAvailableException {
        EasyMock.expect((Object)this.mMockDevice.isAppEnumerationSupported()).andReturn((Object)true);
        EasyMock.expect((Object)this.mMockDevice.installPackage((File)EasyMock.eq((Object)file), EasyMock.anyBoolean(), (String[])EasyMock.anyObject())).andReturn(null);
    }

    private void expectDeviceProperty(String value) throws DeviceNotAvailableException {
        EasyMock.expect((Object)this.mMockDevice.getProperty("ro.vendor.cts_interaction_helper_packages")).andReturn((Object)value);
    }

    private File createFindableFile(File dir, String name, TestInformation testInfo) throws FileNotFoundException, IOException {
        File f = new File(dir, name);
        f.createNewFile();
        if (testInfo != null) {
            testInfo.executionFiles().put(name, f);
        }
        return f;
    }

    private void mockApkPackage(File apk, String packageName) {
        AaptParser mockParser = (AaptParser)Mockito.mock(AaptParser.class);
        Mockito.when((Object)mockParser.getPackageName()).thenReturn((Object)packageName);
        this.mAaptParsers.put(apk, mockParser);
    }

    private TestInformation makeTestInfo(ITestDevice device) {
        InvocationContext context = new InvocationContext();
        context.addAllocatedDevice("device", device);
        context.addDeviceBuildInfo("device", (IBuildInfo)new BuildInfo());
        return TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoOptionsNoDeviceProperty() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty(null);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoOptionsEmptyDeviceProperty() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("");
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoOptionsValidDeviceProperty() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "com.helper1.apk", testInfo);
            this.mockApkPackage(extraApk, "com.helper1");
            File extraApk2 = this.createFindableFile(testsDir, "com.helper2.apk", testInfo);
            this.mockApkPackage(extraApk2, "com.helper2");
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("com.helper1:com.helper2");
            EasyMock.checkOrder((Object)this.mMockDevice, (boolean)false);
            this.expectHelperInstall(extraApk);
            this.expectHelperInstall(extraApk2);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackPackageOptionOverridesDefault() throws Exception {
        this.mOptionSetter.setOptionValue("default-package", "com.fallback");
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File otherApk = this.createFindableFile(testsDir, "com.fallback.apk", testInfo);
            this.mockApkPackage(otherApk, "com.fallback");
            this.expectHelperInstall(otherApk);
            this.expectDeviceProperty(null);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDevicePropertyOptionOverridesDefault() throws Exception {
        this.mOptionSetter.setOptionValue("property-name", "ro.other_property");
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "com.helper1.apk", testInfo);
            this.mockApkPackage(extraApk, "com.helper1");
            File extraApk2 = this.createFindableFile(testsDir, "com.helper2.apk", testInfo);
            this.mockApkPackage(extraApk2, "com.helper2");
            this.expectHelperInstall(baseApk);
            EasyMock.expect((Object)this.mMockDevice.getProperty("ro.other_property")).andReturn((Object)"com.helper1:com.helper2");
            EasyMock.checkOrder((Object)this.mMockDevice, (boolean)false);
            this.expectHelperInstall(extraApk);
            this.expectHelperInstall(extraApk2);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidApkWontInstall() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "MyCtsHelpers.apk", testInfo);
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("MyCtsHelpers");
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            try {
                this.mPreparer.setUp(testInfo);
                Assert.fail((String)"BuildError not thrown");
            }
            catch (BuildError buildError) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApkWithoutPackageWontInstall() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "MyCtsHelpers.apk", testInfo);
            this.mockApkPackage(extraApk, "");
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("MyCtsHelpers");
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            try {
                this.mPreparer.setUp(testInfo);
                Assert.fail((String)"BuildError not thrown");
            }
            catch (BuildError buildError) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testApkWithBadPackageWontInstall() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "MyCtsHelpers.apk", testInfo);
            this.mockApkPackage(extraApk, "NotMyCtsHelpers");
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("MyCtsHelpers");
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            try {
                this.mPreparer.setUp(testInfo);
                Assert.fail((String)"BuildError not thrown");
            }
            catch (BuildError buildError) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingPackageFromDevicePropertyDoesntAbort() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            File extraApk = this.createFindableFile(testsDir, "com.helper2.apk", testInfo);
            this.mockApkPackage(extraApk, "com.helper2");
            this.expectHelperInstall(baseApk);
            this.expectDeviceProperty("MyMissingHelpers:com.helper2");
            this.expectHelperInstall(extraApk);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            this.mPreparer.setUp(testInfo);
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultHelpersNotFound() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            try {
                this.mPreparer.setUp(testInfo);
                Assert.fail((String)"BuildError not thrown");
            }
            catch (BuildError buildError) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedInstallAborts() throws Exception {
        File testsDir = FileUtil.createTempDir((String)"tests_dir");
        try {
            TestInformation testInfo = this.makeTestInfo(this.mMockDevice);
            File baseApk = this.createFindableFile(testsDir, "com.android.cts.helpers.aosp.apk", testInfo);
            EasyMock.expect((Object)this.mMockDevice.isAppEnumerationSupported()).andReturn((Object)true);
            EasyMock.expect((Object)this.mMockDevice.installPackage((File)EasyMock.eq((Object)baseApk), EasyMock.anyBoolean(), (String[])EasyMock.anyObject())).andReturn((Object)"Install failed");
            EasyMock.replay((Object[])new Object[]{this.mMockDevice});
            try {
                this.mPreparer.setUp(testInfo);
                Assert.fail((String)"TargetSetupError not thrown");
            }
            catch (TargetSetupError targetSetupError) {
                // empty catch block
            }
            EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        }
        finally {
            FileUtil.recursiveDelete((File)testsDir);
        }
    }
}

