/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.targetprep.DynamicConfigPusher;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DynamicConfigPusherTest {
    private static final String RESOURCE_DYNAMIC_CONFIG = "test-dynamic-config";
    private DynamicConfigPusher mPreparer;
    private ITestDevice mMockDevice;
    private CompatibilityBuildHelper mMockBuildHelper;
    private IBuildInfo mMockBuildInfo;
    private IInvocationContext mModuleContext;
    private TestInformation mTestInfo;

    @Before
    public void setUp() {
        this.mModuleContext = new InvocationContext();
        this.mModuleContext.setConfigurationDescriptor(new ConfigurationDescriptor());
        this.mPreparer = new DynamicConfigPusher();
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mMockBuildInfo = (IBuildInfo)EasyMock.createMock(IBuildInfo.class);
        this.mMockBuildHelper = new CompatibilityBuildHelper(this.mMockBuildInfo);
        EasyMock.expect((Object)this.mMockDevice.getDeviceDescriptor()).andStubReturn(null);
        this.mModuleContext.addDeviceBuildInfo("device", this.mMockBuildInfo);
        this.mModuleContext.addAllocatedDevice("device", this.mMockDevice);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext(this.mModuleContext).build();
    }

    @Test
    public void testGetSuiteName_fromTestSuiteInfo() throws Exception {
        this.mPreparer = new DynamicConfigPusher();
        this.mPreparer.setInvocationContext(this.mModuleContext);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        Assert.assertNotNull((Object)this.mPreparer.getSuiteName());
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testGetSuiteName_fromTestSuiteTag() throws Exception {
        this.mPreparer = new DynamicConfigPusher();
        this.mModuleContext.getConfigurationDescriptor().setSuiteTags(Arrays.asList("cts", "cts-instant", "gts"));
        this.mPreparer.setInvocationContext(this.mModuleContext);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        Assert.assertNotNull((Object)this.mPreparer.getSuiteName());
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testLocalRead_fromDynamicConfigName() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "config-test-name");
        setter.setOptionValue("dynamic-config-name", "dynamic-config-test-name");
        setter.setOptionValue("extract-from-resource", "false");
        final File check = new File("anyfilewilldo");
        this.mMockBuildHelper = new CompatibilityBuildHelper(this.mMockBuildInfo){

            public File getTestFile(String filename) throws FileNotFoundException {
                return check;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        File res = this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
        Assert.assertEquals((Object)check, (Object)res);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testLocalRead() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "config-test-name");
        setter.setOptionValue("extract-from-resource", "false");
        final File check = new File("anyfilewilldo");
        this.mMockBuildHelper = new CompatibilityBuildHelper(this.mMockBuildInfo){

            public File getTestFile(String filename) throws FileNotFoundException {
                return check;
            }
        };
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        File res = this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
        Assert.assertEquals((Object)check, (Object)res);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testLocalRead_fileNotFound() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "config-test-name");
        setter.setOptionValue("extract-from-resource", "false");
        this.mMockBuildHelper = new CompatibilityBuildHelper(this.mMockBuildInfo){

            public File getTestFile(String filename) throws FileNotFoundException {
                throw new FileNotFoundException("test");
            }
        };
        try {
            EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
            this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (TargetSetupError expected) {
            Assert.assertEquals((Object)"Cannot get local dynamic config file from test directory", (Object)expected.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testResourceRead_notFound() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "not-an-existing-resource-name");
        setter.setOptionValue("extract-from-resource", "true");
        try {
            EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
            this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (TargetSetupError expected) {
            Assert.assertEquals((Object)"Fail to unpack 'not-an-existing-resource-name.dynamic' from resources", (Object)expected.getMessage());
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testResourceRead() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", RESOURCE_DYNAMIC_CONFIG);
        setter.setOptionValue("extract-from-resource", "true");
        File res = null;
        try {
            EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
            res = this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
            Assert.assertTrue((boolean)res.exists());
            Assert.assertTrue((boolean)FileUtil.readStringFromFile((File)res).contains("<dynamicConfig>"));
        }
        catch (Throwable throwable) {
            FileUtil.deleteFile(res);
            throw throwable;
        }
        FileUtil.deleteFile((File)res);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testResourceRead_resourceFileName() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "moduleName");
        setter.setOptionValue("extract-from-resource", "true");
        setter.setOptionValue("dynamic-resource-name", RESOURCE_DYNAMIC_CONFIG);
        File res = null;
        try {
            EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
            res = this.mPreparer.getLocalConfigFile(this.mMockBuildHelper, this.mMockDevice);
            Assert.assertTrue((boolean)res.exists());
            Assert.assertTrue((boolean)FileUtil.readStringFromFile((File)res).contains("<dynamicConfig>"));
        }
        catch (Throwable throwable) {
            FileUtil.deleteFile(res);
            throw throwable;
        }
        FileUtil.deleteFile((File)res);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
    }

    @Test
    public void testSetUp() throws Exception {
        final File[] localConfig = new File[1];
        this.mPreparer = new DynamicConfigPusher(){

            File mergeConfigFiles(File localConfigFile, String apfeConfigInJson, String moduleName, ITestDevice device) throws TargetSetupError {
                localConfig[0] = localConfigFile;
                return super.mergeConfigFiles(localConfigFile, apfeConfigInJson, moduleName, device);
            }
        };
        OptionSetter setter = new OptionSetter(new Object[]{this.mPreparer});
        setter.setOptionValue("config-filename", "moduleName");
        setter.setOptionValue("extract-from-resource", "true");
        setter.setOptionValue("dynamic-resource-name", RESOURCE_DYNAMIC_CONFIG);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("SUITE_VERSION", "v1");
        EasyMock.expect((Object)this.mMockBuildInfo.getBuildAttributes()).andStubReturn(attributes);
        LinkedList versionedFiles = new LinkedList();
        EasyMock.expect((Object)this.mMockBuildInfo.getFiles()).andStubReturn(versionedFiles);
        Capture capture = new Capture();
        this.mMockBuildInfo.setFile(EasyMock.contains((String)"moduleName"), (File)EasyMock.capture((Capture)capture), (String)EasyMock.eq((Object)"DYNAMIC_CONFIG_FILE:moduleName"));
        this.mPreparer.setInvocationContext(this.mModuleContext);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        this.mPreparer.setUp(this.mTestInfo);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice, this.mMockBuildInfo});
        Assert.assertNotNull((Object)localConfig[0]);
        Assert.assertFalse((boolean)localConfig[0].exists());
        File dynamicFile = (File)capture.getValue();
        Assert.assertTrue((boolean)dynamicFile.exists());
        FileUtil.deleteFile((File)dynamicFile);
    }
}

