/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.MediaPreparer;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.TargetSetupError;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MediaPreparerTest {
    private MediaPreparer mMediaPreparer;
    private IBuildInfo mMockBuildInfo;
    private ITestDevice mMockDevice;
    private OptionSetter mOptionSetter;
    private TestInformation mTestInfo;

    @Before
    public void setUp() throws Exception {
        this.mMediaPreparer = new MediaPreparer();
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mMockBuildInfo = new BuildInfo("0", "");
        this.mOptionSetter = new OptionSetter(new Object[]{this.mMediaPreparer});
        InvocationContext context = new InvocationContext();
        context.addDeviceBuildInfo("device", this.mMockBuildInfo);
        context.addAllocatedDevice("device", this.mMockDevice);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    @Test
    public void testSetMountPoint() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.getMountPoint("EXTERNAL_STORAGE")).andReturn((Object)"/sdcard").once();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.setMountPoint(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertEquals((Object)this.mMediaPreparer.mBaseDeviceShortDir, (Object)"/sdcard/test/bbb_short/");
        Assert.assertEquals((Object)this.mMediaPreparer.mBaseDeviceFullDir, (Object)"/sdcard/test/bbb_full/");
    }

    @Test
    public void testDefaultModuleDirMountPoint() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.getMountPoint("EXTERNAL_STORAGE")).andReturn((Object)"/sdcard").once();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.setMountPoint(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertEquals((Object)this.mMediaPreparer.mBaseDeviceModuleDir, (Object)"/sdcard/test/android-cts-media/");
        Assert.assertEquals((Object)this.mMediaPreparer.getMediaDir().getName(), (Object)"android-cts-media");
    }

    @Test
    public void testSetModuleDirMountPoint() throws Exception {
        this.mOptionSetter.setOptionValue("media-folder-name", "unittest");
        EasyMock.expect((Object)this.mMockDevice.getMountPoint("EXTERNAL_STORAGE")).andReturn((Object)"/sdcard").once();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.setMountPoint(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
        Assert.assertEquals((Object)this.mMediaPreparer.mBaseDeviceModuleDir, (Object)"/sdcard/test/unittest/");
        Assert.assertEquals((Object)this.mMediaPreparer.getMediaDir().getName(), (Object)"unittest");
    }

    @Test
    public void testCopyMediaFiles() throws Exception {
        this.mMediaPreparer.mMaxRes = MediaPreparer.DEFAULT_MAX_RESOLUTION;
        this.mMediaPreparer.mBaseDeviceShortDir = "/sdcard/test/bbb_short/";
        this.mMediaPreparer.mBaseDeviceFullDir = "/sdcard/test/bbb_full/";
        this.mMediaPreparer.mBaseDeviceImagesDir = "/sdcard/test/images";
        this.mMediaPreparer.mBaseDeviceModuleDir = "/sdcard/test/android-cts-media/";
        for (MediaPreparer.Resolution resolution : MediaPreparer.RESOLUTIONS) {
            if (resolution.getWidth() > MediaPreparer.DEFAULT_MAX_RESOLUTION.getWidth()) continue;
            String shortFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceShortDir, resolution.toString());
            String fullFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceFullDir, resolution.toString());
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(shortFile)).andReturn((Object)true).once();
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(fullFile)).andReturn((Object)true).once();
        }
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceImagesDir)).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceModuleDir)).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.copyMediaFiles(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testMediaFilesExistOnDeviceTrue() throws Exception {
        this.mMediaPreparer.mMaxRes = MediaPreparer.DEFAULT_MAX_RESOLUTION;
        this.mMediaPreparer.mBaseDeviceShortDir = "/sdcard/test/bbb_short/";
        this.mMediaPreparer.mBaseDeviceFullDir = "/sdcard/test/bbb_full/";
        this.mMediaPreparer.mBaseDeviceImagesDir = "/sdcard/test/images";
        for (MediaPreparer.Resolution resolution : MediaPreparer.RESOLUTIONS) {
            String shortFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceShortDir, resolution.toString());
            String fullFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceFullDir, resolution.toString());
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(shortFile)).andReturn((Object)true).anyTimes();
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(fullFile)).andReturn((Object)true).anyTimes();
        }
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceImagesDir)).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)this.mMediaPreparer.mediaFilesExistOnDevice(this.mMockDevice));
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testMediaFilesExistOnDeviceTrueWithPushAll() throws Exception {
        this.mOptionSetter.setOptionValue("push-all", "true");
        this.mMediaPreparer.mBaseDeviceModuleDir = "/sdcard/test/android-cts-media/";
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceModuleDir)).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Assert.assertTrue((boolean)this.mMediaPreparer.mediaFilesExistOnDevice(this.mMockDevice));
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testMediaFilesExistOnDeviceFalse() throws Exception {
        this.mMediaPreparer.mMaxRes = MediaPreparer.DEFAULT_MAX_RESOLUTION;
        this.mMediaPreparer.mBaseDeviceShortDir = "/sdcard/test/bbb_short/";
        String firstFileChecked = "/sdcard/test/bbb_short/176x144";
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(firstFileChecked)).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        Assert.assertFalse((boolean)this.mMediaPreparer.mediaFilesExistOnDevice(this.mMockDevice));
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testSkipMediaDownload() throws Exception {
        this.mOptionSetter.setOptionValue("skip-media-download", "true");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.setUp(this.mTestInfo);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testPushAll() throws Exception {
        this.mOptionSetter.setOptionValue("push-all", "true");
        this.mOptionSetter.setOptionValue("media-folder-name", "unittest");
        this.mMediaPreparer.mBaseDeviceModuleDir = "/sdcard/test/unittest/";
        this.mMediaPreparer.mBaseDeviceShortDir = "/sdcard/test/bbb_short/";
        this.mMediaPreparer.mBaseDeviceFullDir = "/sdcard/test/bbb_full/";
        this.mMediaPreparer.mBaseDeviceImagesDir = "/sdcard/test/images";
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceModuleDir)).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceImagesDir)).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceShortDir)).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mMockDevice.doesFileExist(this.mMediaPreparer.mBaseDeviceFullDir)).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.copyMediaFiles(this.mMockDevice);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testWithBothPushAllAndImagesOnly() throws Exception {
        this.mOptionSetter.setOptionValue("push-all", "true");
        this.mOptionSetter.setOptionValue("images-only", "true");
        EasyMock.expect((Object)this.mMockDevice.getDeviceDescriptor()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mMediaPreparer.setUp(this.mTestInfo);
            Assert.fail((String)"TargetSetupError expected");
        }
        catch (TargetSetupError targetSetupError) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }

    @Test
    public void testMediaDownloadOnly_existsOnDevice() throws Exception {
        this.mOptionSetter.setOptionValue("local-media-path", "/fake/media/dir");
        this.mMediaPreparer.mBaseDeviceShortDir = "/sdcard/test/bbb_short/";
        this.mMediaPreparer.mBaseDeviceFullDir = "/sdcard/test/bbb_full/";
        EasyMock.expect((Object)this.mMockDevice.getMountPoint("EXTERNAL_STORAGE")).andReturn((Object)"/sdcard").once();
        for (MediaPreparer.Resolution resolution : MediaPreparer.RESOLUTIONS) {
            if (resolution.getWidth() > MediaPreparer.DEFAULT_MAX_RESOLUTION.getWidth()) continue;
            String shortFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceShortDir, resolution.toString());
            String fullFile = String.format("%s%s", this.mMediaPreparer.mBaseDeviceFullDir, resolution.toString());
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(shortFile)).andReturn((Object)true).once();
            EasyMock.expect((Object)this.mMockDevice.doesFileExist(fullFile)).andReturn((Object)true).once();
        }
        EasyMock.expect((Object)this.mMockDevice.doesFileExist("/sdcard/test/images/")).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mMediaPreparer.setUp(this.mTestInfo);
        EasyMock.verify((Object[])new Object[]{this.mMockDevice});
    }
}

