/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.PropertyCheck;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.TargetSetupError;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class PropertyCheckTest
extends TestCase {
    private PropertyCheck mPropertyCheck;
    private IDeviceBuildInfo mMockBuildInfo;
    private ITestDevice mMockDevice;
    private OptionSetter mOptionSetter;
    private TestInformation mTestInfo;
    private static final String PROPERTY = "ro.mock.property";
    private static final String ACTUAL_VALUE = "mock_actual_value";
    private static final String BAD_VALUE = "mock_bad_value";

    public void setUp() throws Exception {
        super.setUp();
        this.mPropertyCheck = new PropertyCheck();
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mMockBuildInfo = new DeviceBuildInfo("0", "");
        this.mOptionSetter = new OptionSetter(new Object[]{this.mPropertyCheck});
        EasyMock.expect((Object)this.mMockDevice.getProperty(PROPERTY)).andReturn((Object)ACTUAL_VALUE).anyTimes();
        EasyMock.expect((Object)this.mMockDevice.getDeviceDescriptor()).andReturn(null).anyTimes();
        InvocationContext context = new InvocationContext();
        context.addAllocatedDevice("device", this.mMockDevice);
        context.addDeviceBuildInfo("device", (IBuildInfo)this.mMockBuildInfo);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    public void testWarningMatch() throws Exception {
        this.mOptionSetter.setOptionValue("property-name", PROPERTY);
        this.mOptionSetter.setOptionValue("expected-value", ACTUAL_VALUE);
        this.mOptionSetter.setOptionValue("throw-error", "false");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mPropertyCheck.run(this.mTestInfo);
    }

    public void testWarningMismatch() throws Exception {
        this.mOptionSetter.setOptionValue("property-name", PROPERTY);
        this.mOptionSetter.setOptionValue("expected-value", BAD_VALUE);
        this.mOptionSetter.setOptionValue("throw-error", "false");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mPropertyCheck.run(this.mTestInfo);
    }

    public void testErrorMatch() throws Exception {
        this.mOptionSetter.setOptionValue("property-name", PROPERTY);
        this.mOptionSetter.setOptionValue("expected-value", ACTUAL_VALUE);
        this.mOptionSetter.setOptionValue("throw-error", "true");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mPropertyCheck.run(this.mTestInfo);
    }

    public void testErrorMismatch() throws Exception {
        this.mOptionSetter.setOptionValue("property-name", PROPERTY);
        this.mOptionSetter.setOptionValue("expected-value", BAD_VALUE);
        this.mOptionSetter.setOptionValue("throw-error", "true");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mPropertyCheck.run(this.mTestInfo);
            PropertyCheckTest.fail((String)"TargetSetupError expected");
        }
        catch (TargetSetupError targetSetupError) {
            // empty catch block
        }
    }
}

