/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.SettingsPreparer;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.TargetSetupError;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class SettingsPreparerTest
extends TestCase {
    private SettingsPreparer mSettingsPreparer;
    private IBuildInfo mMockBuildInfo;
    private ITestDevice mMockDevice;
    private OptionSetter mOptionSetter;
    private TestInformation mTestInfo;
    private static final String SHELL_CMD_GET = "settings get GLOBAL stay_on_while_plugged_in";
    private static final String SHELL_CMD_PUT_7 = "settings put GLOBAL stay_on_while_plugged_in 7";
    private static final String SHELL_CMD_PUT_8 = "settings put GLOBAL stay_on_while_plugged_in 8";

    public void setUp() throws Exception {
        super.setUp();
        this.mSettingsPreparer = new SettingsPreparer();
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        EasyMock.expect((Object)this.mMockDevice.getDeviceDescriptor()).andReturn(null).anyTimes();
        this.mMockBuildInfo = new BuildInfo("0", "");
        this.mOptionSetter = new OptionSetter(new Object[]{this.mSettingsPreparer});
        this.mOptionSetter.setOptionValue("device-setting", "stay_on_while_plugged_in");
        this.mOptionSetter.setOptionValue("setting-type", "global");
        InvocationContext context = new InvocationContext();
        context.addAllocatedDevice("device", this.mMockDevice);
        context.addDeviceBuildInfo("device", this.mMockBuildInfo);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    public void testCorrectOneExpected() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_GET)).andReturn((Object)"\n3\n").once();
        this.mOptionSetter.setOptionValue("expected-values", "3");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mSettingsPreparer.run(this.mTestInfo);
    }

    public void testCorrectManyExpected() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_GET)).andReturn((Object)"\n3\n").once();
        this.mOptionSetter.setOptionValue("expected-values", "2");
        this.mOptionSetter.setOptionValue("expected-values", "3");
        this.mOptionSetter.setOptionValue("expected-values", "6");
        this.mOptionSetter.setOptionValue("expected-values", "7");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mSettingsPreparer.run(this.mTestInfo);
    }

    public void testIncorrectOneExpected() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_GET)).andReturn((Object)"\n0\n").once();
        this.mOptionSetter.setOptionValue("expected-values", "3");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mSettingsPreparer.run(this.mTestInfo);
            SettingsPreparerTest.fail((String)"TargetSetupError expected");
        }
        catch (TargetSetupError targetSetupError) {
            // empty catch block
        }
    }

    public void testIncorrectManyExpected() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_GET)).andReturn((Object)"\n0\n").once();
        this.mOptionSetter.setOptionValue("expected-values", "2");
        this.mOptionSetter.setOptionValue("expected-values", "3");
        this.mOptionSetter.setOptionValue("expected-values", "6");
        this.mOptionSetter.setOptionValue("expected-values", "7");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mSettingsPreparer.run(this.mTestInfo);
            SettingsPreparerTest.fail((String)"TargetSetupError expected");
        }
        catch (TargetSetupError targetSetupError) {
            // empty catch block
        }
    }

    public void testCommandRun() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_PUT_7)).andReturn((Object)"\n");
        this.mOptionSetter.setOptionValue("set-value", "7");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        this.mSettingsPreparer.run(this.mTestInfo);
    }

    public void testCommandRunWrongSetValue() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_PUT_8)).andReturn((Object)"\n");
        this.mOptionSetter.setOptionValue("set-value", "8");
        this.mOptionSetter.setOptionValue("expected-values", "7");
        EasyMock.replay((Object[])new Object[]{this.mMockDevice});
        try {
            this.mSettingsPreparer.run(this.mTestInfo);
            SettingsPreparerTest.fail((String)"TargetSetupError expected");
        }
        catch (TargetSetupError targetSetupError) {
            // empty catch block
        }
    }

    public void testIncorrectOneExpectedCommandRun() throws Exception {
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_GET)).andReturn((Object)"\n0\n").once();
        EasyMock.expect((Object)this.mMockDevice.executeShellCommand(SHELL_CMD_PUT_7)).andReturn((Object)"\n");
        this.mOptionSetter.setOptionValue("set-value", "7");
        this.mOptionSetter.setOptionValue("expected-values", "7");
    }
}

