/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.targetprep;

import com.android.compatibility.common.tradefed.targetprep.VtsDeviceInfoCollector;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class VtsDeviceInfoCollectorTest {
    private static final String VENDOR_BUILD_VERSION_INCREMENTAL = "1000000";
    private static final String VENDOR_FINGERPRINT = "Android/aosp_sailfish/sailfish:8.0.0/OC/1000000:userdebug/test-keys";
    private static final String ODM_DEVICE = "sailfish";
    private static final String HARDWARE_SKU = "sku";
    private static final String ODM_BUILD_VERSION_INCREMENTAL = "4311111";
    private static final String ODM_FINGERPRINT = "Android/aosp_sailfish/sailfish:8.0.0/OC/4311111:userdebug/test-keys";
    private static final String ODM_FINGERPRINT_WITH_SKU = "Android/aosp_sailfish/sailfish_sku:8.0.0/OC/4311111:userdebug/test-keys";
    @Mock
    private IBuildInfo mMockBuildInfo;
    @Mock
    private ITestDevice mMockTestDevice;
    private TestInformation mTestInfo;
    private Map<String, String> mProperties;

    @Before
    public void setUp() throws DeviceNotAvailableException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mMockTestDevice.getProperty(Mockito.anyString())).then((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) {
                String name = (String)invocation.getArgument(0);
                return VtsDeviceInfoCollectorTest.this.mProperties.getOrDefault(name, "");
            }
        });
        this.mProperties = new HashMap<String, String>();
        this.mProperties.put("ro.vendor.build.fingerprint", VENDOR_FINGERPRINT);
        this.mProperties.put("ro.vendor.build.version.incremental", VENDOR_BUILD_VERSION_INCREMENTAL);
        InvocationContext context = new InvocationContext();
        context.addDeviceBuildInfo("device", this.mMockBuildInfo);
        context.addAllocatedDevice("device", this.mMockTestDevice);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext((IInvocationContext)context).build();
    }

    @Test
    public void testVendorProperties() throws TargetSetupError, BuildError, DeviceNotAvailableException {
        new VtsDeviceInfoCollector().setUp(this.mTestInfo);
        ((IBuildInfo)Mockito.verify((Object)this.mMockBuildInfo)).addBuildAttribute("cts:build_fingerprint", VENDOR_FINGERPRINT);
        ((IBuildInfo)Mockito.verify((Object)this.mMockBuildInfo)).addBuildAttribute("cts:build_version_incremental", VENDOR_BUILD_VERSION_INCREMENTAL);
    }

    @Test
    public void testOdmProperties() throws TargetSetupError, BuildError, DeviceNotAvailableException {
        this.mProperties.put("ro.odm.build.fingerprint", ODM_FINGERPRINT_WITH_SKU);
        this.mProperties.put("ro.odm.build.version.incremental", ODM_BUILD_VERSION_INCREMENTAL);
        this.mProperties.put("ro.product.odm.device", ODM_DEVICE);
        this.mProperties.put("ro.boot.product.hardware.sku", HARDWARE_SKU);
        new VtsDeviceInfoCollector().setUp(this.mTestInfo);
        ((IBuildInfo)Mockito.verify((Object)this.mMockBuildInfo)).addBuildAttribute("cts:build_fingerprint", ODM_FINGERPRINT);
        ((IBuildInfo)Mockito.verify((Object)this.mMockBuildInfo)).addBuildAttribute("cts:build_version_incremental", ODM_BUILD_VERSION_INCREMENTAL);
    }
}

