/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.JarHostTest;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.DeviceJUnit4ClassRunner;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JarHostTestTest {
    private static final String TEST_JAR1 = "/testtype/testJar1.jar";
    private JarHostTest mTest;
    private DeviceBuildInfo mStubBuildInfo;
    private TestInformation mTestInfo;
    private File mTestDir = null;
    private ITestInvocationListener mListener;

    @Before
    public void setUp() throws Exception {
        this.mTest = new JarHostTest();
        this.mTestDir = FileUtil.createTempDir((String)"jarhostest");
        this.mListener = (ITestInvocationListener)EasyMock.createMock(ITestInvocationListener.class);
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("enable-pretty-logs", "false");
        this.mStubBuildInfo = new DeviceBuildInfo();
        this.mStubBuildInfo.setTestsDir(this.mTestDir, "v1");
        this.mTestInfo = TestInformation.newBuilder().build();
        this.mTestInfo.executionFiles().put(ExecutionFiles.FilesKey.TESTS_DIRECTORY, this.mTestDir);
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.mTestDir);
    }

    protected File getJarResource(String filename, File parentDir) throws IOException {
        InputStream jarFileStream = this.getClass().getResourceAsStream(filename);
        File jarFile = FileUtil.createTempFile((String)"test", (String)".jar", (File)parentDir);
        FileUtil.writeToFile((InputStream)jarFileStream, (File)jarFile);
        return jarFile;
    }

    @Test
    public void testSplit_withoutJar() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("class", "com.android.compatibility.common.tradefed.testtype.JarHostTestTest$Junit4TestClass");
        setter.setOptionValue("class", "com.android.compatibility.common.tradefed.testtype.JarHostTestTest$Junit4TestClass2");
        List res = (List)this.mTest.split(Integer.valueOf(1), this.mTestInfo);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)(res.get(0) instanceof JarHostTest));
        Assert.assertTrue((boolean)(res.get(1) instanceof JarHostTest));
    }

    @Test
    public void testSplit_withJar() throws Exception {
        File testJar = this.getJarResource(TEST_JAR1, this.mTestDir);
        this.mTest = new JarHostTestable(this.mTestDir);
        this.mTest.setBuild((IBuildInfo)this.mStubBuildInfo);
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("enable-pretty-logs", "false");
        setter.setOptionValue("jar", testJar.getName());
        List res = (List)this.mTest.split(Integer.valueOf(1), this.mTestInfo);
        Assert.assertEquals((long)2L, (long)res.size());
        Assert.assertTrue((boolean)(res.get(0) instanceof JarHostTest));
        Assert.assertEquals((Object)"[android.ui.cts.TaskSwitchingTest]", (Object)((JarHostTest)res.get(0)).getClassNames().toString());
        Assert.assertTrue((boolean)(res.get(1) instanceof JarHostTest));
        Assert.assertEquals((Object)"[android.ui.cts.InstallTimeTest]", (Object)((JarHostTest)res.get(1)).getClassNames().toString());
    }

    @Test
    public void testCountTestFails() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("jar", "thisjardoesnotexistatall.jar");
        this.mListener.testRunStarted((String)EasyMock.anyObject(), EasyMock.eq((int)0));
        this.mListener.testRunEnded(EasyMock.anyLong(), (HashMap)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{this.mListener});
        try {
            this.mTest.run(this.mTestInfo, this.mListener);
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{this.mListener});
    }

    @Test
    public void testJarHostMetrics() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mTest});
        setter.setOptionValue("class", "com.android.compatibility.common.tradefed.testtype.JarHostTestTest$Junit4TestClass2");
        this.mListener.testRunStarted((String)EasyMock.anyObject(), EasyMock.eq((int)1));
        TestDescription tid = new TestDescription("com.android.compatibility.common.tradefed.testtype.JarHostTestTest$Junit4TestClass2", "testPass2");
        this.mListener.testStarted((TestDescription)EasyMock.eq((Object)tid), EasyMock.anyLong());
        HashMap<String, String> metrics = new HashMap<String, String>();
        metrics.put("key", "value");
        this.mListener.testEnded((TestDescription)EasyMock.eq((Object)tid), EasyMock.anyLong(), (HashMap)EasyMock.eq((Object)TfMetricProtoUtil.upgradeConvert(metrics)));
        this.mListener.testRunEnded(EasyMock.anyLong(), (HashMap)EasyMock.anyObject());
        EasyMock.replay((Object[])new Object[]{this.mListener});
        this.mTest.run(this.mTestInfo, this.mListener);
        EasyMock.verify((Object[])new Object[]{this.mListener});
    }

    public static class JarHostTestLoader
    extends JarHostTestable {
        private static File mTestJar;

        public JarHostTestLoader() {
        }

        public JarHostTestLoader(File testDir, File jar) {
            super(testDir);
            mTestJar = jar;
        }

        protected ClassLoader getClassLoader() {
            ClassLoader child = super.getClassLoader();
            try {
                child = new URLClassLoader(Arrays.asList(mTestJar.toURI().toURL()).toArray(new URL[0]), super.getClassLoader());
            }
            catch (MalformedURLException e) {
                LogUtil.CLog.e((Throwable)e);
            }
            return child;
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Junit4TestClass2 {
        @Rule
        public DeviceJUnit4ClassRunner.TestMetrics metrics = new DeviceJUnit4ClassRunner.TestMetrics();

        @Test
        public void testPass2() {
            this.metrics.addTestMetric("key", "value");
        }
    }

    @RunWith(value=JUnit4.class)
    public static class Junit4TestClass {
        @Test
        public void testPass1() {
        }
    }

    public static class JarHostTestable
    extends JarHostTest {
        public static File mTestDir;

        public JarHostTestable() {
        }

        public JarHostTestable(File testDir) {
            mTestDir = testDir;
        }
    }
}

