/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.testtype.ModuleDef;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import com.android.tradefed.util.AbiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.easymock.EasyMock;

public class ModuleDefTest
extends TestCase {
    private static final String NAME = "ModuleName";
    private static final String ABI = "mips64";
    private static final String ID = AbiUtils.createId((String)"mips64", (String)"ModuleName");

    public void testAccessors() throws Exception {
        Abi abi = new Abi(ABI, "");
        MockRemoteTest mockTest = new MockRemoteTest();
        ModuleDef def = new ModuleDef(NAME, (IAbi)abi, (IRemoteTest)mockTest, new ArrayList(), new ConfigurationDescriptor());
        ModuleDefTest.assertEquals((String)"Incorrect ID", (String)ID, (String)def.getId());
        ModuleDefTest.assertEquals((String)"Incorrect ABI", (String)ABI, (String)def.getAbi().getName());
        ModuleDefTest.assertEquals((String)"Incorrect Name", (String)NAME, (String)def.getName());
    }

    public void testModuleFinisher() throws Exception {
        Abi abi = new Abi(ABI, "");
        MockRemoteTest mockTest = new MockRemoteTest();
        ModuleDef def = new ModuleDef(NAME, (IAbi)abi, (IRemoteTest)mockTest, new ArrayList(), new ConfigurationDescriptor());
        ITestInvocationListener mockListener = (ITestInvocationListener)EasyMock.createMock(ITestInvocationListener.class);
        mockListener.testRunStarted(ID, 0);
        EasyMock.expectLastCall().once();
        mockListener.testRunEnded(0L, new HashMap());
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{mockListener});
        def.run(mockListener);
        EasyMock.verify((Object[])new Object[]{mockListener});
    }

    private class MockRemoteTest
    implements IRemoteTest,
    ITestFilterReceiver,
    IAbiReceiver,
    IRuntimeHintProvider,
    ITestCollector {
        private final List<String> mIncludeFilters = new ArrayList<String>();
        private final List<String> mExcludeFilters = new ArrayList<String>();

        private MockRemoteTest() {
        }

        public void addIncludeFilter(String filter) {
            this.mIncludeFilters.add(filter);
        }

        public void addAllIncludeFilters(Set<String> filters) {
            this.mIncludeFilters.addAll(filters);
        }

        public void clearIncludeFilters() {
            this.mIncludeFilters.clear();
        }

        public Set<String> getIncludeFilters() {
            return new HashSet<String>(this.mIncludeFilters);
        }

        public void addExcludeFilter(String filter) {
            this.mExcludeFilters.add(filter);
        }

        public void addAllExcludeFilters(Set<String> filters) {
            this.mExcludeFilters.addAll(filters);
        }

        public void clearExcludeFilters() {
            this.mExcludeFilters.clear();
        }

        public Set<String> getExcludeFilters() {
            return new HashSet<String>(this.mExcludeFilters);
        }

        public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        }

        public void setAbi(IAbi abi) {
        }

        public IAbi getAbi() {
            return null;
        }

        public long getRuntimeHint() {
            return 1L;
        }

        public void setCollectTestsOnly(boolean shouldCollectTest) {
        }
    }
}

