/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.ITestFilterReceiver;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class TestStub
implements IRemoteTest,
IAbiReceiver,
IRuntimeHintProvider,
ITestCollector,
ITestFilterReceiver {
    @Option(name="module")
    private String mModule;
    @Option(name="foo")
    protected String mFoo;
    @Option(name="blah")
    protected String mBlah;
    @Option(name="report-test")
    protected boolean mReportTest = false;
    @Option(name="run-complete")
    protected boolean mIsComplete = true;
    @Option(name="test-fail")
    protected boolean mDoesOneTestFail = true;
    @Option(name="internal-retry")
    protected boolean mRetry = false;
    protected List<TestDescription> mShardedTestToRun;
    protected Integer mShardIndex = null;

    private void testAttempt(ITestInvocationListener listener) {
        listener.testRunStarted("module-run", 3);
        TestDescription tid = new TestDescription("TestStub", "test1");
        listener.testStarted(tid);
        listener.testEnded(tid, new HashMap());
        if (this.mIsComplete) {
            TestDescription tid2 = new TestDescription("TestStub", "test2");
            listener.testStarted(tid2);
            listener.testEnded(tid2, new HashMap());
        }
        TestDescription tid3 = new TestDescription("TestStub", "test3");
        listener.testStarted(tid3);
        if (this.mDoesOneTestFail) {
            listener.testFailed(tid3, "ouch this is bad.");
        }
        listener.testEnded(tid3, new HashMap());
        listener.testRunEnded(0L, new HashMap());
    }

    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mReportTest) {
            if (this.mShardedTestToRun == null) {
                if (!this.mRetry) {
                    this.testAttempt(listener);
                } else {
                    listener.testRunStarted("module-run", 3);
                    listener.testRunEnded(0L, new HashMap());
                    this.testAttempt(listener);
                }
            } else {
                TestDescription tid;
                if (this.mDoesOneTestFail) {
                    listener.testRunStarted("module-run", this.mShardedTestToRun.size() + 1);
                } else {
                    listener.testRunStarted("module-run", this.mShardedTestToRun.size());
                }
                if (this.mIsComplete) {
                    for (TestDescription tid2 : this.mShardedTestToRun) {
                        listener.testStarted(tid2);
                        listener.testEnded(tid2, new HashMap());
                    }
                } else {
                    tid = this.mShardedTestToRun.get(0);
                    listener.testStarted(tid);
                    listener.testEnded(tid, new HashMap());
                }
                if (this.mDoesOneTestFail) {
                    tid = new TestDescription("TestStub", "failed" + this.mShardIndex);
                    listener.testStarted(tid);
                    listener.testFailed(tid, "shard failed this one.");
                    listener.testEnded(tid, new HashMap());
                }
                listener.testRunEnded(0L, new HashMap());
            }
        }
    }

    public void setAbi(IAbi abi) {
    }

    public IAbi getAbi() {
        return null;
    }

    public long getRuntimeHint() {
        return 1L;
    }

    public void setCollectTestsOnly(boolean shouldCollectTest) {
    }

    public void addIncludeFilter(String filter) {
    }

    public void addAllIncludeFilters(Set<String> filters) {
    }

    public void addExcludeFilter(String filter) {
    }

    public void addAllExcludeFilters(Set<String> filters) {
    }

    public Set<String> getIncludeFilters() {
        return null;
    }

    public Set<String> getExcludeFilters() {
        return null;
    }

    public void clearIncludeFilters() {
    }

    public void clearExcludeFilters() {
    }
}

