/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype.retry;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.testtype.retry.RetryFactoryTest;
import com.android.compatibility.common.tradefed.testtype.suite.CompatibilityTestSuite;
import com.android.compatibility.common.tradefed.util.RetryFilterHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.StubTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryFactoryTestTest {
    private RetryFactoryTest mFactory;
    private ITestInvocationListener mMockListener;
    private RetryFilterHelper mSpyFilter;
    private List<ISystemStatusChecker> mCheckers;
    private IBuildInfo mMockInfo;
    private ITestDevice mMockDevice;
    private IConfiguration mMockMainConfiguration;
    private IInvocationContext mMockContext;
    private TestInformation mTestInfo;

    @Before
    public void setUp() {
        this.mMockMainConfiguration = new Configuration("mockMain", "mockMain");
        this.mCheckers = new ArrayList<ISystemStatusChecker>();
        this.mMockInfo = (IBuildInfo)EasyMock.createMock(IDeviceBuildInfo.class);
        EasyMock.expect((Object)this.mMockInfo.getRemoteFiles()).andStubReturn(null);
        this.mMockDevice = (ITestDevice)EasyMock.createMock(ITestDevice.class);
        this.mMockContext = new InvocationContext();
        this.mMockContext.addAllocatedDevice("DEFAULT_DEVICE", this.mMockDevice);
        this.mMockContext.addDeviceBuildInfo("DEFAULT_DEVICE", this.mMockInfo);
        this.mTestInfo = TestInformation.newBuilder().setInvocationContext(this.mMockContext).build();
        this.mSpyFilter = new RetryFilterHelper(){

            public void validateBuildFingerprint(ITestDevice device) throws DeviceNotAvailableException {
            }

            public void setCommandLineOptionsFor(Object obj) {
            }

            public void setBuildInfoRetryCommand(IBuildInfo info) {
            }

            public void populateFiltersBySubPlan() {
            }
        };
        this.mFactory = new RetryFactoryTest(){

            protected RetryFilterHelper createFilterHelper(CompatibilityBuildHelper buildHelper) {
                return RetryFactoryTestTest.this.mSpyFilter;
            }

            CompatibilityTestSuite createTest() {
                return new VoidCompatibilityTest();
            }
        };
        this.mMockListener = (ITestInvocationListener)EasyMock.createMock(ITestInvocationListener.class);
    }

    @Test
    public void testRetry_receiveOption() throws Exception {
        OptionSetter setter = new OptionSetter(new Object[]{this.mFactory});
        setter.setOptionValue("retry", "10599");
        setter.setOptionValue("test-arg", "abcd");
        EasyMock.replay((Object[])new Object[]{this.mMockListener});
        this.mFactory.run(this.mTestInfo, this.mMockListener);
        EasyMock.verify((Object[])new Object[]{this.mMockListener});
    }

    @Test
    public void testRetry_split() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.mMockListener});
        Collection res = this.mFactory.split(2);
        Assert.assertEquals((long)2L, (long)res.size());
        EasyMock.verify((Object[])new Object[]{this.mMockListener});
    }

    @Test
    public void testValidation() throws Exception {
        this.mFactory = new RetryFactoryTest(){

            protected RetryFilterHelper createFilterHelper(CompatibilityBuildHelper buildHelper) {
                return RetryFactoryTestTest.this.mSpyFilter;
            }

            CompatibilityTestSuite createTest() {
                return new TestCompatibilityTestSuite();
            }
        };
        this.mFactory.setBuild(this.mMockInfo);
        this.mFactory.setDevice(this.mMockDevice);
        this.mFactory.setSystemStatusChecker(this.mCheckers);
        this.mFactory.setConfiguration(this.mMockMainConfiguration);
        this.mFactory.setInvocationContext(this.mMockContext);
        this.mMockListener.testModuleStarted((IInvocationContext)EasyMock.anyObject());
        this.mMockListener.testRunStarted((String)EasyMock.eq((Object)"module1"), EasyMock.eq((int)0), EasyMock.eq((int)0), EasyMock.anyLong());
        this.mMockListener.testRunEnded(EasyMock.anyLong(), (HashMap)EasyMock.anyObject());
        this.mMockListener.testModuleEnded();
        EasyMock.replay((Object[])new Object[]{this.mMockListener, this.mMockInfo, this.mMockDevice});
        this.mFactory.run(this.mTestInfo, this.mMockListener);
        EasyMock.verify((Object[])new Object[]{this.mMockListener, this.mMockInfo, this.mMockDevice});
    }

    @OptionClass(alias="compatibility")
    public static class TestCompatibilityTestSuite
    extends CompatibilityTestSuite {
        public LinkedHashMap<String, IConfiguration> loadTests() {
            LinkedHashMap<String, IConfiguration> tests = new LinkedHashMap<String, IConfiguration>();
            Configuration config = new Configuration("test", "test");
            config.setTest((IRemoteTest)new StubTest());
            tests.put("module1", (IConfiguration)config);
            return tests;
        }
    }

    @OptionClass(alias="compatibility")
    public static class VoidCompatibilityTest
    extends CompatibilityTestSuite {
        public LinkedHashMap<String, IConfiguration> loadTests() {
            return new LinkedHashMap<String, IConfiguration>();
        }

        public Collection<IRemoteTest> split(int shardCountHint) {
            ArrayList<IRemoteTest> tests = new ArrayList<IRemoteTest>();
            for (int i = 0; i < shardCountHint; ++i) {
                tests.add((IRemoteTest)new StubTest());
            }
            return tests;
        }
    }
}

