/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.util.DynamicConfigFileReader;
import com.android.tradefed.build.BuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.xmlpull.v1.XmlPullParserException;

@RunWith(value=JUnit4.class)
public class DynamicConfigFileReaderTest {
    private static final String MODULE_NAME = "cts";
    private IBuildInfo mBuildInfo;
    private File mConfigFile;

    @Before
    public void setUp() throws Exception {
        this.mConfigFile = FileUtil.createTempFile((String)"temp-dynamic-config", (String)".xml");
        this.mBuildInfo = new BuildInfo();
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(this.mBuildInfo);
        helper.addDynamicConfigFile(MODULE_NAME, this.mConfigFile);
    }

    @After
    public void tearDown() {
        FileUtil.deleteFile((File)this.mConfigFile);
        this.mBuildInfo.cleanUp();
    }

    private void writeDynamicConfigFile() throws IOException {
        String content = "<dynamicConfig>\n  <entry key=\"remote_config_required\">\n    <value>false</value>\n  </entry>\n  <entry key=\"media_files_url\">\n    <value>some value</value>\n  </entry>\n</dynamicConfig>";
        FileUtil.writeToFile((String)content, (File)this.mConfigFile);
    }

    @Test
    public void testGetValueFromFile_invalidFile() throws Exception {
        try {
            DynamicConfigFileReader.getValueFromConfig((File)this.mConfigFile, (String)"doesnotexit");
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
    }

    @Test
    public void testGetValueFromFile_keyNotFound() throws Exception {
        this.writeDynamicConfigFile();
        String res = DynamicConfigFileReader.getValueFromConfig((File)this.mConfigFile, (String)"doesnotexit");
        Assert.assertNull((Object)res);
    }

    @Test
    public void testGetValueFromFile() throws Exception {
        this.writeDynamicConfigFile();
        String res = DynamicConfigFileReader.getValueFromConfig((File)this.mConfigFile, (String)"media_files_url");
        Assert.assertEquals((Object)"some value", (Object)res);
    }

    @Test
    public void testGetValueFromBuild() throws Exception {
        this.writeDynamicConfigFile();
        String res = DynamicConfigFileReader.getValueFromConfig((IBuildInfo)this.mBuildInfo, (String)MODULE_NAME, (String)"media_files_url");
        Assert.assertEquals((Object)"some value", (Object)res);
    }

    @Test
    public void testGetValueFromBuild_moduleNotFound() throws Exception {
        this.writeDynamicConfigFile();
        String res = DynamicConfigFileReader.getValueFromConfig((IBuildInfo)this.mBuildInfo, (String)"NOT_A_MODULE", (String)"media_files_url");
        Assert.assertNull((Object)res);
    }
}

