/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.testtype.ModuleDef;
import com.android.compatibility.common.tradefed.testtype.TestStub;
import com.android.compatibility.common.tradefed.util.UniqueModuleCountUtil;
import com.android.tradefed.config.ConfigurationDescriptor;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class UniqueModuleCountUtilTest {
    @Test
    public void testCountEmptyList() {
        ArrayList emptyList = new ArrayList();
        Assert.assertEquals((long)0L, (long)UniqueModuleCountUtil.countUniqueModules(emptyList));
    }

    @Test
    public void testCount_2uniquesModules() {
        ArrayList<ModuleDef> list = new ArrayList<ModuleDef>();
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm64", "64"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        Assert.assertEquals((long)2L, (long)UniqueModuleCountUtil.countUniqueModules(list));
    }

    @Test
    public void testCount_2subModules() {
        ArrayList<ModuleDef> list = new ArrayList<ModuleDef>();
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        Assert.assertEquals((long)1L, (long)UniqueModuleCountUtil.countUniqueModules(list));
    }

    @Test
    public void testCount_mix() {
        ArrayList<ModuleDef> list = new ArrayList<ModuleDef>();
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm64", "64"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleC", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleB", (IAbi)new Abi("arm64", "64"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleB", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleC", (IAbi)new Abi("arm64", "64"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleA", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        list.add(new ModuleDef("moduleC", (IAbi)new Abi("arm32", "32"), (IRemoteTest)new TestStub(), new ArrayList(), new ConfigurationDescriptor()));
        Assert.assertEquals((long)6L, (long)UniqueModuleCountUtil.countUniqueModules(list));
    }
}

