/*
 * Decompiled with CFR 0.152.
 */
package android.host.test.longevity;

import android.host.test.composer.Compose;
import android.host.test.composer.Iterate;
import android.host.test.composer.Shuffle;
import android.host.test.longevity.listener.ErrorTerminator;
import android.host.test.longevity.listener.TimeoutTerminator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runner.notification.StoppedByUserException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class LongevitySuite
extends Suite {
    static final String QUITTER_OPTION = "quitter";
    private static final boolean QUITTER_DEFAULT = false;
    static final String INVALIDATE_OPTION = "invalidate-if-early";
    private static final boolean INVALIDATE_DEFAULT = false;
    protected Map<String, String> mArguments;

    public LongevitySuite(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        this(klass, builder, System.getProperties().entrySet().stream().collect(Collectors.toMap(i -> String.valueOf(i.getKey()), i -> String.valueOf(i.getValue()))));
    }

    public LongevitySuite(Class<?> klass, RunnerBuilder builder, Map<String, String> args) throws InitializationError {
        this(klass, LongevitySuite.constructClassRunners(klass, builder, args), args);
    }

    protected LongevitySuite(Class<?> klass, List<Runner> runners, Map<String, String> args) throws InitializationError {
        super(klass, runners);
        this.mArguments = args;
    }

    private static List<Runner> constructClassRunners(Class<?> suite, RunnerBuilder builder, Map<String, String> args) throws InitializationError {
        Suite.SuiteClasses annotation = suite.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("Longevity suite, '%s', must have a SuiteClasses annotation", suite.getName()));
        }
        Compose<Map<String, String>, List> modifier = new Iterate().andThen(new Shuffle());
        return (List)modifier.apply(args, builder.runners(suite, annotation.value()));
    }

    public void run(RunNotifier notifier) {
        if (this.mArguments.containsKey(QUITTER_OPTION) && Boolean.parseBoolean(this.mArguments.get(QUITTER_OPTION))) {
            notifier.addListener((RunListener)this.getErrorTerminator(notifier));
        }
        notifier.addListener((RunListener)this.getTimeoutTerminator(notifier));
        try {
            super.run(notifier);
        }
        catch (StoppedByUserException e) {
            if (this.mArguments.containsKey(INVALIDATE_OPTION) && Boolean.parseBoolean(this.mArguments.get(INVALIDATE_OPTION))) {
                throw e;
            }
            return;
        }
    }

    public ErrorTerminator getErrorTerminator(RunNotifier notifier) {
        return new ErrorTerminator(notifier);
    }

    public TimeoutTerminator getTimeoutTerminator(RunNotifier notifier) {
        return new TimeoutTerminator(notifier, this.mArguments);
    }

    public List<Runner> getRunners() {
        return this.getChildren();
    }
}

