/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.loganalysis.item.CompactMemInfoItem;
import com.android.loganalysis.parser.CompactMemInfoParser;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DumpHeapCollector
extends ScheduledDeviceMetricCollector {
    private static final String DUMPHEAP_OUTPUT = "/data/local/tmp";
    private static final String SUFFIX = "trigger";
    @Option(name="dumpheap-thresholds", description="Threshold map for taking process dumpheaps. The key should be the process name and its corresponding value is the maximum acceptable heap size for that process.Note that to get heap dump for native and managed processes set their threshold to 0.")
    protected Map<String, Long> mDumpheapThresholds = new HashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collect(ITestDevice device, DeviceMetricData runData) throws InterruptedException {
        LogUtil.CLog.i((String)"Running dumpheap collection...");
        List<Object> dumpFiles = new ArrayList();
        try {
            for (String process : this.mDumpheapThresholds.keySet()) {
                String output = device.executeShellCommand(String.format("dumpsys meminfo -c | grep %s", process));
                dumpFiles = this.takeDumpheap(device, output, process, this.mDumpheapThresholds.get(process));
                dumpFiles.forEach(dumpheap -> this.saveDumpheap((File)dumpheap));
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        finally {
            dumpFiles.forEach(dumpFile -> FileUtil.deleteFile((File)dumpFile));
        }
    }

    List<File> takeDumpheap(ITestDevice device, String output, String process, Long threshold) throws DeviceNotAvailableException {
        ArrayList<File> dumpFiles = new ArrayList<File>();
        if (output.isEmpty()) {
            LogUtil.CLog.i((String)"Skipping %s -- no process found.", (Object[])new Object[]{process});
            return dumpFiles;
        }
        CompactMemInfoItem item = new CompactMemInfoParser().parse(Arrays.asList(output.split("\n")));
        for (Integer pid : item.getPids()) {
            if (!item.getName(pid.intValue()).equals(process) || item.getPss(pid.intValue()) <= threshold) continue;
            File dump = device.dumpHeap(process, this.getDevicePath(process));
            dumpFiles.add(dump);
        }
        return dumpFiles;
    }

    private String getDevicePath(String process) {
        return String.format("%s/%s_%s_%s.hprof", DUMPHEAP_OUTPUT, process, SUFFIX, this.getFileSuffix());
    }

    void saveDumpheap(File dumpheap) {
        if (dumpheap == null) {
            LogUtil.CLog.e((String)"Failed to take dumpheap.");
            return;
        }
        try (FileInputStreamSource stream = new FileInputStreamSource(dumpheap);){
            this.getInvocationListener().testLog(FileUtil.getBaseName((String)dumpheap.getName()), LogDataType.HPROF, (InputStreamSource)stream);
        }
    }
}

