/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.statsd.ConfigUtil;
import com.android.tradefed.util.statsd.MetricUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="host-statsd-collector")
public class HostStatsdMetricCollector
extends BaseDeviceMetricCollector {
    @Option(name="binary-stats-config", description="Path to the binary Statsd config file")
    private File mBinaryConfig;
    @Option(name="per-run", description="Collect Metrics at per-test level or per-run level")
    private boolean mPerRun = true;
    private Map<String, Long> mDeviceConfigIds = new HashMap<String, Long>();
    private int mTestCount = 1;
    private boolean mTestFailed = false;

    public void onTestRunStart(DeviceMetricData runData) {
        if (this.mPerRun) {
            this.mDeviceConfigIds.clear();
            this.startCollection();
        }
    }

    public void onTestStart(DeviceMetricData testData) {
        if (!this.mPerRun) {
            this.mDeviceConfigIds.clear();
            this.startCollection();
        }
    }

    public void onTestFail(DeviceMetricData testData, TestDescription test) {
        this.mTestFailed = true;
    }

    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) {
        if (!this.mPerRun) {
            this.stopCollection(testData, !this.mTestFailed);
        }
        ++this.mTestCount;
        this.mTestFailed = false;
    }

    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        if (this.mPerRun) {
            this.stopCollection(runData, true);
        }
    }

    @VisibleForTesting
    InputStreamSource getReportByteStream(ITestDevice device, long configId) throws DeviceNotAvailableException {
        return MetricUtil.getReportByteStream(device, configId);
    }

    @VisibleForTesting
    long pushBinaryStatsConfig(ITestDevice device, File configFile) throws IOException, DeviceNotAvailableException {
        return ConfigUtil.pushBinaryStatsConfig(device, configFile);
    }

    @VisibleForTesting
    void removeConfig(ITestDevice device, long configId) throws DeviceNotAvailableException {
        ConfigUtil.removeConfig(device, configId);
    }

    protected void processStatsReport(ITestDevice device, InputStreamSource dataStream, DeviceMetricData runData) {
    }

    private void startCollection() {
        for (ITestDevice device : this.getDevices()) {
            String serialNumber = device.getSerialNumber();
            try {
                long configId = this.pushBinaryStatsConfig(device, this.mBinaryConfig);
                LogUtil.CLog.d((String)"Pushed binary stats config to device %s with config id: %d", (Object[])new Object[]{serialNumber, configId});
                this.mDeviceConfigIds.put(serialNumber, configId);
            }
            catch (DeviceNotAvailableException | IOException e) {
                LogUtil.CLog.e((String)"Failed to push stats config to device %s, error: %s", (Object[])new Object[]{serialNumber, e});
            }
        }
    }

    private void stopCollection(DeviceMetricData metricData, boolean reportResult) {
        for (ITestDevice device : this.getDevices()) {
            String serialNumber = device.getSerialNumber();
            if (!this.mDeviceConfigIds.containsKey(serialNumber)) continue;
            long configId = this.mDeviceConfigIds.get(serialNumber);
            try {
                InputStreamSource dataStream = this.getReportByteStream(device, configId);
                try {
                    LogUtil.CLog.d((String)"Retrieved stats report from device %s for config %d", (Object[])new Object[]{serialNumber, configId});
                    this.removeConfig(device, configId);
                    if (!reportResult) continue;
                    String reportName = this.mPerRun ? String.format("device_%s_stats_report", serialNumber) : String.format("device_%s_stats_report_test_%d", serialNumber, this.mTestCount);
                    this.testLog(reportName, LogDataType.PB, dataStream);
                    this.processStatsReport(device, dataStream, metricData);
                }
                finally {
                    if (dataStream == null) continue;
                    dataStream.close();
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Device %s not available: %s", (Object[])new Object[]{serialNumber, e});
            }
        }
    }
}

