/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class IonHeapInfoMetricCollector
extends ScheduledDeviceMetricCollector {
    public IonHeapInfoMetricCollector() {
        this.setTag("ion");
    }

    @Override
    void collect(ITestDevice device, DeviceMetricData runData) throws InterruptedException {
        this.collectIonAudio(device);
        this.collectIonSystem(device);
    }

    private void collectIonAudio(ITestDevice device) {
        try {
            LogUtil.CLog.i((String)"Running ionheap audio collector...");
            String outputFileName = String.format("%s/ion-audio-%s", this.createTempDir(), this.getFileSuffix());
            File outputFile = this.saveProcessOutput(device, "cat /d/ion/heaps/audio", outputFileName);
            try (FileInputStreamSource source = new FileInputStreamSource(outputFile, true);){
                this.getInvocationListener().testLog(Files.getNameWithoutExtension(outputFile.getName()), LogDataType.TEXT, (InputStreamSource)source);
            }
        }
        catch (DeviceNotAvailableException | IOException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private void collectIonSystem(ITestDevice device) {
        try {
            LogUtil.CLog.i((String)"Running ionheap system collector...");
            String outputFileName = String.format("%s/ion-system-%s", this.createTempDir(), this.getFileSuffix());
            File outputFile = this.saveProcessOutput(device, "cat /d/ion/heaps/system", outputFileName);
            try (FileInputStreamSource source = new FileInputStreamSource(outputFile, true);){
                this.getInvocationListener().testLog(Files.getNameWithoutExtension(outputFile.getName()), LogDataType.TEXT, (InputStreamSource)source);
            }
        }
        catch (DeviceNotAvailableException | IOException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }
}

