/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.loganalysis.item.GenericTimingItem;
import com.android.loganalysis.parser.TimingsLogParser;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LogcatReceiver;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@OptionClass(alias="logcat-timing-metric-collector")
public class LogcatTimingMetricCollector
extends BaseDeviceMetricCollector {
    private static final String LOGCAT_NAME_FORMAT = "device_%s_test_logcat";
    private static final String LOGCAT_CMD = "logcat *:D -T 150";
    @Option(name="start-pattern", description="Key-value pairs to specify the timing metric start patterns to capture from logcat. Key: metric name, value: regex pattern of logcat line indicating the start of the timing metric")
    private final Map<String, String> mStartPatterns = new HashMap<String, String>();
    @Option(name="end-pattern", description="Key-value pairs to specify the timing metric end patterns to capture from logcat. Key: metric name, value: regex pattern of logcat line indicating the end of the timing metric")
    private final Map<String, String> mEndPatterns = new HashMap<String, String>();
    @Option(name="logcat-buffer", description="Logcat buffers where the timing metrics are captured. Default buffers will be used if not specified.")
    private final List<String> mLogcatBuffers = new ArrayList<String>();
    @Option(name="per-run", description="Collect timing metrics at test run level if true, otherwise collect at test level.")
    private boolean mPerRun = true;
    private final Map<ITestDevice, LogcatReceiver> mLogcatReceivers = new HashMap<ITestDevice, LogcatReceiver>();
    private final TimingsLogParser mParser = new TimingsLogParser();
    private String mLogcatCmd = "logcat *:D -T 150";

    public void onTestRunStart(DeviceMetricData testData) {
        this.mParser.clearDurationPatterns();
        for (Map.Entry<String, String> entry : this.mStartPatterns.entrySet()) {
            String name = entry.getKey();
            if (!this.mEndPatterns.containsKey(name)) {
                LogUtil.CLog.w((String)"Metric %s is missing end pattern, skipping.", (Object[])new Object[]{name});
                continue;
            }
            Pattern start = Pattern.compile(entry.getValue());
            Pattern end = Pattern.compile(this.mEndPatterns.get(name));
            LogUtil.CLog.d((String)"Adding metric: %s", (Object[])new Object[]{name});
            this.mParser.addDurationPatternPair(name, start, end);
        }
        if (!this.mLogcatBuffers.isEmpty()) {
            this.mLogcatCmd = this.mLogcatCmd + " -b " + String.join((CharSequence)",", this.mLogcatBuffers);
        }
        if (this.mPerRun) {
            this.startCollection();
        }
    }

    public void onTestRunEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) {
        if (this.mPerRun) {
            this.collectMetrics(testData);
            this.stopCollection();
        }
    }

    public void onTestStart(DeviceMetricData testData) {
        if (!this.mPerRun) {
            this.startCollection();
        }
    }

    public void onTestEnd(DeviceMetricData testData, Map<String, MetricMeasurement.Metric> currentTestCaseMetrics) {
        if (!this.mPerRun) {
            this.collectMetrics(testData);
            this.stopCollection();
        }
    }

    public void onTestFail(DeviceMetricData testData, TestDescription test) {
        for (ITestDevice device : this.getDevices()) {
            InputStreamSource logcatData = this.mLogcatReceivers.get(device).getLogcatData();
            try {
                this.testLog(String.format(LOGCAT_NAME_FORMAT, device.getSerialNumber()), LogDataType.TEXT, logcatData);
            }
            finally {
                if (logcatData == null) continue;
                logcatData.close();
            }
        }
        this.stopCollection();
    }

    private void startCollection() {
        for (ITestDevice device : this.getDevices()) {
            LogUtil.CLog.d((String)"Creating logcat receiver on device %s with command %s", (Object[])new Object[]{device.getSerialNumber(), this.mLogcatCmd});
            this.mLogcatReceivers.put(device, this.createLogcatReceiver(device, this.mLogcatCmd));
            try {
                device.executeShellCommand("logcat -c");
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Device not available when clear logcat. Skip logcat collection on %s", (Object[])new Object[]{device.getSerialNumber()});
                continue;
            }
            this.mLogcatReceivers.get(device).start();
        }
    }

    private void collectMetrics(DeviceMetricData testData) {
        boolean isMultiDevice = this.getDevices().size() > 1;
        for (ITestDevice device : this.getDevices()) {
            InputStreamSource logcatData = this.mLogcatReceivers.get(device).getLogcatData();
            try {
                Map<String, List<Double>> metrics = this.parse(logcatData);
                for (Map.Entry<String, List<Double>> entry : metrics.entrySet()) {
                    String name = entry.getKey();
                    List<Double> values = entry.getValue();
                    if (isMultiDevice) {
                        testData.addMetricForDevice(device, name, this.createMetric(values));
                    } else {
                        testData.addMetric(name, this.createMetric(values));
                    }
                    LogUtil.CLog.d((String)"Metric: %s with value: %s, added to device %s", (Object[])new Object[]{name, values, device.getSerialNumber()});
                }
                this.testLog(String.format(LOGCAT_NAME_FORMAT, device.getSerialNumber()), LogDataType.TEXT, logcatData);
            }
            finally {
                if (logcatData == null) continue;
                logcatData.close();
            }
        }
    }

    private void stopCollection() {
        for (ITestDevice device : this.getDevices()) {
            this.mLogcatReceivers.get(device).stop();
            this.mLogcatReceivers.get(device).clear();
        }
    }

    @VisibleForTesting
    Map<String, List<Double>> parse(InputStreamSource logcatData) {
        HashMap<String, List<Double>> metrics = new HashMap<String, List<Double>>();
        try (InputStream inputStream = logcatData.createInputStream();
             InputStreamReader logcatReader = new InputStreamReader(inputStream);
             BufferedReader br = new BufferedReader(logcatReader);){
            List items = this.mParser.parseGenericTimingItems(br);
            for (GenericTimingItem item : items) {
                String metricKey = item.getName();
                if (!metrics.containsKey(metricKey)) {
                    metrics.put(metricKey, new ArrayList());
                }
                ((List)metrics.get(metricKey)).add(item.getDuration());
            }
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Failed to parse timing metrics from logcat %s", (Object[])new Object[]{e});
        }
        return metrics;
    }

    @VisibleForTesting
    LogcatReceiver createLogcatReceiver(ITestDevice device, String logcatCmd) {
        return new LogcatReceiver(device, logcatCmd, device.getOptions().getMaxLogcatDataSize(), 0);
    }

    private MetricMeasurement.Metric.Builder createMetric(List<Double> values) {
        String stringValue = values.stream().map(value -> Double.toString(value)).collect(Collectors.joining(","));
        return MetricMeasurement.Metric.newBuilder().setType(MetricMeasurement.DataType.RAW).setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleString(stringValue));
    }
}

