/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.os.AtomsProto;
import com.android.os.StatsLog;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.android.tradefed.util.statsd.ConfigUtil;
import com.android.tradefed.util.statsd.MetricUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@OptionClass(alias="reboot-reason-collector")
public class RebootReasonCollector
extends BaseDeviceMetricCollector {
    private static final String METRIC_SEP = "-";
    public static final String METRIC_PREFIX = "rebooted-";
    public static final String COUNT_KEY = String.join((CharSequence)"-", "reboot", "count");
    private List<ITestDevice> mTestDevices;
    private Map<String, Long> mDeviceConfigIds = new HashMap<String, Long>();

    public void onTestRunStart(DeviceMetricData runData) {
        this.mTestDevices = this.getDevices();
        for (ITestDevice device : this.mTestDevices) {
            try {
                this.mDeviceConfigIds.put(device.getSerialNumber(), this.pushStatsConfig(device, Arrays.asList(57)));
            }
            catch (DeviceNotAvailableException | IOException e) {
                LogUtil.CLog.e((String)"Failed to push statsd config to device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e.toString()});
            }
        }
    }

    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        for (ITestDevice device : this.mTestDevices) {
            ArrayList<StatsLog.EventMetricData> metricData = new ArrayList<StatsLog.EventMetricData>();
            if (!this.mDeviceConfigIds.containsKey(device.getSerialNumber())) {
                LogUtil.CLog.e((String)"No config ID is associated with device %s.", (Object[])new Object[]{device.getSerialNumber()});
                continue;
            }
            long configId = this.mDeviceConfigIds.get(device.getSerialNumber());
            try {
                metricData.addAll(this.getEventMetricData(device, configId));
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Failed to pull metric data from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e.toString()});
            }
            HashMap<String, Integer> metricsForDevice = new HashMap<String, Integer>();
            int rebootCount = 0;
            for (StatsLog.EventMetricData eventMetricEntry : metricData) {
                AtomsProto.Atom eventAtom = eventMetricEntry.getAtom();
                if (!eventAtom.hasBootSequenceReported()) continue;
                ++rebootCount;
                AtomsProto.BootSequenceReported bootAtom = eventAtom.getBootSequenceReported();
                String bootReasonKey = METRIC_PREFIX + String.join((CharSequence)METRIC_SEP, bootAtom.getBootloaderReason(), bootAtom.getSystemReason());
                metricsForDevice.computeIfPresent(bootReasonKey, (k, v) -> v + 1);
                metricsForDevice.computeIfAbsent(bootReasonKey, k -> 1);
            }
            for (String key : metricsForDevice.keySet()) {
                runData.addMetricForDevice(device, key, TfMetricProtoUtil.stringToMetric((String)String.valueOf(metricsForDevice.get(key))).toBuilder());
            }
            runData.addMetricForDevice(device, COUNT_KEY, TfMetricProtoUtil.stringToMetric((String)String.valueOf(rebootCount)).toBuilder());
            try {
                this.removeConfig(device, configId);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Failed to remove statsd config from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e.toString()});
            }
        }
    }

    @VisibleForTesting
    long pushStatsConfig(ITestDevice device, List<Integer> eventAtomIds) throws IOException, DeviceNotAvailableException {
        return ConfigUtil.pushStatsConfig(device, eventAtomIds);
    }

    @VisibleForTesting
    void removeConfig(ITestDevice device, long configId) throws DeviceNotAvailableException {
        ConfigUtil.removeConfig(device, configId);
    }

    @VisibleForTesting
    List<StatsLog.EventMetricData> getEventMetricData(ITestDevice device, long configId) throws DeviceNotAvailableException {
        return MetricUtil.getEventMetricData(device, configId);
    }
}

