/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.os.StatsLog;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.android.tradefed.util.statsd.ConfigUtil;
import com.android.tradefed.util.statsd.MetricUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@OptionClass(alias="runtime-restart-collector")
public class RuntimeRestartCollector
extends BaseDeviceMetricCollector {
    private static final String METRIC_SEP = "-";
    public static final String METRIC_PREFIX = "runtime-restart";
    public static final String METRIC_SUFFIX_COUNT = "count";
    public static final String METRIC_SUFFIX_SYSTEM_TIMESTAMP_SECS = "timestamps_secs";
    public static final String METRIC_SUFFIX_SYSTEM_TIMESTAMP_FORMATTED = "timestamps_str";
    public static final String METRIC_SUFFIX_UPTIME_NANOS = "uptime_nanos";
    public static final String METRIC_SUFFIX_UPTIME_FORMATTED = "uptime_str";
    public static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    public static final String SYSTEM_SERVER_KEYWORD = "system_server";
    private List<ITestDevice> mTestDevices;
    private Map<String, List<Integer>> mExistingTimestamps = new HashMap<String, List<Integer>>();
    private Map<String, Long> mDeviceConfigIds = new HashMap<String, Long>();
    private boolean mIncludeDeviceSerial = false;

    public void onTestRunStart(DeviceMetricData runData) {
        this.mTestDevices = this.getDevices();
        this.mIncludeDeviceSerial = this.mTestDevices.size() > 1;
        for (ITestDevice device : this.mTestDevices) {
            try {
                List existingTimestamps = this.getStatsdMetadata(device).getSystemRestartSecList();
                this.mExistingTimestamps.put(device.getSerialNumber(), existingTimestamps);
            }
            catch (DeviceNotAvailableException | InvalidProtocolBufferException e) {
                LogUtil.CLog.e((String)"Failed to get statsd metadata from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e});
            }
            try {
                this.mDeviceConfigIds.put(device.getSerialNumber(), this.pushStatsConfig(device, Arrays.asList(78)));
            }
            catch (DeviceNotAvailableException | IOException e) {
                LogUtil.CLog.e((String)"Failed to push statsd config to device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e});
            }
        }
    }

    public void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        for (ITestDevice device : this.mTestDevices) {
            ArrayList<Integer> updatedTimestamps = new ArrayList<Integer>();
            try {
                updatedTimestamps.addAll(this.getStatsdMetadata(device).getSystemRestartSecList());
            }
            catch (DeviceNotAvailableException | InvalidProtocolBufferException e) {
                LogUtil.CLog.e((String)"Failed to get statsd metadata from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e});
                continue;
            }
            if (!this.mExistingTimestamps.containsKey(device.getSerialNumber())) {
                LogUtil.CLog.e((String)"No prior state recorded for device %s.", (Object[])new Object[]{device.getSerialNumber()});
                this.addStatsdStatsBasedMetrics(currentRunMetrics, updatedTimestamps, device.getSerialNumber());
                continue;
            }
            try {
                int lastTimestampBeforeTestRun = (Integer)Iterables.getLast((Iterable)this.mExistingTimestamps.get(device.getSerialNumber()));
                this.addStatsdStatsBasedMetrics(currentRunMetrics, this.getAllValuesAfter(lastTimestampBeforeTestRun, updatedTimestamps), device.getSerialNumber());
            }
            catch (NoSuchElementException e) {
                this.addStatsdStatsBasedMetrics(currentRunMetrics, updatedTimestamps, device.getSerialNumber());
            }
        }
        for (ITestDevice device : this.mTestDevices) {
            if (!this.mDeviceConfigIds.containsKey(device.getSerialNumber())) {
                LogUtil.CLog.e((String)"No config ID is associated with device %s.", (Object[])new Object[]{device.getSerialNumber()});
                continue;
            }
            long configId = this.mDeviceConfigIds.get(device.getSerialNumber());
            ArrayList<Long> uptimeListNanos = new ArrayList<Long>();
            try {
                List<StatsLog.EventMetricData> metricData = this.getEventMetricData(device, configId);
                uptimeListNanos.addAll(metricData.stream().filter(d -> d.hasElapsedTimestampNanos()).filter(d -> d.hasAtom()).filter(d -> d.getAtom().hasAppCrashOccurred()).filter(d -> d.getAtom().getAppCrashOccurred().hasProcessName()).filter(d -> SYSTEM_SERVER_KEYWORD.equals(d.getAtom().getAppCrashOccurred().getProcessName())).map(d -> d.getElapsedTimestampNanos()).collect(Collectors.toList()));
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Failed to retrieve event metric data from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e});
            }
            this.addAtomBasedMetrics(currentRunMetrics, uptimeListNanos, device.getSerialNumber());
            try {
                this.removeConfig(device, configId);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((String)"Failed to remove statsd config from device %s. Exception: %s.", (Object[])new Object[]{device.getSerialNumber(), e});
            }
        }
    }

    private void addStatsdStatsBasedMetrics(Map<String, MetricMeasurement.Metric> metrics, List<Integer> timestampsSecs, String serial) {
        String countMetricKey = this.createMetricKey(METRIC_SUFFIX_COUNT, serial);
        metrics.put(countMetricKey, TfMetricProtoUtil.stringToMetric((String)String.valueOf(timestampsSecs.size())));
        if (!timestampsSecs.isEmpty()) {
            String timestampMetricKey = this.createMetricKey(METRIC_SUFFIX_SYSTEM_TIMESTAMP_SECS, serial);
            metrics.put(timestampMetricKey, TfMetricProtoUtil.stringToMetric((String)timestampsSecs.stream().map(t -> String.valueOf(t)).collect(Collectors.joining(","))));
            String formattedTimestampMetricKey = this.createMetricKey(METRIC_SUFFIX_SYSTEM_TIMESTAMP_FORMATTED, serial);
            metrics.put(formattedTimestampMetricKey, TfMetricProtoUtil.stringToMetric((String)timestampsSecs.stream().map(t -> this.timestampToHoursMinutesSeconds((int)t)).collect(Collectors.joining(","))));
        }
    }

    private void addAtomBasedMetrics(Map<String, MetricMeasurement.Metric> metrics, List<Long> timestampsNanos, String serial) {
        if (!timestampsNanos.isEmpty()) {
            String uptimeNanosMetricKey = this.createMetricKey(METRIC_SUFFIX_UPTIME_NANOS, serial);
            metrics.put(uptimeNanosMetricKey, TfMetricProtoUtil.stringToMetric((String)timestampsNanos.stream().map(t -> String.valueOf(t)).collect(Collectors.joining(","))));
            String formattedUptimeMetricKey = this.createMetricKey(METRIC_SUFFIX_UPTIME_FORMATTED, serial);
            metrics.put(formattedUptimeMetricKey, TfMetricProtoUtil.stringToMetric((String)timestampsNanos.stream().map(t -> this.nanosToHoursMinutesSeconds((long)t)).collect(Collectors.joining(","))));
        }
    }

    private String createMetricKey(String suffix, String serial) {
        return this.mIncludeDeviceSerial ? String.join((CharSequence)METRIC_SEP, METRIC_PREFIX, serial, suffix) : String.join((CharSequence)METRIC_SEP, METRIC_PREFIX, suffix);
    }

    @VisibleForTesting
    protected long pushStatsConfig(ITestDevice device, List<Integer> eventAtomIds) throws IOException, DeviceNotAvailableException {
        return ConfigUtil.pushStatsConfig(device, eventAtomIds);
    }

    @VisibleForTesting
    protected void removeConfig(ITestDevice device, long configId) throws DeviceNotAvailableException {
        ConfigUtil.removeConfig(device, configId);
    }

    @VisibleForTesting
    protected StatsLog.StatsdStatsReport getStatsdMetadata(ITestDevice device) throws DeviceNotAvailableException, InvalidProtocolBufferException {
        return MetricUtil.getStatsdMetadata(device);
    }

    @VisibleForTesting
    protected List<StatsLog.EventMetricData> getEventMetricData(ITestDevice device, long configId) throws DeviceNotAvailableException {
        return MetricUtil.getEventMetricData(device, configId);
    }

    private String nanosToHoursMinutesSeconds(long nanos) {
        long hours = TimeUnit.NANOSECONDS.toHours(nanos);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(nanos -= TimeUnit.HOURS.toNanos(hours));
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanos -= TimeUnit.MINUTES.toNanos(minutes));
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private String timestampToHoursMinutesSeconds(int seconds) {
        return TIME_FORMATTER.format(new Date(TimeUnit.SECONDS.toMillis(seconds)));
    }

    private List<Integer> getAllValuesAfter(int target, List<Integer> l) {
        return l.subList(l.lastIndexOf(target) + 1, l.size());
    }
}

