/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ScheduleMultipleDeviceMetricCollector
extends BaseDeviceMetricCollector {
    @Option(name="metric-collection-intervals", description="The interval at which the collectors should run.")
    private Map<String, Long> mIntervalMs = new HashMap<String, Long>();
    @Option(name="metric-storage-path", description="Absolute path to a directory on host where the collected metrics will be stored.")
    private File mMetricStoragePath = new File(System.getProperty("java.io.tmpdir"));
    @Option(name="metric-collector-command-classes", description="Complete package name of a class which registers the commands to do the actual job of collection. Can be repeated.")
    private List<String> mMetricCollectorClasses = new ArrayList<String>();
    private List<ScheduledDeviceMetricCollector> mMetricCollectors = new ArrayList<ScheduledDeviceMetricCollector>();
    private Map<ScheduledDeviceMetricCollector, Long> mMetricCollectorIntervals = new HashMap<ScheduledDeviceMetricCollector, Long>();
    private Map<ScheduledDeviceMetricCollector, Long> mLastUpdate = new HashMap<ScheduledDeviceMetricCollector, Long>();
    private Timer mTimer;
    private long mScheduleRate;

    public ITestInvocationListener init(IInvocationContext context, ITestInvocationListener listener) {
        super.init(context, listener);
        this.initMetricCollectors(context, listener);
        return this;
    }

    private void initMetricCollectors(IInvocationContext context, ITestInvocationListener listener) {
        for (String metricCollectorClass : this.mMetricCollectorClasses) {
            try {
                Class<?> klass = Class.forName(metricCollectorClass);
                ScheduledDeviceMetricCollector singleMetricCollector = klass.asSubclass(ScheduledDeviceMetricCollector.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                singleMetricCollector.init(context, listener);
                this.mMetricCollectors.add(singleMetricCollector);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LogUtil.CLog.e((String)"Class %s not found, skipping.", (Object[])new Object[]{metricCollectorClass});
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    public final void onTestRunStart(final DeviceMetricData runData) {
        if (this.mMetricCollectorClasses.isEmpty()) {
            LogUtil.CLog.w((String)"No single metric class provided. Skipping collection.");
            return;
        }
        this.setupCollection();
        if (this.mScheduleRate == 0L) {
            LogUtil.CLog.e((String)"Failed to get a valid interval for even one metric collector. Please make sure that the collectors have non-zero intervals specified as an argument to this class.");
            return;
        }
        this.mTimer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ScheduleMultipleDeviceMetricCollector.this.collect(runData);
            }
        };
        this.mTimer.scheduleAtFixedRate(timerTask, 0L, this.mScheduleRate);
    }

    private void setupCollection() {
        this.parseAllArgs();
        for (ScheduledDeviceMetricCollector singleMetricCollector : this.mMetricCollectorIntervals.keySet()) {
            this.mLastUpdate.put(singleMetricCollector, System.currentTimeMillis());
        }
        this.mScheduleRate = this.gcdOfIntervals();
    }

    private void collect(DeviceMetricData runData) {
        for (ScheduledDeviceMetricCollector singleMetricCollector : this.mMetricCollectorIntervals.keySet()) {
            Long elapsedTime = System.currentTimeMillis() - this.mLastUpdate.get((Object)singleMetricCollector);
            Long taskInterval = this.mMetricCollectorIntervals.get((Object)singleMetricCollector);
            if (elapsedTime < taskInterval) continue;
            try {
                for (ITestDevice device : this.getDevices()) {
                    singleMetricCollector.collect(device, runData);
                }
                this.mLastUpdate.put(singleMetricCollector, System.currentTimeMillis());
            }
            catch (InterruptedException e) {
                LogUtil.CLog.e((String)"Exception during %s", (Object[])new Object[]{((Object)((Object)singleMetricCollector)).getClass()});
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    private void parseAllArgs() {
        for (ScheduledDeviceMetricCollector metricCollector : this.mMetricCollectors) {
            Long value = this.mIntervalMs.getOrDefault(metricCollector.getTag(), 0L);
            if (value > 0L) {
                this.mMetricCollectorIntervals.put(metricCollector, value);
                continue;
            }
            if (value >= 0L) continue;
            throw new IllegalArgumentException(((Object)((Object)metricCollector)).getClass() + " expects a non negative interval.");
        }
    }

    private Long gcdOfIntervals() {
        Collection<Long> intervals = this.mMetricCollectorIntervals.values();
        if (intervals.isEmpty()) {
            return 0L;
        }
        BigInteger gcdSoFar = new BigInteger(intervals.iterator().next().toString());
        for (Long interval : intervals) {
            gcdSoFar = gcdSoFar.gcd(new BigInteger(interval.toString()));
        }
        return gcdSoFar.longValue();
    }

    public final void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
        }
    }
}

