/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.BaseDeviceMetricCollector;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public abstract class ScheduledDeviceMetricCollector
extends BaseDeviceMetricCollector {
    @Option(name="fixed-schedule-rate", description="Schedule the timetask as a fixed schedule rate")
    private boolean mFixedScheduleRate = false;
    @Option(name="interval", description="the interval between two tasks being scheduled", isTimeVal=true)
    private long mIntervalMs = 60000L;
    private Timer timer;

    public final void onTestRunStart(final DeviceMetricData runData) {
        LogUtil.CLog.d((String)"starting with interval = %s", (Object[])new Object[]{this.mIntervalMs});
        this.onStart(runData);
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    for (ITestDevice device : ScheduledDeviceMetricCollector.this.getDevices()) {
                        ScheduledDeviceMetricCollector.this.collect(device, runData);
                    }
                }
                catch (InterruptedException e) {
                    ScheduledDeviceMetricCollector.this.timer.cancel();
                    Thread.currentThread().interrupt();
                    LogUtil.CLog.e((String)"Interrupted exception thrown from task:");
                    LogUtil.CLog.e((Throwable)e);
                }
            }
        };
        if (this.mFixedScheduleRate) {
            this.timer.scheduleAtFixedRate(timerTask, 0L, this.mIntervalMs);
        } else {
            this.timer.schedule(timerTask, 0L, this.mIntervalMs);
        }
    }

    public final void onTestRunEnd(DeviceMetricData runData, Map<String, MetricMeasurement.Metric> currentRunMetrics) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        this.onEnd(runData);
        LogUtil.CLog.d((String)"finished");
    }

    abstract void collect(ITestDevice var1, DeviceMetricData var2) throws InterruptedException;

    void onStart(DeviceMetricData runData) {
    }

    void onEnd(DeviceMetricData runData) {
    }

    File saveProcessOutput(ITestDevice device, String command, String outputFileName) throws DeviceNotAvailableException, IOException {
        String output = device.executeShellCommand(command);
        File outputFile = new File(outputFileName);
        FileUtil.writeToFile((String)output, (File)outputFile);
        return outputFile;
    }

    String getFileSuffix() {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS", Locale.US).format(new Date());
    }

    File createTempDir() throws IOException {
        return FileUtil.createTempDir((String)String.format("tmp_%s", this.getTag()));
    }
}

