/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.postprocessor;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.postprocessor.BasePostProcessor;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.ZipUtil2;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.zip.ZipFile;
import perfetto.protos.PerfettoMergedMetrics;

@OptionClass(alias="perfetto-generic-processor")
public class PerfettoGenericPostProcessor
extends BasePostProcessor {
    private static final String METRIC_SEP = "-";
    @Option(name="perfetto-proto-file-prefix", description="Prefix for identifying a perfetto metric file name.")
    private Set<String> mPerfettoProtoMetricFilePrefix = new HashSet<String>();
    @Option(name="perfetto-indexed-list-field", description="List fields in perfetto proto metric file that has to be indexed.")
    private Set<String> mPerfettoIndexedListFields = new HashSet<String>();
    @Option(name="perfetto-prefix-key-field", description="String value field need to be prefixed with the all the othernumeric value field keys in the proto message.")
    private Set<String> mPerfettoPrefixKeyFields = new HashSet<String>();
    @Option(name="perfetto-include-all-metrics", description="If this flag is turned on, all the metrics parsed from the perfetto file will be included in the final result map and ignores the regex passed in the filters.")
    private boolean mPerfettoIncludeAllMetrics = false;
    @Option(name="perfetto-metric-filter-regex", description="Regular expression that will be used for filtering the metrics parsed from the perfetto proto metric file.")
    private Set<String> mPerfettoMetricFilterRegEx = new HashSet<String>();
    @Option(name="trace-processor-output-format", description="Trace processor output format. One of [binary|text|json]")
    private METRIC_FILE_FORMAT mTraceProcessorOutputFormat = METRIC_FILE_FORMAT.text;
    @Option(name="decompress-perfetto-timeout", description="Timeout to decompress perfetto compressed file.", isTimeVal=true)
    private long mDecompressTimeoutMs = TimeUnit.MINUTES.toMillis(20L);
    @Option(name="processed-metric", description="True if the metric is final and shouldn't be processed any more, false if the metric can be handled by another post-processor.")
    private boolean mProcessedMetric = true;
    @Option(name="perfetto-metric-replace-prefix", description="Replace the prefix in metricsfrom the metric proto file. Key is the prefix to look for in the metrickeys parsed and value is be the replacement string.")
    private Map<String, String> mReplacePrefixMap = new LinkedHashMap<String, String>();
    @Option(name="perfetto-all-metric-prefix", description="Prefix to be used with the metrics collected from perfetto.This will be applied before any other prefixes to metrics.")
    private String mAllMetricPrefix = "perfetto";
    private Pattern mNumberWithExponentPattern = Pattern.compile("[-+]?[0-9]*[\\.]?[0-9]+([eE][-+]?[0-9]+)?");
    private Pattern mNumberPattern = Pattern.compile("[-+]?[0-9]*[\\.]?[0-9]+");
    private List<Pattern> mMetricPatterns = new ArrayList<Pattern>();

    public Map<String, MetricMeasurement.Metric.Builder> processTestMetricsAndLogs(TestDescription testDescription, HashMap<String, MetricMeasurement.Metric> testMetrics, Map<String, LogFile> testLogs) {
        this.buildMetricFilterPatterns();
        return this.processPerfettoMetrics(this.filterPerfeticMetricFiles(testLogs));
    }

    public Map<String, MetricMeasurement.Metric.Builder> processRunMetricsAndLogs(HashMap<String, MetricMeasurement.Metric> rawMetrics, Map<String, LogFile> runLogs) {
        this.buildMetricFilterPatterns();
        return this.processPerfettoMetrics(this.filterPerfeticMetricFiles(runLogs));
    }

    private List<File> filterPerfeticMetricFiles(Map<String, LogFile> logs) {
        ArrayList<File> perfettoMetricFiles = new ArrayList<File>();
        for (String key : logs.keySet()) {
            Optional<String> reportPrefix = this.mPerfettoProtoMetricFilePrefix.stream().filter(prefix -> key.startsWith((String)prefix)).findAny();
            if (!reportPrefix.isPresent()) continue;
            perfettoMetricFiles.add(new File(logs.get(key).getPath()));
        }
        return perfettoMetricFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics(List<File> perfettoMetricFiles) {
        parsedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        uncompressedDir = null;
        for (File perfettoMetricFile : perfettoMetricFiles) {
            try {
                if (this.mTraceProcessorOutputFormat != METRIC_FILE_FORMAT.binary && ZipUtil.isZipFileValid((File)perfettoMetricFile, (boolean)true)) {
                    perfettoZippedFile = new ZipFile(perfettoMetricFile);
                    uncompressedDir = FileUtil.createTempDir((String)"uncompressed_perfetto_metric");
                    ZipUtil2.extractZip((ZipFile)perfettoZippedFile, (File)uncompressedDir);
                    perfettoMetricFile = uncompressedDir.listFiles()[0];
                    perfettoZippedFile.close();
                }
            }
            catch (IOException e) {
                LogUtil.CLog.e((String)("IOException happened when unzipping the perfetto metric proto file." + e.getMessage()));
            }
            try {
                bufferedReader = new BufferedReader(new FileReader(perfettoMetricFile));
                try {
                    switch (1.$SwitchMap$com$android$tradefed$postprocessor$PerfettoGenericPostProcessor$METRIC_FILE_FORMAT[this.mTraceProcessorOutputFormat.ordinal()]) {
                        case 1: {
                            builder = PerfettoMergedMetrics.TraceMetrics.newBuilder();
                            TextFormat.merge(bufferedReader, (Message.Builder)builder);
                            parsedMetrics.putAll(this.filterMetrics(this.convertPerfettoProtoMessage(builder.build())));
                            this.replacePrefix(parsedMetrics);
                            this.replaceAllMetricPrefix(parsedMetrics);
                            ** break;
lbl25:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            metricProto = null;
                            metricProto = PerfettoMergedMetrics.TraceMetrics.parseFrom(new FileInputStream(perfettoMetricFile));
                            parsedMetrics.putAll(this.filterMetrics(this.convertPerfettoProtoMessage(metricProto)));
                            this.replacePrefix(parsedMetrics);
                            this.replaceAllMetricPrefix(parsedMetrics);
                            ** break;
lbl33:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            LogUtil.CLog.w((String)"JSON perfetto metric file processing not supported.");
                            break;
                        }
                        ** default:
lbl38:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (TextFormat.ParseException e) {
                LogUtil.CLog.e((String)("Failed to merge the perfetto metric file. " + e.getMessage()));
                FileUtil.recursiveDelete((File)uncompressedDir);
                continue;
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)("IOException happened when reading the perfetto metric file. " + ioe.getMessage()));
                {
                    catch (Throwable var9_14) {
                        FileUtil.recursiveDelete(uncompressedDir);
                        throw var9_14;
                    }
                }
                FileUtil.recursiveDelete((File)uncompressedDir);
                continue;
            }
            FileUtil.recursiveDelete((File)uncompressedDir);
        }
        return parsedMetrics;
    }

    private void replacePrefix(Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics) {
        if (this.mReplacePrefixMap.isEmpty()) {
            return;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<String, MetricMeasurement.Metric.Builder> metric : processPerfettoMetrics.entrySet()) {
            boolean isReplaced = false;
            for (Map.Entry<String, String> replaceEntry : this.mReplacePrefixMap.entrySet()) {
                if (!metric.getKey().startsWith(replaceEntry.getKey())) continue;
                String newKey = metric.getKey().replaceFirst(replaceEntry.getKey(), replaceEntry.getValue());
                finalMetrics.put(newKey, metric.getValue());
                isReplaced = true;
                break;
            }
            if (isReplaced) continue;
            finalMetrics.put(metric.getKey(), metric.getValue());
        }
        processPerfettoMetrics.clear();
        processPerfettoMetrics.putAll(finalMetrics);
    }

    private void replaceAllMetricPrefix(Map<String, MetricMeasurement.Metric.Builder> processPerfettoMetrics) {
        if (this.mAllMetricPrefix == null || this.mAllMetricPrefix.isEmpty()) {
            return;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> finalMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (Map.Entry<String, MetricMeasurement.Metric.Builder> metric : processPerfettoMetrics.entrySet()) {
            String newKey = String.format("%s_%s", this.mAllMetricPrefix, metric.getKey());
            finalMetrics.put(newKey, metric.getValue());
            LogUtil.CLog.d((String)"Perfetto trace metric: key: %s value: %s", (Object[])new Object[]{newKey, metric.getValue()});
        }
        processPerfettoMetrics.clear();
        processPerfettoMetrics.putAll(finalMetrics);
    }

    private Map<String, MetricMeasurement.Metric.Builder> convertPerfettoProtoMessage(Message reportMessage) {
        Map<Descriptors.FieldDescriptor, Object> fields = reportMessage.getAllFields();
        HashMap<String, MetricMeasurement.Metric.Builder> convertedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        ArrayList<String> keyPrefixes = new ArrayList<String>();
        ArrayList<String> keyPrefixOtherFields = new ArrayList<String>();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            if (entry.getValue() instanceof Message || entry.getValue() instanceof List) continue;
            if (this.isNumeric(entry.getValue().toString())) {
                if (this.mNumberPattern.matcher(entry.getValue().toString()).matches()) {
                    convertedMetrics.put(entry.getKey().getName(), TfMetricProtoUtil.stringToMetric((String)entry.getValue().toString()).toBuilder());
                    continue;
                }
                convertedMetrics.put(entry.getKey().getName(), TfMetricProtoUtil.stringToMetric((String)Long.toString(Double.valueOf(entry.getValue().toString()).longValue())).toBuilder());
                continue;
            }
            keyPrefixes.add(String.join((CharSequence)METRIC_SEP, entry.getKey().getName().toString(), entry.getValue().toString()));
            if (!this.mPerfettoPrefixKeyFields.contains(entry.getKey().toString())) continue;
            keyPrefixOtherFields.add(String.format("%s-%s", entry.getKey().getName().toString(), entry.getValue().toString()));
        }
        HashMap<String, MetricMeasurement.Metric.Builder> additionalConvertedMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        for (String string : keyPrefixOtherFields) {
            for (Map.Entry currentMetric : convertedMetrics.entrySet()) {
                additionalConvertedMetrics.put(String.format("%s-%s", string, currentMetric.getKey()), (MetricMeasurement.Metric.Builder)currentMetric.getValue());
            }
        }
        convertedMetrics.putAll(additionalConvertedMetrics);
        for (Map.Entry entry : fields.entrySet()) {
            if (entry.getValue() instanceof Message) {
                Map<String, MetricMeasurement.Metric.Builder> messageMetrics = this.convertPerfettoProtoMessage((Message)entry.getValue());
                for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : messageMetrics.entrySet()) {
                    for (String prefix : keyPrefixes) {
                        convertedMetrics.put(String.join((CharSequence)METRIC_SEP, prefix, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), metricEntry.getKey()), metricEntry.getValue());
                    }
                    if (!keyPrefixes.isEmpty()) continue;
                    convertedMetrics.put(String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), metricEntry.getKey()), metricEntry.getValue());
                }
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            List listMetrics = (List)entry.getValue();
            for (int i = 0; i < listMetrics.size(); ++i) {
                String metricKeyRoot = this.mPerfettoIndexedListFields.contains(((Descriptors.FieldDescriptor)entry.getKey()).toString()) ? String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName(), String.valueOf(i + 1)) : String.join((CharSequence)METRIC_SEP, ((Descriptors.FieldDescriptor)entry.getKey()).getName());
                if (listMetrics.get(i) instanceof Message) {
                    Map<String, MetricMeasurement.Metric.Builder> messageMetrics = this.convertPerfettoProtoMessage((Message)listMetrics.get(i));
                    for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : messageMetrics.entrySet()) {
                        for (String prefix : keyPrefixes) {
                            convertedMetrics.put(String.join((CharSequence)METRIC_SEP, prefix, metricKeyRoot, metricEntry.getKey()), metricEntry.getValue());
                        }
                        if (!keyPrefixes.isEmpty()) continue;
                        convertedMetrics.put(String.join((CharSequence)METRIC_SEP, metricKeyRoot, metricEntry.getKey()), metricEntry.getValue());
                    }
                    continue;
                }
                convertedMetrics.put(metricKeyRoot, TfMetricProtoUtil.stringToMetric((String)listMetrics.get(i).toString()).toBuilder());
            }
        }
        return convertedMetrics;
    }

    private boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        return this.mNumberWithExponentPattern.matcher(strNum).matches();
    }

    private void buildMetricFilterPatterns() {
        if (!this.mPerfettoMetricFilterRegEx.isEmpty() && this.mMetricPatterns.isEmpty()) {
            for (String regEx : this.mPerfettoMetricFilterRegEx) {
                this.mMetricPatterns.add(Pattern.compile(regEx));
            }
        }
    }

    private Map<String, MetricMeasurement.Metric.Builder> filterMetrics(Map<String, MetricMeasurement.Metric.Builder> parsedMetrics) {
        if (this.mPerfettoIncludeAllMetrics) {
            return parsedMetrics;
        }
        HashMap<String, MetricMeasurement.Metric.Builder> filteredMetrics = new HashMap<String, MetricMeasurement.Metric.Builder>();
        block0: for (Map.Entry<String, MetricMeasurement.Metric.Builder> metricEntry : parsedMetrics.entrySet()) {
            for (Pattern pattern : this.mMetricPatterns) {
                if (!pattern.matcher(metricEntry.getKey()).matches()) continue;
                filteredMetrics.put(metricEntry.getKey(), metricEntry.getValue());
                continue block0;
            }
        }
        return filteredMetrics;
    }

    protected MetricMeasurement.DataType getMetricType() {
        return this.mProcessedMetric ? MetricMeasurement.DataType.PROCESSED : MetricMeasurement.DataType.RAW;
    }

    public static enum METRIC_FILE_FORMAT {
        text,
        binary,
        json;

    }
}

