/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.helper.aoa.AoaDevice;
import com.android.helper.aoa.UsbHelper;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RegexTrie;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Point;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@OptionClass(alias="aoa-preparer")
public class AoaTargetPreparer
extends BaseTargetPreparer {
    private static final String POINT = "(\\d{1,3}) (\\d{1,3})";
    private static final Pattern KEY = Pattern.compile("\\s+(?:(\\d+)\\*)?([a-zA-Z0-9]+)");
    private static final RegexTrie<Action> ACTIONS = new RegexTrie();
    @Option(name="device-timeout", description="Maximum time to wait for device")
    private Duration mDeviceTimeout = Duration.ofMinutes(1L);
    @Option(name="wait-for-device-online", description="Checks whether the device is online after preparation.")
    private boolean mWaitForDeviceOnline = true;
    @Option(name="action", description="AOAv2 action to perform. Can be repeated.")
    private List<String> mActions = new ArrayList<String>();
    private static final Map<String, Integer> KEYCODES;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mActions.isEmpty()) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        try {
            this.configure(device.getSerialNumber());
        }
        catch (RuntimeException e) {
            throw new TargetSetupError(e.getMessage(), (Throwable)e, device.getDeviceDescriptor());
        }
        if (this.mWaitForDeviceOnline) {
            device.waitForDeviceOnline();
        }
    }

    private void configure(String serialNumber) throws DeviceNotAvailableException {
        try (UsbHelper usb = this.getUsbHelper();
             AoaDevice device = usb.getAoaDevice(serialNumber, this.mDeviceTimeout);){
            if (device == null) {
                throw new DeviceNotAvailableException("AOAv2-compatible device not found", serialNumber);
            }
            LogUtil.CLog.d((String)"Performing %d actions on device %s", (Object[])new Object[]{this.mActions.size(), serialNumber});
            this.mActions.forEach(action -> this.execute(device, (String)action));
        }
    }

    @VisibleForTesting
    UsbHelper getUsbHelper() {
        return new UsbHelper();
    }

    @VisibleForTesting
    void execute(AoaDevice device, String input) {
        LogUtil.CLog.v((String)"Executing '%s' on %s", (Object[])new Object[]{input, device.getSerialNumber()});
        ArrayList args = new ArrayList();
        Action action = (Action)ACTIONS.retrieve(args, new String[]{input});
        if (action == null) {
            throw new IllegalArgumentException(String.format("Invalid action %s", input));
        }
        action.accept(device, (List)args.get(0));
    }

    private static Point parsePoint(String x, String y) {
        return new Point(Integer.decode(x), Integer.decode(y));
    }

    private static Duration parseMillis(String millis) {
        return Duration.ofMillis(Long.parseLong(millis));
    }

    private static Integer parseKeycode(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        if (key.matches("\\s+")) {
            return 44;
        }
        Integer keycode = KEYCODES.get(key.toLowerCase());
        return keycode != null ? keycode : Integer.decode(key);
    }

    static {
        ACTIONS.put((device, args) -> device.click(AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1))), new String[]{String.format("click %s", POINT)});
        ACTIONS.put((device, args) -> device.longClick(AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1))), new String[]{String.format("longClick %s", POINT)});
        ACTIONS.put((device, args) -> {
            Point from = AoaTargetPreparer.parsePoint((String)args.get(0), (String)args.get(1));
            Duration duration = AoaTargetPreparer.parseMillis((String)args.get(2));
            Point to = AoaTargetPreparer.parsePoint((String)args.get(3), (String)args.get(4));
            device.swipe(from, to, duration);
        }, new String[]{String.format("swipe %s (\\d+) %s", POINT, POINT)});
        ACTIONS.put((device, args) -> {
            List keys = Stream.of(((String)args.get(0)).split("")).map(AoaTargetPreparer::parseKeycode).collect(Collectors.toList());
            device.pressKeys(keys);
        }, new String[]{"write ([a-zA-Z0-9\\s]+)"});
        ACTIONS.put((device, args) -> {
            ArrayList<Integer> keys = new ArrayList<Integer>();
            Matcher matcher = KEY.matcher((CharSequence)args.get(0));
            while (matcher.find()) {
                int count = matcher.group(1) == null ? 1 : Integer.decode(matcher.group(1));
                Integer keycode = AoaTargetPreparer.parseKeycode(matcher.group(2));
                keys.addAll(Collections.nCopies(count, keycode));
            }
            device.pressKeys(keys);
        }, new String[]{"key((?: (?:\\d+\\*)?[a-zA-Z0-9]+)+)"});
        ACTIONS.put((device, args) -> device.wakeUp(), new String[]{"wake"});
        ACTIONS.put((device, args) -> device.goHome(), new String[]{"home"});
        ACTIONS.put((device, args) -> device.goBack(), new String[]{"back"});
        ACTIONS.put((device, args) -> {
            Duration duration = AoaTargetPreparer.parseMillis((String)args.get(0));
            device.sleep(duration);
        }, new String[]{"sleep (\\d+)"});
        KEYCODES = new HashMap<String, Integer>();
        KEYCODES.put("a", 4);
        KEYCODES.put("b", 5);
        KEYCODES.put("c", 6);
        KEYCODES.put("d", 7);
        KEYCODES.put("e", 8);
        KEYCODES.put("f", 9);
        KEYCODES.put("g", 10);
        KEYCODES.put("h", 11);
        KEYCODES.put("i", 12);
        KEYCODES.put("j", 13);
        KEYCODES.put("k", 14);
        KEYCODES.put("l", 15);
        KEYCODES.put("m", 16);
        KEYCODES.put("n", 17);
        KEYCODES.put("o", 18);
        KEYCODES.put("p", 19);
        KEYCODES.put("q", 20);
        KEYCODES.put("r", 21);
        KEYCODES.put("s", 22);
        KEYCODES.put("t", 23);
        KEYCODES.put("u", 24);
        KEYCODES.put("v", 25);
        KEYCODES.put("w", 26);
        KEYCODES.put("x", 27);
        KEYCODES.put("y", 28);
        KEYCODES.put("z", 29);
        KEYCODES.put("1", 30);
        KEYCODES.put("2", 31);
        KEYCODES.put("3", 32);
        KEYCODES.put("4", 33);
        KEYCODES.put("5", 34);
        KEYCODES.put("6", 35);
        KEYCODES.put("7", 36);
        KEYCODES.put("8", 37);
        KEYCODES.put("9", 38);
        KEYCODES.put("0", 39);
        KEYCODES.put("enter", 40);
        KEYCODES.put("tab", 43);
        KEYCODES.put("space", 44);
        KEYCODES.put("right", 79);
        KEYCODES.put("left", 80);
        KEYCODES.put("down", 81);
        KEYCODES.put("up", 82);
    }

    @FunctionalInterface
    private static interface Action
    extends BiConsumer<AoaDevice, List<String>> {
    }
}

