/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.BackgroundDeviceAction;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.LargeOutputReceiver;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestLoggerReceiver;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.TestFilePushSetup;
import com.android.tradefed.util.StreamUtil;

@OptionClass(alias="crash-collector")
public class CrashCollector
extends TestFilePushSetup
implements ITestLoggerReceiver {
    private static final String LOG_NAME = "crash-collector-log";
    private ITestLogger mTestLogger;
    private BackgroundDeviceAction mCrashCollector;
    private LargeOutputReceiver mCrashReceiver;
    @Option(name="crash-collector-path", description="Path to crashcollector binary in test artifact bundle.")
    private String mCrashCollectorPath = "local/tmp/crashcollector";
    @Option(name="crash-collector-binary", description="The name of crashcollector binary in test artifact bundle.")
    private String mCrashCollectorBinary = "crashcollector";
    @Option(name="max-crash-log-size", description="Max size to retain for crash logs.")
    private long mMaxCrashLogSize = 0xA00000L;

    boolean shouldDisable(ITestDevice device, IBuildInfo buildInfo) throws DeviceNotAvailableException {
        if (this.isDisabled()) {
            return true;
        }
        if (!device.checkApiLevelAgainstNextRelease(24)) {
            LogUtil.CLog.i((String)"API Level too low: %s.", (Object[])new Object[]{device.getApiLevel()});
            return true;
        }
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            LogUtil.CLog.w((String)"Unsupported build info type: %s, cannot install crashcollector binary", (Object[])new Object[]{buildInfo.getClass().getSimpleName()});
            return true;
        }
        return false;
    }

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IBuildInfo buildInfo;
        ITestDevice device = testInfo.getDevice();
        boolean shouldDisable = this.shouldDisable(device, buildInfo = testInfo.getBuildInfo());
        if (shouldDisable) {
            LogUtil.CLog.i((String)"Crash collector disabled.");
            return;
        }
        this.setThrowIfNoFile(false);
        this.clearTestFileName();
        this.addTestFileName(this.mCrashCollectorPath);
        super.setUp(device, buildInfo);
        if (this.getFailedToPushFiles().contains(this.mCrashCollectorPath)) {
            LogUtil.CLog.w((String)"Failed to push crash collector binary. Skipping the collection.");
            return;
        }
        String crashCollectorPath = String.format("/data/%s/%s", this.mCrashCollectorPath, this.mCrashCollectorBinary);
        device.executeShellCommand("chmod 755 " + crashCollectorPath);
        this.mCrashReceiver = new LargeOutputReceiver("crash-collector", device.getSerialNumber(), this.mMaxCrashLogSize);
        this.mCrashCollector = new BackgroundDeviceAction(crashCollectorPath, "crash-collector", device, (IShellOutputReceiver)this.mCrashReceiver, 0);
        this.mCrashCollector.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown(TestInformation testInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mCrashCollector != null) {
            this.mCrashCollector.cancel();
        }
        if (this.mCrashReceiver != null) {
            this.mCrashReceiver.cancel();
            InputStreamSource iss = this.mCrashReceiver.getData();
            try {
                this.mTestLogger.testLog(LOG_NAME, LogDataType.TEXT, iss);
            }
            finally {
                StreamUtil.cancel((InputStreamSource)iss);
            }
            this.mCrashReceiver.delete();
        }
    }

    public void setTestLogger(ITestLogger testLogger) {
        this.mTestLogger = testLogger;
    }
}

