/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.AbiFormatter;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="install-apk")
public class InstallApkSetup
extends BaseTargetPreparer {
    private static final String LOG_TAG = InstallApkSetup.class.getSimpleName();
    @Option(name="apk-path", description="the filesystem path of the apk to install. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private Collection<File> mApkPaths = new ArrayList<File>();
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;
    @Option(name="install-arg", description="Additional arguments to be passed to install command, including leading dash, e.g. \"-d\"")
    private Collection<String> mInstallArgs = new ArrayList<String>();
    @Option(name="force-queryable", description="Whether apks should be installed as force queryable.")
    private boolean mForceQueryable = true;
    @Option(name="post-install-cmd", description="optional post-install adb shell commands; can be repeated.")
    private List<String> mPostInstallCmds = new ArrayList<String>();
    @Option(name="post-install-cmd-timeout", description="max time allowed in ms for a post-install adb shell command.DeviceUnresponsiveException will be thrown if it is timed out.")
    private long mPostInstallCmdTimeout = 120000L;
    @Option(name="throw-if-install-fail", description="Throw exception if the APK installation failed due to any reason.")
    private boolean mThrowIfInstallFail = false;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        for (File apk : this.mApkPaths) {
            String result;
            String abi;
            if (!apk.exists()) {
                throw new TargetSetupError(String.format("%s does not exist", apk.getAbsolutePath()), device.getDeviceDescriptor());
            }
            Log.i((String)LOG_TAG, (String)String.format("Installing %s on %s", apk.getName(), device.getSerialNumber()));
            if (this.mForceAbi != null && (abi = AbiFormatter.getDefaultAbi((ITestDevice)device, (String)this.mForceAbi)) != null) {
                this.mInstallArgs.add(String.format("--abi %s", abi));
            }
            if (this.mForceQueryable && device.isAppEnumerationSupported() && !this.mInstallArgs.contains("--force-queryable")) {
                this.mInstallArgs.add("--force-queryable");
            }
            if ((result = device.installPackage(apk, true, this.mInstallArgs.toArray(new String[0]))) == null) continue;
            if (this.mThrowIfInstallFail) {
                throw new TargetSetupError(String.format("Stopping test: failed to install %s on device %s. Reason: %s", apk.getAbsolutePath(), device.getSerialNumber(), result), device.getDeviceDescriptor());
            }
            Log.e((String)LOG_TAG, (String)String.format("Failed to install %s on device %s. Reason: %s", apk.getAbsolutePath(), device.getSerialNumber(), result));
        }
        if (this.mPostInstallCmds != null && !this.mPostInstallCmds.isEmpty()) {
            for (String cmd : this.mPostInstallCmds) {
                LogUtil.CLog.d((String)"About to run setup command on device %s: %s", (Object[])new Object[]{device.getSerialNumber(), cmd});
                device.executeShellCommand(cmd, (IShellOutputReceiver)new CollectingOutputReceiver(), this.mPostInstallCmdTimeout, TimeUnit.MILLISECONDS, 1);
            }
        }
    }

    protected Collection<File> getApkPaths() {
        return this.mApkPaths;
    }

    @VisibleForTesting
    public void setApkPaths(Collection<File> paths) {
        this.mApkPaths = paths;
    }

    @VisibleForTesting
    public void setThrowIfInstallFail(boolean throwIfInstallFail) {
        this.mThrowIfInstallFail = throwIfInstallFail;
    }
}

