/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.UserInfo;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import java.util.Map;

@OptionClass(alias="switch-user-target-preparer")
public class SwitchUserTargetPreparer
extends BaseTargetPreparer {
    @Option(name="user-type", description="The type of user to switch to before the module run.")
    private UserInfo.UserType mUserToSwitchTo = UserInfo.UserType.CURRENT;
    private int mPreExecutionCurrentUser;

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        this.mPreExecutionCurrentUser = device.getCurrentUser();
        Map userInfos = device.getUserInfos();
        if (((UserInfo)userInfos.get(this.mPreExecutionCurrentUser)).isUserType(this.mUserToSwitchTo, this.mPreExecutionCurrentUser)) {
            LogUtil.CLog.i((String)"User %d is already user type %s, no action.", (Object[])new Object[]{this.mPreExecutionCurrentUser, this.mUserToSwitchTo.toString()});
            return;
        }
        for (UserInfo userInfo : userInfos.values()) {
            if (!userInfo.isUserType(this.mUserToSwitchTo, this.mPreExecutionCurrentUser)) continue;
            LogUtil.CLog.i((String)"User %d is user type %s, switching from %d", (Object[])new Object[]{userInfo.userId(), this.mUserToSwitchTo.toString(), this.mPreExecutionCurrentUser});
            if (!device.switchUser(userInfo.userId())) {
                throw new TargetSetupError(String.format("Device failed to switch to user %d", userInfo.userId()), device.getDeviceDescriptor());
            }
            return;
        }
        throw new TargetSetupError(String.format("Failed switch to user type %s, no user of that type exists", this.mUserToSwitchTo), device.getDeviceDescriptor());
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (device.switchUser(this.mPreExecutionCurrentUser)) {
            LogUtil.CLog.d((String)"Successfully switched back to user id: %d", (Object[])new Object[]{this.mPreExecutionCurrentUser});
        } else {
            LogUtil.CLog.w((String)"Could not switch back to the user id: %d", (Object[])new Object[]{this.mPreExecutionCurrentUser});
        }
    }
}

