/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.RunUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@OptionClass(alias="temperature-throttle-waiter")
public class TemperatureThrottlingWaiter
extends BaseTargetPreparer {
    @Option(name="poll-interval", description="Interval in seconds, to poll for device temperature; defaults to 30s")
    private long mPollIntervalSecs = 30L;
    @Option(name="max-wait", description="Max wait time in seconds, for device cool down to target temperature; defaults to 20 minutes")
    private long mMaxWaitSecs = 1200L;
    @Option(name="abort-on-timeout", description="If test should be aborted if device is still  above expected temperature; defaults to false")
    private boolean mAbortOnTimeout = false;
    @Option(name="post-idle-wait", description="Additional time to wait in seconds, after temperature has reached to target; defaults to 120s")
    private long mPostIdleWaitSecs = 120L;
    public static final String DEVICE_TEMPERATURE_FILE_PATH_NAME = "device-temperature-file-path";
    @Option(name="device-temperature-file-path", description="Name of file that contains devicetemperature. Example: /sys/class/hwmon/hwmon1/device/msm_therm")
    private String mDeviceTemperatureFilePath = null;
    @Option(name="target-temperature", description="Target Temperature that device should have;defaults to 30c")
    private int mTargetTemperature = 30;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (this.mDeviceTemperatureFilePath == null) {
            return;
        }
        ITestDevice device = testInfo.getDevice();
        long start = System.currentTimeMillis();
        long maxWaitMs = this.mMaxWaitSecs * 1000L;
        long intervalMs = this.mPollIntervalSecs * 1000L;
        int deviceTemperature = Integer.MAX_VALUE;
        while (true) {
            if ((deviceTemperature = this.getDeviceTemperature(device, this.mDeviceTemperatureFilePath)) <= this.mTargetTemperature) {
                LogUtil.CLog.i((String)"Total time elapsed to get to %dc : %ds", (Object[])new Object[]{this.mTargetTemperature, (System.currentTimeMillis() - start) / 1000L});
                break;
            }
            LogUtil.CLog.d((String)"Temperature is still high actual %d/expected %d", (Object[])new Object[]{deviceTemperature, this.mTargetTemperature});
            if (System.currentTimeMillis() - start > maxWaitMs) {
                LogUtil.CLog.w((String)"Temperature is still high, actual %d/expected %d; waiting after %ds", (Object[])new Object[]{deviceTemperature, this.mTargetTemperature, maxWaitMs});
                if (!this.mAbortOnTimeout) break;
                throw new TargetSetupError(String.format("Temperature is still high after wait timeout; actual %d/expected %d", deviceTemperature, this.mTargetTemperature), device.getDeviceDescriptor());
            }
            RunUtil.getDefault().sleep(intervalMs);
        }
        RunUtil.getDefault().sleep(this.mPostIdleWaitSecs * 1000L);
        LogUtil.CLog.d((String)"Done waiting, total time elapsed: %ds", (Object[])new Object[]{(System.currentTimeMillis() - start) / 1000L});
    }

    protected int getDeviceTemperature(ITestDevice device, String fileName) throws DeviceNotAvailableException, TargetSetupError {
        int deviceTemp = Integer.MAX_VALUE;
        String result = device.executeShellCommand(String.format("cat %s", fileName)).trim();
        LogUtil.CLog.i((String)String.format("Temperature file output : %s", result));
        if (result == null || result.contains("No such file or directory")) {
            throw new TargetSetupError(String.format("File %s doesn't exist", fileName), device.getDeviceDescriptor());
        }
        Pattern TEMPERATURE_RAW_FORMAT_REGEX = Pattern.compile("Result:(\\d+)\\sRaw:(\\w+)");
        Pattern TEMPERATURE_FORMAT_REGEX = Pattern.compile("\\d+");
        Matcher matcher = TEMPERATURE_RAW_FORMAT_REGEX.matcher(result);
        if (matcher.find()) {
            deviceTemp = Integer.parseInt(matcher.group(1));
        } else {
            matcher = TEMPERATURE_FORMAT_REGEX.matcher(result);
            if (matcher.find()) {
                deviceTemp = Integer.parseInt(matcher.group());
            } else {
                throw new TargetSetupError(String.format("file content is not as expected. Content : %s", result), device.getDeviceDescriptor());
            }
        }
        return deviceTemp;
    }
}

