/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@OptionClass(alias="tests-zip-file")
public class TestFilePushSetup
extends BaseTargetPreparer {
    @Option(name="test-file-name", description="the relative path of a test zip file/directory to install on device. Can be repeated.", importance=Option.Importance.IF_UNSET)
    private List<File> mTestPaths = new ArrayList<File>();
    @Option(name="throw-if-not-found", description="Throw exception if the specified file is not found.")
    private boolean mThrowIfNoFile = true;
    private Set<String> mFailedToPush = new HashSet<String>();

    protected void addTestFileName(String fileName) {
        this.mTestPaths.add(new File(fileName));
    }

    protected List<String> getTestFileNames() {
        return this.mTestPaths.stream().map(p -> p.getPath()).collect(Collectors.toList());
    }

    protected void clearTestFileName() {
        this.mTestPaths.clear();
    }

    protected File getLocalPathForFilename(IBuildInfo buildInfo, String fileName, ITestDevice device) throws TargetSetupError {
        File testsDir;
        ArrayList<File> dirs = new ArrayList<File>();
        if (buildInfo instanceof IDeviceBuildInfo && (testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir()) != null && testsDir.exists()) {
            dirs.add(FileUtil.getFileForPath((File)testsDir, (String[])new String[]{"DATA"}));
        }
        if (dirs.isEmpty()) {
            throw new TargetSetupError("Provided buildInfo does not contain a valid tests directory.", device.getDeviceDescriptor());
        }
        for (File dir : dirs) {
            File testAppFile = new File(dir, fileName);
            if (!testAppFile.exists()) continue;
            return testAppFile;
        }
        return null;
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new IllegalArgumentException(String.format("Provided buildInfo is not a %s", IDeviceBuildInfo.class.getCanonicalName()));
        }
        if (this.mTestPaths.isEmpty()) {
            LogUtil.CLog.d((String)"No test files to push, skipping");
            return;
        }
        int filePushed = 0;
        for (String fileName : this.getTestFileNames()) {
            File localFile = this.getLocalPathForFilename(buildInfo, fileName, device);
            if (localFile == null) {
                if (this.mThrowIfNoFile) {
                    throw new TargetSetupError(String.format("Could not find test file %s directory in extracted tests.zip", fileName), device.getDeviceDescriptor());
                }
                LogUtil.CLog.w((String)"Could not find test file %s directory in extracted tests.zip, but will continue test setup as throw-if-not-found is set to false", (Object[])new Object[]{fileName});
                this.mFailedToPush.add(fileName);
                continue;
            }
            String remoteFileName = TestFilePushSetup.getDevicePathFromUserData(fileName);
            LogUtil.CLog.d((String)"Pushing file: %s -> %s", (Object[])new Object[]{localFile.getAbsoluteFile(), remoteFileName});
            if (localFile.isDirectory()) {
                device.pushDir(localFile, remoteFileName);
            } else if (localFile.isFile()) {
                device.pushFile(localFile, remoteFileName);
            }
            device.executeShellCommand(String.format("chown system.system %s", remoteFileName));
            ++filePushed;
        }
        if (filePushed == 0 && this.mThrowIfNoFile) {
            throw new TargetSetupError("No file is pushed from tests.zip", device.getDeviceDescriptor());
        }
    }

    protected void setThrowIfNoFile(boolean throwIfNoFile) {
        this.mThrowIfNoFile = throwIfNoFile;
    }

    protected Set<String> getFailedToPushFiles() {
        return this.mFailedToPush;
    }

    static String getDevicePathFromUserData(String path) {
        return ArrayUtil.join((String)"/", (Object[])new Object[]{"", "data", path});
    }
}

