/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep.multi;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.targetprep.multi.BaseMultiTargetPreparer;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

@OptionClass(alias="mix-image-zip")
public class MixImageZipPreparer
extends BaseMultiTargetPreparer {
    @Option(name="device-label", description="the label for the device.")
    private String mDeviceLabel = "device";
    @Option(name="system-label", description="the label for the null-device used to store the system image information.")
    private String mSystemLabel = "system";
    @Option(name="resource-label", description="the label for the null-device used to store the extra build information.")
    private String mResourceLabel = "resource";
    @Option(name="extra-build-test-resource-name", description="the name of the extra build file copied to device build. Can be repeated.")
    private Set<String> mExtraBuildResourceFiles = new TreeSet<String>();
    @Option(name="system-build-file-name", description="the name of the image file copied from system build to device build. Can be repeated.", mandatory=true)
    private Set<String> mSystemFileNames = new TreeSet<String>();
    @Option(name="dummy-file-name", description="the name of the image file to be replaced with a small dummy file. Can be repeated. This option is used when the generic system image is too large for the device's dynamic partition. As GSI doesn't use product partition, the product image can be replaced with a dummy file so as to free up space for GSI.")
    private Set<String> mDummyFileNames = new TreeSet<String>();
    @Option(name="compression-level", description="the compression level of the mixed image zip. It is an integer between 0 and 9. Larger value indicates longer time and smaller output.")
    private int mCompressionLevel = -1;
    @Option(name="misc-info-path", description="the misc info file for repacking super image. By default, this preparer retrieves the file from device build.")
    private File mMiscInfoFile = null;
    @Option(name="ota-tools-path", description="the zip file containing the tools for repacking super image. By default, this preparer retrieves the file from system build.")
    private File mOtaToolsZip = null;
    @Option(name="repack-super-image-path", description="the script that repacks the super image. By default, this preparer retrieves the file from system build. In build environment, the script is located at development/gsi/repack_super_image, and can be built by `make repack_super_image` or `make dist gsi_utils`.")
    private File mRepackSuperImageFile = null;
    private static final String SUPER_IMAGE_NAME = "super.img";
    private static final String OTATOOLS_ZIP_NAME = "otatools.zip";
    private static final String MISC_INFO_FILE_NAME = "misc_info.txt";
    private static final String REPACK_SUPER_IMAGE_FILE_NAME = "repack_super_image";

    public void setUp(TestInformation testInformation) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        IInvocationContext context = testInformation.getContext();
        ITestDevice device = context.getDevice(this.mDeviceLabel);
        IDeviceBuildInfo deviceBuildInfo = (IDeviceBuildInfo)context.getBuildInfo(device);
        ITestDevice systemNullDevice = context.getDevice(this.mSystemLabel);
        IDeviceBuildInfo systemBuildInfo = (IDeviceBuildInfo)context.getBuildInfo(systemNullDevice);
        IBuildInfo resourceBuildInfo = null;
        if (!this.mExtraBuildResourceFiles.isEmpty()) {
            ITestDevice resourceNullDevice = context.getDevice(this.mResourceLabel);
            resourceBuildInfo = context.getBuildInfo(resourceNullDevice);
        }
        ZipFile deviceImageZip = null;
        ZipFile systemImageZip = null;
        File mixedSuperImage = null;
        File mixedImageZip = null;
        try {
            deviceImageZip = new ZipFile(deviceBuildInfo.getDeviceImageFile());
            Map<String, InputStreamFactory> files = MixImageZipPreparer.getInputStreamFactoriesFromImageZip(deviceImageZip, file -> true);
            HashMap<String, InputStreamFactory> filesNotInDeviceBuild = new HashMap<String, InputStreamFactory>();
            systemImageZip = new ZipFile(systemBuildInfo.getDeviceImageFile());
            Map<String, InputStreamFactory> systemFiles = MixImageZipPreparer.getInputStreamFactoriesFromImageZip(systemImageZip, file -> this.mSystemFileNames.contains(file));
            systemFiles = MixImageZipPreparer.replaceExistingEntries(systemFiles, files);
            filesNotInDeviceBuild.putAll(systemFiles);
            Map<String, InputStreamFactory> dummyFiles = MixImageZipPreparer.createDummyInputStreamFactories(this.mDummyFileNames);
            Map<String, InputStreamFactory> dummyFilesNotInDeviceBuild = MixImageZipPreparer.replaceExistingEntries(dummyFiles, files);
            if (!dummyFilesNotInDeviceBuild.isEmpty()) {
                LogUtil.CLog.w((String)"Skip creating dummy images: %s", (Object[])new Object[]{String.join((CharSequence)",", dummyFilesNotInDeviceBuild.keySet())});
            }
            if (resourceBuildInfo != null) {
                Map<String, InputStreamFactory> resourceFiles = MixImageZipPreparer.getBuildFiles(resourceBuildInfo, this.mExtraBuildResourceFiles);
                resourceFiles = MixImageZipPreparer.replaceExistingEntries(resourceFiles, files);
                filesNotInDeviceBuild.putAll(resourceFiles);
            }
            if (files.containsKey(SUPER_IMAGE_NAME) && !filesNotInDeviceBuild.isEmpty()) {
                LogUtil.CLog.i((String)"Mix %s in super image.", (Object[])new Object[]{String.join((CharSequence)", ", filesNotInDeviceBuild.keySet())});
                File miscInfoFile = this.mMiscInfoFile;
                if (miscInfoFile == null) {
                    miscInfoFile = deviceBuildInfo.getFile(MISC_INFO_FILE_NAME);
                }
                if (miscInfoFile == null) {
                    throw new BuildError("Cannot get misc_info.txt from device build.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
                }
                File otaToolsZip = this.mOtaToolsZip;
                if (otaToolsZip == null) {
                    otaToolsZip = systemBuildInfo.getFile(OTATOOLS_ZIP_NAME);
                }
                if (otaToolsZip == null) {
                    throw new BuildError("Cannot get otatools.zip from system build.", systemNullDevice.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
                }
                File repackSuperImageFile = this.mRepackSuperImageFile;
                if (repackSuperImageFile == null) {
                    repackSuperImageFile = systemBuildInfo.getFile(REPACK_SUPER_IMAGE_FILE_NAME);
                }
                if (repackSuperImageFile == null) {
                    throw new BuildError("Cannot get repack_super_image from system build.", systemNullDevice.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
                }
                mixedSuperImage = FileUtil.createTempFile((String)"super", (String)".img");
                this.repackSuperImage(repackSuperImageFile, otaToolsZip, miscInfoFile, files.get(SUPER_IMAGE_NAME), filesNotInDeviceBuild, mixedSuperImage);
                files.put(SUPER_IMAGE_NAME, new FileInputStreamFactory(mixedSuperImage));
                filesNotInDeviceBuild.clear();
            }
            if (!filesNotInDeviceBuild.isEmpty()) {
                throw new TargetSetupError(String.join((CharSequence)",", filesNotInDeviceBuild.keySet()) + " not in device build.", device.getDeviceDescriptor());
            }
            LogUtil.CLog.d((String)"Create mixed image zip.");
            mixedImageZip = MixImageZipPreparer.createZip(files, this.mCompressionLevel);
        }
        catch (IOException e) {
            try {
                throw new TargetSetupError("Could not create mixed image zip", (Throwable)e, device.getDeviceDescriptor());
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(mixedSuperImage);
                ZipUtil.closeZip((ZipFile)deviceImageZip);
                ZipUtil.closeZip(systemImageZip);
                throw throwable;
            }
        }
        FileUtil.deleteFile(mixedSuperImage);
        ZipUtil.closeZip((ZipFile)deviceImageZip);
        ZipUtil.closeZip((ZipFile)systemImageZip);
        IBuildInfo mixedBuildInfo = MixImageZipPreparer.createBuildCopy(deviceBuildInfo, systemBuildInfo.getBuildFlavor(), systemBuildInfo.getBuildId(), mixedImageZip);
        context.addDeviceBuildInfo(this.mDeviceLabel, mixedBuildInfo);
        deviceBuildInfo.cleanUp();
    }

    private static Map<String, InputStreamFactory> getInputStreamFactoriesFromImageZip(final ZipFile zipFile, Predicate<String> predicate) throws IOException {
        HashMap<String, InputStreamFactory> factories = new HashMap<String, InputStreamFactory>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            final ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                LogUtil.CLog.w((String)"Image zip contains subdirectory %s.", (Object[])new Object[]{entry.getName()});
                continue;
            }
            String name = new File(entry.getName()).getName();
            if (!predicate.test(name)) continue;
            if (entry.getSize() < 0L) {
                throw new IllegalArgumentException("Invalid size.");
            }
            if (entry.getCrc() < 0L) {
                throw new IllegalArgumentException("Invalid CRC value.");
            }
            factories.put(name, new InputStreamFactory(){

                @Override
                public InputStream createInputStream() throws IOException {
                    return zipFile.getInputStream(entry);
                }

                @Override
                public long getSize() {
                    return entry.getSize();
                }

                @Override
                public long getCrc32() {
                    return entry.getCrc();
                }
            });
        }
        return factories;
    }

    private static Map<String, InputStreamFactory> createDummyInputStreamFactories(Collection<String> dummyFileNames) {
        final byte[] data = new byte[]{0};
        HashMap<String, InputStreamFactory> factories = new HashMap<String, InputStreamFactory>();
        for (String dummyFileName : dummyFileNames) {
            factories.put(dummyFileName, new InputStreamFactory(){

                @Override
                public InputStream createInputStream() throws IOException {
                    return new ByteArrayInputStream(data);
                }

                @Override
                public long getSize() {
                    return data.length;
                }

                @Override
                public long getCrc32() throws IOException {
                    return StreamUtil.calculateCrc32((InputStream)this.createInputStream());
                }
            });
        }
        return factories;
    }

    private static Map<String, InputStreamFactory> getBuildFiles(IBuildInfo buildInfo, Collection<String> buildFileNames) throws IOException {
        HashMap<String, InputStreamFactory> factories = new HashMap<String, InputStreamFactory>();
        for (String fileName : buildFileNames) {
            File file = buildInfo.getFile(fileName);
            if (file == null) {
                throw new IOException(String.format("Could not get file with name: %s", fileName));
            }
            factories.put(fileName, new FileInputStreamFactory(file));
        }
        return factories;
    }

    private static void initStoredZipEntry(ZipEntry entry, InputStreamFactory factory) throws IOException {
        entry.setMethod(0);
        entry.setCompressedSize(factory.getSize());
        entry.setSize(factory.getSize());
        entry.setCrc(factory.getCrc32());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static File createZip(Map<String, ? extends InputStreamFactory> factories, int compressionLevel) throws IOException {
        File file;
        File zipFile = null;
        OutputStream out = null;
        try {
            zipFile = FileUtil.createTempFile((String)"MixedImg", (String)".zip");
            out = new FileOutputStream(zipFile);
            out = new BufferedOutputStream(out);
            out = new ZipOutputStream(out);
            ZipOutputStream zipOut = (ZipOutputStream)out;
            zipOut.setLevel(compressionLevel);
            for (Map.Entry<String, ? extends InputStreamFactory> factory : factories.entrySet()) {
                ZipEntry entry = new ZipEntry(factory.getKey());
                if (compressionLevel == 0 && factory.getValue().getSize() != 0xFFFFFFFFL) {
                    MixImageZipPreparer.initStoredZipEntry(entry, factory.getValue());
                }
                zipOut.putNextEntry(entry);
                try (BufferedInputStream in = new BufferedInputStream(factory.getValue().createInputStream());){
                    StreamUtil.copyStreams((InputStream)in, (OutputStream)zipOut);
                }
                zipOut.closeEntry();
            }
            File returnValue = zipFile;
            zipFile = null;
            file = returnValue;
        }
        catch (Throwable throwable) {
            StreamUtil.close(out);
            FileUtil.deleteFile((File)zipFile);
            throw throwable;
        }
        StreamUtil.close((Closeable)out);
        FileUtil.deleteFile((File)zipFile);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackSuperImage(File repackSuperImageFile, File otaToolsZip, File miscInfoFile, InputStreamFactory superImage, Map<String, InputStreamFactory> replacement, File outputFile) throws IOException {
        if (!repackSuperImageFile.canExecute() && !repackSuperImageFile.setExecutable(true, false)) {
            LogUtil.CLog.w((String)"Fail to set %s to be executable.", (Object[])new Object[]{repackSuperImageFile});
        }
        try (InputStream imageStream = superImage.createInputStream();){
            FileUtil.writeToFile((InputStream)imageStream, (File)outputFile);
        }
        CommandResult result = null;
        ArrayList<File> tempFiles = new ArrayList<File>();
        File tempDir = null;
        try {
            tempDir = FileUtil.createTempDir((String)"RepackSuperImage");
            ArrayList<String> command = new ArrayList<String>(Arrays.asList(repackSuperImageFile.getAbsolutePath(), "--temp-dir", tempDir.getAbsolutePath(), "--ota-tools", otaToolsZip.getAbsolutePath(), "--misc-info", miscInfoFile.getAbsolutePath(), outputFile.getAbsolutePath()));
            for (Map.Entry<String, InputStreamFactory> entry : replacement.entrySet()) {
                String partitionName = FileUtil.getBaseName((String)entry.getKey());
                File imageFile = FileUtil.createTempFile((String)partitionName, (String)".img");
                tempFiles.add(imageFile);
                try (InputStream imageStream = entry.getValue().createInputStream();){
                    FileUtil.writeToFile((InputStream)imageStream, (File)imageFile);
                }
                command.add(partitionName + "=" + imageFile.getAbsolutePath());
            }
            result = this.createRunUtil().runTimedCmd(240000L, command.toArray(new String[0]));
        }
        finally {
            for (File tempFile : tempFiles) {
                FileUtil.deleteFile((File)tempFile);
            }
            FileUtil.recursiveDelete((File)tempDir);
        }
        LogUtil.CLog.d((String)"Repack super image stdout:\n%s", (Object[])new Object[]{result.getStdout()});
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            throw new IOException("Fail to repack super image. stderr:\n" + result.getStderr());
        }
        LogUtil.CLog.d((String)"Repack super image stderr:\n%s", (Object[])new Object[]{result.getStderr()});
    }

    private static IBuildInfo createBuildCopy(IDeviceBuildInfo deviceBuildInfo, String buildFlavor, String buildId, File imageZip) {
        deviceBuildInfo.setProperties(new IBuildInfo.BuildInfoProperties[]{IBuildInfo.BuildInfoProperties.DO_NOT_COPY_IMAGE_FILE});
        IDeviceBuildInfo newBuildInfo = (IDeviceBuildInfo)deviceBuildInfo.clone();
        newBuildInfo.setBuildFlavor(buildFlavor);
        newBuildInfo.setDeviceImageFile(imageZip, buildId);
        return newBuildInfo;
    }

    private static <T> Map<String, T> replaceExistingEntries(Map<String, T> replacement, Map<String, T> original) {
        HashMap<String, T> remaining = new HashMap<String, T>();
        for (Map.Entry<String, T> entry : replacement.entrySet()) {
            String key = entry.getKey();
            if (original.containsKey(key)) {
                original.put(key, entry.getValue());
                continue;
            }
            remaining.put(key, entry.getValue());
        }
        return remaining;
    }

    @VisibleForTesting
    void addSystemFileName(String fileName) {
        this.mSystemFileNames.add(fileName);
    }

    @VisibleForTesting
    void addResourceFileName(String fileName) {
        this.mExtraBuildResourceFiles.add(fileName);
    }

    @VisibleForTesting
    void addDummyFileName(String fileName) {
        this.mDummyFileNames.add(fileName);
    }

    @VisibleForTesting
    void setCompressionLevel(int compressionLevel) {
        this.mCompressionLevel = compressionLevel;
    }

    @VisibleForTesting
    IRunUtil createRunUtil() {
        return new RunUtil();
    }

    private static class FileInputStreamFactory
    implements InputStreamFactory {
        private File mFile;

        FileInputStreamFactory(File file) {
            this.mFile = file;
        }

        @Override
        public InputStream createInputStream() throws IOException {
            return new FileInputStream(this.mFile);
        }

        @Override
        public long getSize() {
            return this.mFile.length();
        }

        @Override
        public long getCrc32() throws IOException {
            return FileUtil.calculateCrc32((File)this.mFile);
        }
    }

    @VisibleForTesting
    static interface InputStreamFactory {
        public InputStream createInputStream() throws IOException;

        public long getSize();

        public long getCrc32() throws IOException;
    }
}

