/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ExecutionFiles;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ArtRunTest
implements IDeviceTest,
IRemoteTest,
IAbiReceiver {
    private static final String RUNTEST_TAG = "ArtRunTest";
    private static final String DALVIKVM_CMD = "dalvikvm|#BITNESS#| -classpath |#CLASSPATH#| |#MAINCLASS#|";
    @Option(name="test-timeout", description="The max time in ms for an art run-test to run. Test run will be aborted if any test takes longer.", isTimeVal=true)
    private long mMaxTestTimeMs = 60000L;
    @Option(name="run-test-name", description="The name to use when reporting results.")
    private String mRunTestName;
    @Option(name="classpath", description="Holds the paths to search when loading tests.")
    private List<String> mClasspath = new ArrayList<String>();
    private ITestDevice mDevice = null;
    private IAbi mAbi = null;

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set.");
        }
        if (this.mAbi == null) {
            throw new IllegalArgumentException("ABI has not been set.");
        }
        if (this.mRunTestName == null) {
            throw new IllegalArgumentException("Run-test name has not been set.");
        }
        if (this.mClasspath.isEmpty()) {
            throw new IllegalArgumentException("Classpath is empty.");
        }
        this.runArtTest(testInfo, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runArtTest(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        block7: {
            LogUtil.CLog.i((String)"Running ArtRunTest %s on %s", (Object[])new Object[]{this.mRunTestName, this.mDevice.getSerialNumber()});
            String cmd = DALVIKVM_CMD;
            String abi = this.mAbi.getName();
            cmd = cmd.replace("|#BITNESS#|", AbiUtils.getBitness((String)abi));
            cmd = cmd.replace("|#CLASSPATH#|", ArrayUtil.join((String)File.pathSeparator, (Object[])new Object[]{this.mClasspath}));
            cmd = cmd.replace("|#MAINCLASS#|", "Main");
            LogUtil.CLog.d((String)"About to run run-test command: %s", (Object[])new Object[]{cmd});
            String runName = String.format("%s_%s", RUNTEST_TAG, abi);
            int testCount = 1;
            TestDescription testId = new TestDescription(runName, this.mRunTestName);
            listener.testRunStarted(runName, testCount);
            listener.testStarted(testId);
            try {
                CollectingOutputReceiver receiver = this.createTestOutputReceiver();
                this.mDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver, this.mMaxTestTimeMs, TimeUnit.MILLISECONDS, 0);
                String output = receiver.getOutput();
                LogUtil.CLog.v((String)"%s on %s returned %s", (Object[])new Object[]{cmd, this.mDevice.getSerialNumber(), output});
                if (output != null) {
                    try {
                        File expectedFile = this.getDependencyFileFromRunTestDir(testInfo, "expected.txt");
                        LogUtil.CLog.i((String)"Found expected output for run-test %s: %s", (Object[])new Object[]{this.mRunTestName, expectedFile});
                        String expected = FileUtil.readStringFromFile((File)expectedFile);
                        if (!output.equals(expected)) {
                            String error = String.format("'%s' instead of '%s'", output, expected);
                            LogUtil.CLog.i((String)"%s FAILED: %s", (Object[])new Object[]{this.mRunTestName, error});
                            listener.testFailed(testId, error);
                        }
                        break block7;
                    }
                    catch (IOException ioe) {
                        LogUtil.CLog.e((String)"I/O error while accessing expected output file for test %s: %s", (Object[])new Object[]{this.mRunTestName, ioe});
                        listener.testFailed(testId, "I/O error while accessing expected output file.");
                    }
                    break block7;
                }
                listener.testFailed(testId, "No output received to compare to.");
            }
            finally {
                HashMap emptyTestMetrics = new HashMap();
                listener.testEnded(testId, emptyTestMetrics);
                HashMap emptyTestRunMetrics = new HashMap();
                listener.testRunEnded(0L, emptyTestRunMetrics);
            }
        }
    }

    protected CollectingOutputReceiver createTestOutputReceiver() {
        return new CollectingOutputReceiver();
    }

    protected File getDependencyFileFromRunTestDir(TestInformation testInfo, String fileName) throws FileNotFoundException {
        File testsDir = testInfo.executionFiles().get(ExecutionFiles.FilesKey.TARGET_TESTS_DIRECTORY);
        if (testsDir == null || !testsDir.exists()) {
            throw new FileNotFoundException(String.format("Could not find target tests directory for test %s.", this.mRunTestName));
        }
        File runTestDir = new File(testsDir, this.mRunTestName);
        File file = FileUtil.findFile((File)runTestDir, (String)fileName);
        if (file == null) {
            throw new FileNotFoundException(String.format("Could not find an artifact file associated with %s in directory %s.", fileName, runTestDir));
        }
        return file;
    }
}

