/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.NativeCodeCoverageFlusher;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.TarUtil;
import com.android.tradefed.util.ZipUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class ClangCodeCoverageListener
extends ResultForwarder
implements IConfigurationReceiver {
    private static final String NATIVE_COVERAGE_DEVICE_PATH = "/data/misc/trace";
    private static final String COVERAGE_TAR_PATH = String.format("%s/coverage.tar", "/data/misc/trace");
    private static final String ZIP_CLANG_FILES_COMMAND = String.format("find %s -name '*.profraw' | tar -cvf %s -T -", "/data/misc/trace", COVERAGE_TAR_PATH);
    private static final String DELETE_COVERAGE_FILES_COMMAND = String.format("find %s -name '*.profraw' -delete", "/data/misc/trace");
    private final ITestDevice mDevice;
    private IBuildInfo mBuildInfo;
    private IConfiguration mConfiguration;
    private IRunUtil mRunUtil;
    private NativeCodeCoverageFlusher mFlusher;
    private File mLlvmProfdataTool;
    private String mCurrentRunName;

    public ClangCodeCoverageListener(ITestDevice device, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mDevice = device;
        this.mRunUtil = RunUtil.getDefault();
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    @VisibleForTesting
    public void setRunUtil(IRunUtil runUtil) {
        this.mRunUtil = runUtil;
    }

    public void testRunStarted(String runName, int testCount) {
        this.mCurrentRunName = runName;
        super.testRunStarted(runName, testCount);
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        CoverageOptions options = this.mConfiguration.getCoverageOptions();
        try {
            if (options.isCoverageEnabled() && options.getCoverageToolchains().contains(CoverageOptions.Toolchain.CLANG)) {
                Verify.verify(this.mDevice.enableAdbRoot(), "Failed to enable adb root.", new Object[0]);
                if (options.isCoverageFlushEnabled()) {
                    this.getCoverageFlusher().forceCoverageFlush();
                }
                this.logCoverageMeasurement(this.mCurrentRunName);
                this.mDevice.executeShellCommand(DELETE_COVERAGE_FILES_COMMAND);
            }
        }
        catch (DeviceNotAvailableException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            super.testRunEnded(elapsedTime, runMetrics);
        }
    }

    public void invocationEnded(long elapsedTime) {
        FileUtil.recursiveDelete((File)this.mLlvmProfdataTool);
        super.invocationEnded(elapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCoverageMeasurement(String runName) throws DeviceNotAvailableException, IOException {
        Set rawProfileFiles;
        File indexedProfileFile;
        File profileTool;
        File untarDir;
        File coverageTarGz;
        block9: {
            coverageTarGz = null;
            untarDir = null;
            profileTool = null;
            indexedProfileFile = null;
            try {
                this.mDevice.executeShellCommand(ZIP_CLANG_FILES_COMMAND);
                coverageTarGz = this.mDevice.pullFile(COVERAGE_TAR_PATH);
                Verify.verifyNotNull(coverageTarGz, "Failed to pull the Clang code coverage file %s", COVERAGE_TAR_PATH);
                this.mDevice.deleteFile(COVERAGE_TAR_PATH);
                untarDir = FileUtil.createTempDir((String)"clang_coverage");
                TarUtil.unTar((File)coverageTarGz, (File)untarDir);
                rawProfileFiles = FileUtil.findFiles((File)untarDir, (String)".*\\.profraw");
                if (!rawProfileFiles.isEmpty()) break block9;
                LogUtil.CLog.i((String)"No Clang code coverage measurements found.");
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(coverageTarGz);
                FileUtil.recursiveDelete(untarDir);
                FileUtil.deleteFile(indexedProfileFile);
                throw throwable;
            }
            FileUtil.deleteFile((File)coverageTarGz);
            FileUtil.recursiveDelete((File)untarDir);
            FileUtil.deleteFile(indexedProfileFile);
            return;
        }
        LogUtil.CLog.i((String)"Received Clang code coverage measurements: %s", (Object[])new Object[]{rawProfileFiles});
        profileTool = this.getProfileTool();
        Path profileBin = profileTool.toPath().resolve("bin/llvm-profdata");
        profileBin.toFile().setExecutable(true);
        ArrayList<String> command = new ArrayList<String>();
        command.add(profileBin.toString());
        command.add("merge");
        command.add("-sparse");
        command.addAll(rawProfileFiles);
        indexedProfileFile = FileUtil.createTempFile((String)(runName + "_clang_runtime_coverage"), (String)".profdata");
        command.add("-o");
        command.add(indexedProfileFile.getAbsolutePath());
        CommandResult result = this.mRunUtil.runTimedCmd(0L, command.toArray(new String[0]));
        if (result.getStatus() != CommandStatus.SUCCESS) {
            throw new IOException("Failed to merge Clang profile data in " + ((Object)command).toString() + " " + result.toString());
        }
        try (FileInputStreamSource source = new FileInputStreamSource(indexedProfileFile, true);){
            this.testLog(runName + "_clang_runtime_coverage", LogDataType.CLANG_COVERAGE, (InputStreamSource)source);
        }
        FileUtil.deleteFile((File)coverageTarGz);
        FileUtil.recursiveDelete((File)untarDir);
        FileUtil.deleteFile((File)indexedProfileFile);
    }

    private NativeCodeCoverageFlusher getCoverageFlusher() {
        if (this.mFlusher == null) {
            Verify.verifyNotNull(this.mConfiguration);
            Verify.verifyNotNull(this.mDevice);
            this.mFlusher = new NativeCodeCoverageFlusher(this.mDevice, this.mConfiguration.getCoverageOptions().getCoverageProcesses());
        }
        return this.mFlusher;
    }

    private File getProfileTool() throws IOException {
        File file;
        if (this.mLlvmProfdataTool != null) {
            return this.mLlvmProfdataTool;
        }
        File configurationTool = this.mConfiguration.getCoverageOptions().getLlvmProfdataPath();
        if (configurationTool != null) {
            return configurationTool;
        }
        File profileToolZip = null;
        try {
            IBuildInfo buildInfo = this.mConfiguration.getBuildProvider().getBuild();
            profileToolZip = Verify.verifyNotNull(buildInfo.getFile("llvm-profdata.zip"), "Could not get llvm-profdata.zip from the build.", new Object[0]);
            file = this.mLlvmProfdataTool = ZipUtil.extractZipToTemp((File)profileToolZip, (String)"llvm-profdata");
        }
        catch (BuildRetrievalError e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.deleteFile(profileToolZip);
                throw throwable;
            }
        }
        FileUtil.deleteFile((File)profileToolZip);
        return file;
    }
}

