/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.DynamicRemoteFileResolver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.testtype.HostTest;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.ISetOptionReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.testtype.MetricTestCase;
import com.android.tradefed.testtype.junit4.AfterClassWithInfo;
import com.android.tradefed.testtype.junit4.BeforeClassWithInfo;
import com.android.tradefed.testtype.junit4.CarryDnaeError;
import com.android.tradefed.testtype.junit4.RunAftersWithInfo;
import com.android.tradefed.testtype.junit4.RunBeforesWithInfo;
import com.android.tradefed.testtype.junit4.RunNotifierWrapper;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DeviceJUnit4ClassRunner
extends BlockJUnit4ClassRunner
implements IAbiReceiver,
ISetOptionReceiver,
ITestInformationReceiver {
    private IAbi mAbi;
    private TestInformation mTestInformation;
    private List<File> mDownloadedFiles = new ArrayList<File>();
    @Option(name="set-option", description="Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map; escaping of \"=\" is currently not supported.A particular class can be targetted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"")
    private List<String> mKeyValueOptions = new ArrayList<String>();

    public DeviceJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Object createTest() throws Exception {
        Object testObj = super.createTest();
        if (testObj instanceof IDeviceTest) {
            ((IDeviceTest)testObj).setDevice(this.mTestInformation.getDevice());
        }
        if (testObj instanceof IBuildReceiver) {
            ((IBuildReceiver)testObj).setBuild(this.mTestInformation.getBuildInfo());
        }
        if (testObj instanceof IAbiReceiver) {
            ((IAbiReceiver)testObj).setAbi(this.mAbi);
        }
        if (testObj instanceof IInvocationContextReceiver) {
            ((IInvocationContextReceiver)testObj).setInvocationContext(this.mTestInformation.getContext());
        }
        if (testObj instanceof ITestInformationReceiver) {
            ((ITestInformationReceiver)testObj).setTestInformation(this.mTestInformation);
        }
        HostTest.setOptionToLoadedObject(testObj, this.mKeyValueOptions);
        this.mDownloadedFiles.addAll(this.resolveRemoteFileForObject(testObj));
        return testObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        RunNotifierWrapper wrapper = new RunNotifierWrapper(notifier);
        try {
            super.runChild(method, (RunNotifier)wrapper);
        }
        finally {
            for (File f : this.mDownloadedFiles) {
                FileUtil.recursiveDelete((File)f);
            }
        }
        if (wrapper.getDeviceNotAvailableException() != null) {
            throw new CarryDnaeError(wrapper.getDeviceNotAvailableException());
        }
    }

    protected Statement withBeforeClasses(Statement statement) {
        Statement s = super.withBeforeClasses(statement);
        List beforesWithDevice = this.getTestClass().getAnnotatedMethods(BeforeClassWithInfo.class);
        return beforesWithDevice.isEmpty() ? s : new RunBeforesWithInfo(statement, beforesWithDevice, this.mTestInformation);
    }

    protected Statement withAfterClasses(Statement statement) {
        Statement s = super.withAfterClasses(statement);
        List aftersWithDevice = this.getTestClass().getAnnotatedMethods(AfterClassWithInfo.class);
        return aftersWithDevice.isEmpty() ? s : new RunAftersWithInfo(statement, aftersWithDevice, this.mTestInformation);
    }

    public void run(RunNotifier notifier) {
        RunNotifierWrapper wrapper = new RunNotifierWrapper(notifier);
        super.run((RunNotifier)wrapper);
        if (wrapper.getDeviceNotAvailableException() != null) {
            throw new CarryDnaeError(wrapper.getDeviceNotAvailableException());
        }
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setTestInformation(TestInformation testInformation) {
        this.mTestInformation = testInformation;
    }

    public TestInformation getTestInformation() {
        return this.mTestInformation;
    }

    @VisibleForTesting
    DynamicRemoteFileResolver createResolver() {
        DynamicRemoteFileResolver resolver = new DynamicRemoteFileResolver();
        if (this.mTestInformation != null) {
            resolver.setDevice(this.mTestInformation.getDevice());
        }
        return resolver;
    }

    private Set<File> resolveRemoteFileForObject(Object obj) {
        try {
            OptionSetter setter = new OptionSetter(new Object[]{obj});
            return setter.validateRemoteFilePath(this.createResolver());
        }
        catch (BuildRetrievalError | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static class LogAnnotation
    implements Annotation {
        public List<MetricTestCase.LogHolder> mLogs = new ArrayList<MetricTestCase.LogHolder>();

        public LogAnnotation(List<MetricTestCase.LogHolder> logs) {
            this.mLogs.addAll(logs);
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }
    }

    public static class TestLogData
    extends ExternalResource {
        private Description mDescription;
        private List<MetricTestCase.LogHolder> mLogs = new ArrayList<MetricTestCase.LogHolder>();

        public Statement apply(Statement base, Description description) {
            this.mDescription = description;
            return super.apply(base, description);
        }

        public final void addTestLog(String dataName, LogDataType dataType, InputStreamSource dataStream) {
            this.mLogs.add(new MetricTestCase.LogHolder(dataName, dataType, dataStream));
        }

        protected void after() {
            this.mDescription.addChild(Description.createTestDescription((String)"LOGS", (String)"LOGS", (Annotation[])new Annotation[]{new LogAnnotation(this.mLogs)}));
        }
    }

    public static class MetricAnnotation
    implements Annotation {
        public HashMap<String, MetricMeasurement.Metric> mMetrics = new HashMap();

        public MetricAnnotation(HashMap<String, MetricMeasurement.Metric> metrics) {
            this.mMetrics.putAll(metrics);
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return null;
        }
    }

    public static class TestMetrics
    extends ExternalResource {
        Description mDescription;
        private Map<String, String> mMetrics = new HashMap<String, String>();
        private HashMap<String, MetricMeasurement.Metric> mProtoMetrics = new HashMap();

        public Statement apply(Statement base, Description description) {
            this.mDescription = description;
            return super.apply(base, description);
        }

        public void addTestMetric(String key, String value) {
            this.mMetrics.put(key, value);
        }

        public void addTestMetric(String key, MetricMeasurement.Metric metric) {
            this.mProtoMetrics.put(key, metric);
        }

        protected void before() throws Throwable {
            this.mMetrics = new HashMap<String, String>();
            this.mProtoMetrics = new HashMap();
        }

        protected void after() {
            this.mProtoMetrics.putAll(TfMetricProtoUtil.upgradeConvert(this.mMetrics));
            this.mDescription.addChild(Description.createTestDescription((String)"METRICS", (String)"METRICS", (Annotation[])new Annotation[]{new MetricAnnotation(this.mProtoMetrics)}));
        }
    }
}

