/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleBenchmarkResultParser {
    private String mTestClassName;
    private final ITestInvocationListener mTestListener;

    public GoogleBenchmarkResultParser(String testClassName, ITestInvocationListener listener) {
        this.mTestClassName = testClassName;
        this.mTestListener = listener;
    }

    public Map<String, String> parse(CollectingOutputReceiver output) {
        String outputLogs = output.getOutput();
        Map<Object, Object> results = new HashMap();
        JSONObject res = null;
        outputLogs = this.sanitizeOutput(outputLogs);
        try {
            res = new JSONObject(outputLogs);
            JSONObject context = res.getJSONObject("context");
            results = this.parseJsonToMap(context);
        }
        catch (JSONException e) {
            LogUtil.CLog.e((String)"Failed to Parse context:");
            LogUtil.CLog.e((Throwable)e);
            LogUtil.CLog.d((String)"output was:\n%s\n", (Object[])new Object[]{outputLogs});
            this.mTestListener.testRunFailed(String.format("Failed to Parse context: %s", new Object[]{e}));
            return results;
        }
        try {
            JSONArray benchmarks = res.getJSONArray("benchmarks");
            for (int i = 0; i < benchmarks.length(); ++i) {
                boolean errorOccurred;
                Map<Object, Object> testResults = new HashMap();
                JSONObject testRes = (JSONObject)benchmarks.get(i);
                String name = testRes.getString("name");
                TestDescription testId = new TestDescription(this.mTestClassName, name);
                this.mTestListener.testStarted(testId);
                try {
                    testResults = this.parseJsonToMap(testRes);
                }
                catch (JSONException e) {
                    LogUtil.CLog.e((Throwable)e);
                    this.mTestListener.testFailed(testId, String.format("Test failed to generate proper results: %s", e.getMessage()));
                }
                String iterations = (String)testResults.get("iterations");
                if (iterations != null && "0".equals(iterations.trim())) {
                    this.mTestListener.testIgnored(testId);
                }
                if (testRes.has("error_occurred") && (errorOccurred = testRes.getBoolean("error_occurred"))) {
                    String errorMessage = (String)testResults.get("error_message");
                    if (Strings.isNullOrEmpty(errorMessage)) {
                        this.mTestListener.testFailed(testId, "Benchmark reported an unspecified error");
                    } else {
                        this.mTestListener.testFailed(testId, String.format("Benchmark reported an error: %s", errorMessage));
                    }
                }
                this.mTestListener.testEnded(testId, TfMetricProtoUtil.upgradeConvert(testResults));
            }
            results.put("Pass", Integer.toString(benchmarks.length()));
        }
        catch (JSONException e) {
            LogUtil.CLog.e((Throwable)e);
            results.put("ERROR", e.getMessage());
            this.mTestListener.testRunFailed(String.format("Failed to parse benchmarks results: %s", new Object[]{e}));
        }
        return results;
    }

    protected Map<String, String> parseJsonToMap(JSONObject j) throws JSONException {
        HashMap<String, String> testResults = new HashMap<String, String>();
        Iterator i = j.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            testResults.put(key, j.get(key).toString());
        }
        return testResults;
    }

    private String sanitizeOutput(String output) {
        if (output.startsWith("{")) {
            return output;
        }
        int indexStart = output.indexOf(123);
        if (indexStart == -1) {
            LogUtil.CLog.w((String)"Output does not look like a proper JSON.");
            return output;
        }
        String newOuput = output.substring(indexStart);
        LogUtil.CLog.d((String)"We removed the following from the output: '%s'", (Object[])new Object[]{output.subSequence(0, indexStart)});
        return newOuput;
    }
}

