/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.BuildInfoKey;
import com.android.tradefed.build.DeviceBuildInfo;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.GTestBase;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RunUtil;
import com.android.tradefed.util.ShellOutputReceiverStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

@OptionClass(alias="hostgtest")
public class HostGTest
extends GTestBase
implements IAbiReceiver,
IBuildReceiver {
    private static final long DEFAULT_HOST_COMMAND_TIMEOUT_MS = 120000L;
    private IBuildInfo mBuildInfo = null;
    private IAbi mAbi = null;

    @Override
    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    @Override
    public IAbi getAbi() {
        return this.mAbi;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildInfo = buildInfo;
    }

    public CommandResult executeHostCommand(String cmd) {
        return this.executeHostCommand(cmd, 120000L);
    }

    public CommandResult executeHostCommand(String cmd, long timeoutMs) {
        String[] cmds = cmd.split("\\s+");
        return RunUtil.getDefault().runTimedCmd(timeoutMs, cmds);
    }

    public CommandResult executeHostGTestCommand(String cmd, long timeoutMs, IShellOutputReceiver receiver) {
        CommandResult result;
        RunUtil runUtil = new RunUtil();
        String[] cmds = cmd.split("\\s+");
        if (this.getShardCount() > 0) {
            if (this.isCollectTestsOnly()) {
                LogUtil.CLog.w((String)"--collect-tests-only option ignores sharding parameters, and will cause each shard to collect all tests.");
            }
            runUtil.setEnvVariable("GTEST_SHARD_INDEX", Integer.toString(this.getShardIndex()));
            runUtil.setEnvVariable("GTEST_TOTAL_SHARDS", Integer.toString(this.getShardCount()));
        }
        runUtil.setRedirectStderrToStdout(true);
        try (ShellOutputReceiverStream stream = new ShellOutputReceiverStream(receiver);){
            result = runUtil.runTimedCmd(timeoutMs, (OutputStream)stream, null, cmds);
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen, ShellOutputReceiverStream.close is a no-op");
        }
        return result;
    }

    @Override
    public String loadFilter(String binaryOnHost) {
        try {
            LogUtil.CLog.i((String)"Loading filter from file for key: '%s'", (Object[])new Object[]{this.getTestFilterKey()});
            String filterFileName = String.format("%s%s", binaryOnHost, ".filter");
            File filterFile = new File(filterFileName);
            if (filterFile.exists()) {
                CommandResult cmdResult = this.executeHostCommand(String.format("cat %s", filterFileName));
                String content = cmdResult.getStdout();
                if (content != null && !content.isEmpty()) {
                    JSONObject filter = new JSONObject(content);
                    String key = this.getTestFilterKey();
                    JSONObject filterObject = filter.getJSONObject(key);
                    return filterObject.getString("filter");
                }
                LogUtil.CLog.e((String)"Error with content of the filter file %s: %s", (Object[])new Object[]{filterFile, content});
            } else {
                LogUtil.CLog.e((String)"Filter file %s not found", (Object[])new Object[]{filterFile});
            }
        }
        catch (JSONException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runTest(IShellOutputReceiver resultParser, String fullPath, String flags) {
        CommandResult result;
        String cmd2;
        try {
            for (String cmd2 : this.getBeforeTestCmd()) {
                result = this.executeHostCommand(cmd2);
                if (result.getStatus().equals((Object)CommandStatus.SUCCESS)) continue;
                throw new RuntimeException("'Before test' command failed: " + result.getStderr());
            }
            long maxTestTimeMs = this.getMaxTestTimeMs();
            String cmd3 = this.getGTestCmdLine(fullPath, flags);
            CommandResult testResult = this.executeHostGTestCommand(cmd3, maxTestTimeMs, resultParser);
            switch (testResult.getStatus()) {
                case FAILED: {
                    Integer exitCode = testResult.getExitCode();
                    if (exitCode == null || exitCode != 1) {
                        throw new RuntimeException(String.format("Command run failed with exit code %s", exitCode));
                    }
                    break;
                }
                case TIMED_OUT: {
                    throw new RuntimeException(String.format("Command run timed out after %d ms", maxTestTimeMs));
                }
                case EXCEPTION: {
                    throw new RuntimeException("Command run failed with exception");
                }
            }
        }
        finally {
            resultParser.flush();
        }
        Iterator<String> iterator = this.getAfterTestCmd().iterator();
        do {
            if (iterator.hasNext()) continue;
            return;
        } while ((result = this.executeHostCommand(cmd2 = iterator.next())).getStatus().equals((Object)CommandStatus.SUCCESS));
        throw new RuntimeException("'After test' command failed: " + result.getStderr());
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        File testsDir;
        ArrayList<File> scanDirs = new ArrayList<File>();
        File hostLinkedDir = this.mBuildInfo.getFile(BuildInfoKey.BuildInfoFileKey.HOST_LINKED_DIR);
        if (hostLinkedDir != null) {
            scanDirs.add(hostLinkedDir);
        }
        if ((testsDir = ((DeviceBuildInfo)this.mBuildInfo).getTestsDir()) != null) {
            scanDirs.add(testsDir);
        }
        String moduleName = this.getTestModule();
        File gTestFile = null;
        try {
            gTestFile = FileUtil.findFile((String)moduleName, (IAbi)this.mAbi, (File[])scanDirs.toArray(new File[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (gTestFile == null || gTestFile.isDirectory()) {
            try {
                File byBaseName = FileUtil.findFile((String)(moduleName + ".*"), (IAbi)this.mAbi, (File[])scanDirs.toArray(new File[0]));
                if (byBaseName != null && byBaseName.isFile()) {
                    gTestFile = byBaseName;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (gTestFile == null) {
            throw new RuntimeException(String.format("Fail to find native test %s in directory %s.", moduleName, scanDirs));
        }
        if (!gTestFile.canExecute()) {
            throw new RuntimeException(String.format("%s is not executable!", gTestFile.getAbsolutePath()));
        }
        listener = this.getGTestListener(listener);
        IShellOutputReceiver resultParser = this.createResultParser(gTestFile.getName(), listener);
        String flags = this.getAllGTestFlags(gTestFile.getName());
        LogUtil.CLog.i((String)"Running gtest %s %s", (Object[])new Object[]{gTestFile.getName(), flags});
        String filePath = gTestFile.getAbsolutePath();
        this.runTest(resultParser, filePath, flags);
    }
}

