/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FilteredResultForwarder;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;

class InstrumentationFileTest
implements IRemoteTest {
    private static final String ON_DEVICE_TEST_DIR_LOCATION = "/data/local/tmp/";
    private static final String PACKAGE_ARG_KEY = "package";
    private InstrumentationTest mInstrumentationTest = this.createInstrumentationTest();
    private final Collection<TestDescription> mTests;
    private String mFilePathOnDevice = null;
    private int mAttemps;
    private int mMaxAttemps;
    private boolean mRetrySerially;

    InstrumentationFileTest(InstrumentationTest instrumentationTest, Collection<TestDescription> testsToRun, boolean retrySerially, int maxAttempts) throws ConfigurationException {
        OptionCopier.copyOptions((Object)instrumentationTest, (Object)this.mInstrumentationTest);
        this.mInstrumentationTest.setConfiguration(instrumentationTest.getConfiguration());
        this.mInstrumentationTest.setDevice(instrumentationTest.getDevice());
        this.mInstrumentationTest.setForceAbi(instrumentationTest.getForceAbi());
        this.mInstrumentationTest.setReRunUsingTestFile(true);
        this.mInstrumentationTest.setRerunMode(false);
        this.mInstrumentationTest.setIsRerun(true);
        this.mTests = testsToRun;
        this.mAttemps = 0;
        this.mRetrySerially = retrySerially;
        this.mMaxAttemps = maxAttempts;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mInstrumentationTest.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.writeTestsToFileAndRun(this.mTests, testInfo, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTestsToFileAndRun(Collection<TestDescription> tests, TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        ++this.mAttemps;
        if (this.mMaxAttemps > 0 && this.mAttemps <= this.mMaxAttemps) {
            LogUtil.CLog.d((String)"Try to run tests from file for the %d/%d attempts", (Object[])new Object[]{this.mAttemps, this.mMaxAttemps});
        } else if (this.mMaxAttemps > 0) {
            if (this.mRetrySerially) {
                LogUtil.CLog.d((String)"Running tests from file exceeded max attempts. Try to run tests serially.");
                this.reRunTestsSerially(this.mInstrumentationTest, testInfo, listener);
            } else {
                LogUtil.CLog.d((String)"Running tests from file exceeded max attempts. Ignore the rest tests");
                return;
            }
        }
        File testFile = null;
        try {
            testFile = FileUtil.createTempFile((String)("tf_testFile_" + InstrumentationFileTest.class.getCanonicalName()), (String)".txt");
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(testFile));){
                Collection<TestDescription> uniqueMethods = this.createRerunSet(tests);
                for (TestDescription testToRun : uniqueMethods) {
                    bw.write(String.format("%s#%s", testToRun.getClassName(), testToRun.getTestNameWithoutParams()));
                    bw.newLine();
                }
                LogUtil.CLog.d((String)"Test file %s was successfully created", (Object[])new Object[]{testFile.getAbsolutePath()});
            }
            this.mFilePathOnDevice = ON_DEVICE_TEST_DIR_LOCATION + testFile.getName();
            if (this.pushFileToTestDevice(testFile, this.mFilePathOnDevice)) {
                this.mInstrumentationTest.setTestPackageName(null);
                this.mInstrumentationTest.removeFromInstrumentationArg(PACKAGE_ARG_KEY);
                this.mInstrumentationTest.setTestFilePathOnDevice(this.mFilePathOnDevice);
                LogUtil.CLog.d((String)"Test file %s was successfully pushed to %s on device", (Object[])new Object[]{testFile.getAbsolutePath(), this.mFilePathOnDevice});
                this.runTests(this.mInstrumentationTest, testInfo, listener);
            } else if (this.mRetrySerially) {
                LogUtil.CLog.e((String)"Failed to push file to device, re-running tests serially");
                this.reRunTestsSerially(this.mInstrumentationTest, testInfo, listener);
            } else {
                LogUtil.CLog.e((String)"Failed to push file to device, ignore the rest of tests");
            }
            FileUtil.deleteFile((File)testFile);
        }
        catch (IOException e) {
            if (this.mRetrySerially) {
                LogUtil.CLog.e((String)"Failed to run tests from file, re-running tests serially: %s", (Object[])new Object[]{e.getMessage()});
                this.reRunTestsSerially(this.mInstrumentationTest, testInfo, listener);
            } else {
                LogUtil.CLog.e((String)"Failed to push file to device, ignore the rest of tests");
            }
        }
        finally {
            FileUtil.deleteFile(testFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(InstrumentationTest runner, TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        CollectingTestListener testTracker = new CollectingTestListener();
        try {
            runner.run(testInfo, (ITestInvocationListener)new FilteredResultForwarder(this.mTests, new ITestInvocationListener[]{listener, testTracker}));
        }
        finally {
            this.deleteTestFileFromDevice(this.mFilePathOnDevice);
            Set<TestDescription> completedTests = InstrumentationTest.excludeNonExecuted(testTracker.getCurrentRunResults());
            if (this.mTests.removeAll(completedTests) && !this.mTests.isEmpty()) {
                this.writeTestsToFileAndRun(this.mTests, testInfo, listener);
            } else if (!this.mTests.isEmpty()) {
                if (this.mRetrySerially) {
                    LogUtil.CLog.e((String)"all remaining tests failed to run from file, re-running tests serially");
                    this.reRunTestsSerially(runner, testInfo, listener);
                } else {
                    LogUtil.CLog.e((String)"all remaining tests failed to run from file, will be ignored");
                }
            }
        }
    }

    private void reRunTestsSerially(InstrumentationTest runner, TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        runner.setTestFilePathOnDevice(null);
        runner.setReRunUsingTestFile(false);
        runner.setTestsToRun(this.mTests);
        runner.run(testInfo, listener);
    }

    private Collection<TestDescription> createRerunSet(Collection<TestDescription> tests) {
        LinkedHashMap<String, TestDescription> uniqueMethods = new LinkedHashMap<String, TestDescription>();
        for (TestDescription test : tests) {
            uniqueMethods.put(test.getTestNameWithoutParams(), test);
        }
        return uniqueMethods.values();
    }

    boolean pushFileToTestDevice(File file, String destinationPath) throws DeviceNotAvailableException {
        return this.mInstrumentationTest.getDevice().pushFile(file, destinationPath);
    }

    void deleteTestFileFromDevice(String pathToFile) throws DeviceNotAvailableException {
        if (this.mInstrumentationTest.getDevice().doesFileExist(pathToFile)) {
            this.mInstrumentationTest.getDevice().executeShellCommand(String.format("rm %s", pathToFile));
            LogUtil.CLog.d((String)"Removed test file from device: %s", (Object[])new Object[]{pathToFile});
        }
    }

    @VisibleForTesting
    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }
}

