/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.FilteredResultForwarder;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.RetryResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

class InstrumentationSerialTest
implements IRemoteTest {
    static final int FAILED_RUN_TEST_ATTEMPTS = 2;
    private final Collection<TestDescription> mTests;
    private final InstrumentationTest mInstrumentationTest;

    InstrumentationSerialTest(InstrumentationTest instrumentationTest, Collection<TestDescription> testsToRun) throws ConfigurationException {
        this.mInstrumentationTest = this.createInstrumentationTest(instrumentationTest);
        this.mTests = testsToRun;
    }

    InstrumentationTest createInstrumentationTest(InstrumentationTest instrumentationTest) throws ConfigurationException {
        InstrumentationTest runner = new InstrumentationTest();
        OptionCopier.copyOptions((Object)instrumentationTest, (Object)runner);
        runner.setConfiguration(instrumentationTest.getConfiguration());
        runner.setDevice(instrumentationTest.getDevice());
        runner.setForceAbi(instrumentationTest.getForceAbi());
        runner.setReRunUsingTestFile(false);
        runner.setRerunMode(false);
        runner.setIsRerun(true);
        return runner;
    }

    public void run(TestInformation testInfo, ITestInvocationListener listener) throws DeviceNotAvailableException {
        if (this.mInstrumentationTest.getDevice() == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        try {
            for (TestDescription testToRun : this.mTests) {
                InstrumentationTest runner = this.createInstrumentationTest(this.mInstrumentationTest);
                runner.setClassName(testToRun.getClassName());
                runner.setMethodName(testToRun.getTestNameWithoutParams());
                runner.setTestPackageName(null);
                this.runTest(runner, testInfo, listener, testToRun);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.CLog.e((String)"Failed to create new InstrumentationTest: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    private void runTest(InstrumentationTest runner, TestInformation testInfo, ITestInvocationListener listener, TestDescription testToRun) throws DeviceNotAvailableException {
        CollectingTestListener trackingListener = new CollectingTestListener(){

            public void testRunStarted(String name, int numTests, int attemptNumber) {
                super.testRunStarted(name, 0, 0);
            }
        };
        for (int i = 1; i <= 2; ++i) {
            runner.run(testInfo, (ITestInvocationListener)new RetryResultForwarder(i, new ITestInvocationListener[]{trackingListener, new FilteredResultForwarder(Arrays.asList(testToRun), new ITestInvocationListener[]{listener})}){

                public void testRunStarted(String runName, int testCount) {
                    super.testRunStarted(runName, 0);
                }

                public void testRunStarted(String runName, int testCount, int attemptNumber) {
                    super.testRunStarted(runName, 0, attemptNumber);
                }
            });
            if (trackingListener.getCurrentRunResults().getTestResults().containsKey(testToRun)) {
                return;
            }
            LogUtil.CLog.w((String)"Expected test %s did not run on attempt %d of %d", (Object[])new Object[]{testToRun, i, 2});
        }
        this.markTestAsFailed(testToRun, trackingListener.getCurrentRunResults(), listener);
    }

    private void markTestAsFailed(TestDescription test, TestRunResult testRun, ITestInvocationListener listener) {
        listener.testRunStarted(testRun.getName(), 0);
        listener.testStarted(test);
        String message = testRun.isRunFailure() ? testRun.getRunFailureMessage() : "The test was not initialized by the test runner.";
        listener.testFailed(test, String.format("Test failed to run. Test run failed due to : %s", message));
        listener.testEnded(test, new HashMap());
        listener.testRunEnded(0L, new HashMap());
    }
}

