/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.testtype.coverage.CoverageOptions;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.JavaCodeCoverageFlusher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jacoco.core.tools.ExecFileLoader;

final class JavaCodeCoverageListener
extends ResultForwarder {
    public static final String MERGE_COVERAGE_MEASUREMENTS_TEST_NAME = "mergeCoverageMeasurements";
    public static final String COVERAGE_MEASUREMENT_KEY = "coverageFilePath";
    public static final String COVERAGE_DIRECTORY = "/data/misc/trace";
    public static final String FIND_COVERAGE_FILES = String.format("find %s -name '*.ec'", "/data/misc/trace");
    private final ITestDevice mDevice;
    private final CoverageOptions mCoverageOptions;
    private final boolean mMergeCoverageMeasurements;
    private final ExecFileLoader mExecFileLoader = new ExecFileLoader();
    private JavaCodeCoverageFlusher mFlusher;
    private String mCurrentRunName;

    public JavaCodeCoverageListener(ITestDevice device, CoverageOptions options, boolean mergeMeasurements, ITestInvocationListener ... listeners) {
        super(listeners);
        this.mDevice = device;
        this.mCoverageOptions = options;
        this.mMergeCoverageMeasurements = mergeMeasurements;
        this.mFlusher = new JavaCodeCoverageFlusher(device, options.getCoverageProcesses());
    }

    @VisibleForTesting
    public void setCoverageFlusher(JavaCodeCoverageFlusher flusher) {
        this.mFlusher = flusher;
    }

    public void testRunStarted(String runName, int testCount) {
        super.testRunStarted(runName, testCount);
        this.mCurrentRunName = runName;
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> runMetrics) {
        if (MERGE_COVERAGE_MEASUREMENTS_TEST_NAME.equals(this.mCurrentRunName)) {
            try {
                File mergedMeasurements = FileUtil.createTempFile((String)"merged_runtime_coverage_", (String)("." + LogDataType.COVERAGE.getFileExt()));
                this.mExecFileLoader.save(mergedMeasurements, false);
                this.logCoverageMeasurement("merged_runtime_coverage", mergedMeasurements);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                super.testRunEnded(elapsedTime, runMetrics);
            }
        }
        MetricMeasurement.Metric devicePathMetric = runMetrics.get(COVERAGE_MEASUREMENT_KEY);
        if (devicePathMetric == null) {
            super.testRunFailed("No Java code coverage measurement.");
            super.testRunEnded(elapsedTime, runMetrics);
            return;
        }
        String testCoveragePath = devicePathMetric.getMeasurements().getSingleString();
        if (testCoveragePath == null) {
            super.testRunFailed("No Java code coverage measurement.");
            super.testRunEnded(elapsedTime, runMetrics);
            return;
        }
        ImmutableList.Builder devicePaths = ImmutableList.builder();
        devicePaths.add(testCoveragePath);
        try {
            if (this.mCoverageOptions.isCoverageFlushEnabled()) {
                this.mFlusher.forceCoverageFlush();
            }
            String fileList = this.mDevice.executeShellCommand(FIND_COVERAGE_FILES);
            devicePaths.addAll(Splitter.on('\n').omitEmptyStrings().split(fileList));
            this.collectAndLogCoverageMeasurementsAsRoot((List<String>)((Object)devicePaths.build()));
        }
        catch (DeviceNotAvailableException | IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            super.testRunEnded(elapsedTime, runMetrics);
        }
    }

    private void logCoverageMeasurement(String name, File coverageFile) {
        try (FileInputStreamSource source = new FileInputStreamSource(coverageFile, true);){
            this.testLog(name, LogDataType.COVERAGE, (InputStreamSource)source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAndLogCoverageMeasurementsAsRoot(List<String> devicePaths) throws IOException, DeviceNotAvailableException {
        boolean wasRoot = this.mDevice.isAdbRoot();
        if (!wasRoot && !this.mDevice.enableAdbRoot()) {
            throw new RuntimeException("Failed to enable root before pulling Java code coverage files off device");
        }
        try {
            this.collectAndLogCoverageMeasurements(devicePaths);
        }
        finally {
            for (String devicePath : devicePaths) {
                this.mDevice.deleteFile(devicePath);
            }
            if (!wasRoot && !this.mDevice.disableAdbRoot()) {
                throw new RuntimeException("Failed to disable root after pulling Java code coverage files off device");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectAndLogCoverageMeasurements(List<String> devicePaths) throws IOException, DeviceNotAvailableException {
        for (String devicePath : devicePaths) {
            File coverageFile = this.mDevice.pullFile(devicePath);
            Verify.verifyNotNull(coverageFile, "Failed to pull the Java code coverage file from %s", devicePath);
            try {
                if (this.mMergeCoverageMeasurements) {
                    this.mExecFileLoader.load(coverageFile);
                    continue;
                }
                this.logCoverageMeasurement(this.mCurrentRunName + "_" + Files.getNameWithoutExtension(devicePath) + "_runtime_coverage", coverageFile);
            }
            finally {
                FileUtil.deleteFile((File)coverageFile);
            }
        }
    }
}

