/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.MultiLineReceiver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PythonUnitTestResultParser
extends MultiLineReceiver {
    private ParserState mCurrentParseState;
    private String mCurrentTestName;
    private String mCurrentTestClass;
    private String mCurrentTestStatus;
    private Matcher mCurrentMatcher;
    private StringBuilder mCurrentTraceback;
    private long mTotalElapsedTime;
    private int mTotalTestCount;
    private String mCurrentTestCaseString = null;
    private Set<String> mIncludeFilters = new LinkedHashSet<String>();
    private Set<String> mExcludeFilters = new LinkedHashSet<String>();
    private Collection<ITestInvocationListener> mListeners = new ArrayList<ITestInvocationListener>();
    private final String mRunName;
    private Map<TestDescription, String> mTestResultCache;
    static final String SKIPPED_ENTRY = "Skipped";
    static final String EQUAL_LINE = "======================================================================";
    static final String DASH_LINE = "----------------------------------------------------------------------";
    static final String TRACEBACK_LINE = "Traceback (most recent call last):";
    static final Pattern PATTERN_TEST_SUCCESS = Pattern.compile("ok|expected failure");
    static final Pattern PATTERN_TEST_FAILURE = Pattern.compile("FAIL|ERROR");
    static final Pattern PATTERN_TEST_SKIPPED = Pattern.compile("skipped '.*");
    static final Pattern PATTERN_TEST_UNEXPECTED_SUCCESS = Pattern.compile("unexpected success");
    static final Pattern PATTERN_ONE_LINE_RESULT = Pattern.compile("(\\S*) \\((\\S*)\\) \\.\\.\\. (ok|expected failure|FAIL|ERROR|skipped '.*'|unexpected success)?");
    static final Pattern PATTERN_TWO_LINE_RESULT_FIRST = Pattern.compile("(\\S*) \\((\\S*)\\)");
    static final Pattern PATTERN_TWO_LINE_RESULT_SECOND = Pattern.compile("(.*) \\.\\.\\. (ok|expected failure|FAIL|ERROR|skipped '.*'|unexpected success)");
    static final Pattern PATTERN_TWO_LINE_RESULT_SECOND_ERROR = Pattern.compile("(.*) \\.\\.\\. error: (.*)(ok|expected failure|FAIL|ERROR|skipped '.*'|unexpected success)", 32);
    static final Pattern PATTERN_FAIL_MESSAGE = Pattern.compile("(FAIL|ERROR): (\\S*) \\((\\S*)\\)( \\(.*\\))?");
    static final Pattern PATTERN_RUN_SUMMARY = Pattern.compile("Ran (\\d+) tests? in (\\d+(.\\d*)?)s");
    static final Pattern MULTILINE_RESULT_WITH_WARNING = Pattern.compile("(.*) \\.\\.\\. (.*)", 32);
    static final Pattern MULTILINE_FINAL_RESULT_WITH_WARNING = Pattern.compile("(.*) \\.\\.\\. (.*)ok(.*)", 32);
    static final Pattern PATTERN_RUN_RESULT = Pattern.compile("(OK|FAILED).*");

    public PythonUnitTestResultParser(ITestInvocationListener listener, String runName) {
        this(Arrays.asList(listener), runName);
    }

    public PythonUnitTestResultParser(Collection<ITestInvocationListener> listeners, String runName) {
        this(listeners, runName, new LinkedHashSet<String>(), new LinkedHashSet<String>());
    }

    public PythonUnitTestResultParser(Collection<ITestInvocationListener> listeners, String runName, Set<String> includeFilters, Set<String> excludeFilters) {
        this.mListeners.addAll(listeners);
        this.mRunName = runName;
        this.mTestResultCache = new HashMap<TestDescription, String>();
        this.mIncludeFilters = includeFilters;
        this.mExcludeFilters = excludeFilters;
    }

    public void processNewLines(String[] lines) {
        try {
            if (lines.length < 1 || this.isTracebackLine(lines[0])) {
                throw new PythonUnitTestParseException("Test execution failed");
            }
            this.mCurrentParseState = ParserState.TEST_CASE;
            for (String line : lines) {
                this.parse(line);
            }
            if (this.mCurrentParseState != ParserState.COMPLETE) {
                throw new PythonUnitTestParseException("Parser finished in unexpected state " + this.mCurrentParseState.toString());
            }
        }
        catch (PythonUnitTestParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    void parse(String line) throws PythonUnitTestParseException {
        switch (this.mCurrentParseState) {
            case TEST_CASE: {
                this.processTestCase(line);
                break;
            }
            case TRACEBACK: {
                this.processTraceback(line);
                break;
            }
            case SUMMARY: {
                this.processRunSummary(line);
                break;
            }
            case FAIL_MESSAGE: {
                this.processFailMessage(line);
                break;
            }
        }
    }

    void processTestCase(String line) throws PythonUnitTestParseException {
        if (this.mCurrentTestCaseString != null) {
            line = this.mCurrentTestCaseString = this.mCurrentTestCaseString + "\n" + line;
        }
        if (this.isEqualLine(line)) {
            this.mCurrentParseState = ParserState.FAIL_MESSAGE;
            this.mCurrentTestCaseString = null;
        } else if (this.isDashLine(line)) {
            this.mCurrentParseState = ParserState.SUMMARY;
            this.mCurrentTestCaseString = null;
        } else if (this.lineStartswithPattern(line, PATTERN_ONE_LINE_RESULT)) {
            ArrayList<MatchResult> matchResults = new ArrayList<MatchResult>();
            do {
                matchResults.add(this.mCurrentMatcher.toMatchResult());
            } while (this.mCurrentMatcher.find());
            int lastMatchEnd = ((MatchResult)matchResults.get(matchResults.size() - 1)).end();
            if (lastMatchEnd != line.length()) {
                return;
            }
            for (MatchResult r : matchResults) {
                this.mCurrentTestName = r.group(1);
                this.mCurrentTestClass = r.group(2);
                this.mCurrentTestStatus = r.group(3);
                if (this.mCurrentTestStatus == null) {
                    this.mCurrentTestStatus = "FAIL";
                }
                this.reportNonFailureTestResult();
            }
            this.mCurrentTestCaseString = null;
        } else if (this.lineMatchesPattern(line, PATTERN_TWO_LINE_RESULT_FIRST)) {
            this.mCurrentTestName = this.mCurrentMatcher.group(1);
            this.mCurrentTestClass = this.mCurrentMatcher.group(2);
            this.mCurrentTestCaseString = null;
        } else if (this.lineMatchesPattern(line, PATTERN_TWO_LINE_RESULT_SECOND)) {
            this.mCurrentTestStatus = this.mCurrentMatcher.group(2);
            this.reportNonFailureTestResult();
            this.mCurrentTestCaseString = null;
        } else if (this.lineMatchesPattern(line, PATTERN_TWO_LINE_RESULT_SECOND_ERROR)) {
            this.mCurrentTestCaseString = null;
        } else if (this.lineMatchesPattern(line, MULTILINE_FINAL_RESULT_WITH_WARNING)) {
            StringBuilder message = new StringBuilder("Test seems to pass but with Warnings:\n");
            message.append(this.mCurrentMatcher.group(2));
            this.mCurrentTraceback = message;
            this.reportFailureTestResult();
            this.mCurrentTestCaseString = null;
        } else if (this.lineMatchesPattern(line, MULTILINE_RESULT_WITH_WARNING) && this.mCurrentTestCaseString == null) {
            this.mCurrentTestCaseString = line;
        }
    }

    void processFailMessage(String line) {
        if (this.isDashLine(line)) {
            this.mCurrentParseState = ParserState.TRACEBACK;
            this.mCurrentTraceback = new StringBuilder();
        } else if (this.lineMatchesPattern(line, PATTERN_FAIL_MESSAGE)) {
            this.mCurrentTestName = this.mCurrentMatcher.group(2);
            this.mCurrentTestClass = this.mCurrentMatcher.group(3);
            this.mCurrentTestStatus = this.mCurrentMatcher.group(1);
        }
    }

    void processTraceback(String line) {
        if (this.isDashLine(line)) {
            this.mCurrentParseState = ParserState.SUMMARY;
            this.reportFailureTestResult();
        } else if (this.isEqualLine(line)) {
            this.mCurrentParseState = ParserState.FAIL_MESSAGE;
            this.reportFailureTestResult();
        } else {
            if (this.mCurrentTraceback.length() > 0) {
                this.mCurrentTraceback.append(System.lineSeparator());
            }
            this.mCurrentTraceback.append(line);
        }
    }

    void processRunSummary(String line) {
        if (this.lineMatchesPattern(line, PATTERN_RUN_SUMMARY)) {
            this.mTotalTestCount = Integer.parseInt(this.mCurrentMatcher.group(1));
            double timeInSeconds = Double.parseDouble(this.mCurrentMatcher.group(2));
            this.mTotalElapsedTime = (long)(timeInSeconds * 1000.0);
            this.reportToListeners();
            this.mCurrentParseState = ParserState.COMPLETE;
        }
    }

    boolean isEqualLine(String line) {
        return line.startsWith(EQUAL_LINE);
    }

    boolean isDashLine(String line) {
        return line.startsWith(DASH_LINE);
    }

    boolean isTracebackLine(String line) {
        return line.startsWith(TRACEBACK_LINE);
    }

    private boolean lineMatchesPattern(String line, Pattern p) {
        this.mCurrentMatcher = p.matcher(line);
        return this.mCurrentMatcher.matches();
    }

    private boolean lineStartswithPattern(String line, Pattern p) {
        this.mCurrentMatcher = p.matcher(line);
        return this.mCurrentMatcher.find();
    }

    private void reportToListeners() {
        for (ITestInvocationListener listener : this.mListeners) {
            listener.testRunStarted(this.mRunName, this.mTotalTestCount);
            for (Map.Entry<TestDescription, String> test : this.mTestResultCache.entrySet()) {
                listener.testStarted(test.getKey());
                if (SKIPPED_ENTRY.equals(test.getValue())) {
                    listener.testIgnored(test.getKey());
                } else if (test.getValue() != null) {
                    listener.testFailed(test.getKey(), test.getValue());
                }
                listener.testEnded(test.getKey(), new HashMap());
            }
            listener.testRunEnded(this.mTotalElapsedTime, new HashMap());
        }
    }

    private void reportNonFailureTestResult() throws PythonUnitTestParseException {
        TestDescription testId = new TestDescription(this.mCurrentTestClass, this.mCurrentTestName);
        if (this.shouldSkipCurrentTest()) {
            this.mTestResultCache.put(testId, SKIPPED_ENTRY);
        } else if (PATTERN_TEST_SUCCESS.matcher(this.mCurrentTestStatus).matches()) {
            this.mTestResultCache.put(testId, null);
        } else if (PATTERN_TEST_SKIPPED.matcher(this.mCurrentTestStatus).matches()) {
            this.mTestResultCache.put(testId, SKIPPED_ENTRY);
        } else if (PATTERN_TEST_UNEXPECTED_SUCCESS.matcher(this.mCurrentTestStatus).matches()) {
            this.mTestResultCache.put(testId, "Test unexpected succeeded");
        } else if (!PATTERN_TEST_FAILURE.matcher(this.mCurrentTestStatus).matches()) {
            throw new PythonUnitTestParseException("Unrecognized test status");
        }
    }

    private void reportFailureTestResult() {
        TestDescription testId = new TestDescription(this.mCurrentTestClass, this.mCurrentTestName);
        if (this.shouldSkipCurrentTest()) {
            this.mTestResultCache.put(testId, SKIPPED_ENTRY);
        } else {
            this.mTestResultCache.put(testId, this.mCurrentTraceback.toString());
        }
    }

    private boolean shouldSkipCurrentTest() {
        if (this.mExcludeFilters.contains(this.mCurrentTestClass + "#" + this.mCurrentTestName) || this.mExcludeFilters.contains(this.mCurrentTestClass)) {
            return true;
        }
        if (!this.mIncludeFilters.isEmpty()) {
            return !this.mIncludeFilters.contains(this.mCurrentTestClass + "#" + this.mCurrentTestName) && !this.mIncludeFilters.contains(this.mCurrentTestClass);
        }
        return false;
    }

    public boolean isCancelled() {
        return false;
    }

    private class PythonUnitTestParseException
    extends Exception {
        static final long serialVersionUID = -3387516993124229948L;

        public PythonUnitTestParseException(String reason) {
            super(reason);
        }
    }

    static enum ParserState {
        TEST_CASE,
        FAIL_MESSAGE,
        TRACEBACK,
        SUMMARY,
        COMPLETE;

    }
}

