/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.host;

import com.android.tradefed.config.Option;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.util.FileUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class CoverageMeasurementForwarder
implements IRemoteTest {
    @Option(name="coverage-measurement", description="The name of the build artifact to forward. The artifact should be a coveragemeasurement to save as a test result. This option may be repeated.", importance=Option.Importance.IF_UNSET, mandatory=false)
    private List<String> mCoverageMeasurements = new ArrayList<String>();
    @Option(name="coverage-log-data-type", description="Log data type to save the build artifacts as.")
    private LogDataType mLogDataType = LogDataType.COVERAGE;

    @VisibleForTesting
    void setCoverageMeasurements(List<String> coverageMeasurements) {
        this.mCoverageMeasurements = coverageMeasurements;
    }

    @VisibleForTesting
    void setCoverageLogDataType(LogDataType type) {
        this.mLogDataType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TestInformation testInfo, ITestInvocationListener listener) {
        if (this.mCoverageMeasurements.isEmpty()) {
            return;
        }
        listener.testRunStarted("CoverageMeasurementForwarder", 0);
        for (String artifactName : this.mCoverageMeasurements) {
            File coverageMeasurement = Preconditions.checkNotNull(testInfo.getBuildInfo().getFile(artifactName), "Failed to get artifact '%s' from the build.", (Object)artifactName);
            try (FileInputStreamSource stream = new FileInputStreamSource(coverageMeasurement);){
                listener.testLog(Files.getNameWithoutExtension(artifactName), this.mLogDataType, (InputStreamSource)stream);
            }
            finally {
                FileUtil.deleteFile((File)coverageMeasurement);
            }
        }
        listener.testRunEnded(0L, new HashMap());
    }
}

