/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype.junit4;

import android.host.test.longevity.LongevitySuite;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionSetter;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.ISetOptionReceiver;
import com.android.tradefed.testtype.ITestInformationReceiver;
import com.android.tradefed.testtype.junit4.builder.DeviceJUnit4ClassRunnerBuilder;
import com.android.tradefed.util.TimeVal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

@OptionClass(alias="longevity-runner")
public class LongevityHostRunner
extends Runner
implements IAbiReceiver,
ITestInformationReceiver,
ISetOptionReceiver {
    static final String ITERATIONS_OPTION = "iterations";
    static final String TOTAL_TIMEOUT_OPTION = "total-timeout";
    private TestInformation mTestInfo;
    private IAbi mAbi;
    @Option(name="set-option", description="Options to be passed down to the class under test, key and value should be separated by colon \":\"; for example, if class under test supports \"--iteration 1\" from a command line, it should be passed in as \"--set-option iteration:1\" or \"--set-option iteration:key=value\" for passing options to map; escaping of \"=\" is currently not supported.A particular class can be targetted by specifying it. \" --set-option <fully qualified class>:<option name>:<option value>\"")
    private Set<String> mKeyValueOptions = new HashSet<String>();
    @Option(name="iterations", description="The number of times to repeat the tests in this suite.")
    private int mIterations = 1;
    @Option(name="total-timeout", description="The overall timeout for this suite.", isTimeVal=true)
    private long mTotalTimeoutMsec = 1800000L;
    private Class<?> mSuiteKlass;

    public LongevityHostRunner(Class<?> klass) {
        this.mSuiteKlass = klass;
    }

    public void setTestInformation(TestInformation testInformation) {
        this.mTestInfo = testInformation;
    }

    public TestInformation getTestInformation() {
        return this.mTestInfo;
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    private Map<String, String> getOptions() {
        Iterator<String> iterator = this.mKeyValueOptions.iterator();
        while (iterator.hasNext()) {
            String kvPair = iterator.next();
            if (kvPair.contains(ITERATIONS_OPTION)) {
                try {
                    this.mIterations = Integer.parseInt(kvPair.split(":")[1]);
                    iterator.remove();
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    throw new RuntimeException(String.format("Malformed input, %s, should be iterations:<int>.", kvPair));
                }
            }
            if (!kvPair.contains(TOTAL_TIMEOUT_OPTION)) continue;
            try {
                this.mTotalTimeoutMsec = TimeVal.fromString((String)kvPair.split(":")[1]);
                iterator.remove();
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                throw new RuntimeException(String.format("Malformed input, %s, should be total-timeout:<long|time>.", kvPair));
            }
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(ITERATIONS_OPTION, String.valueOf(this.mIterations));
        options.put("suite-timeout_msec", String.valueOf(this.mTotalTimeoutMsec));
        return options;
    }

    private LongevitySuite constructSuite() {
        try {
            return new LongevitySuite(this.mSuiteKlass, new DeviceJUnit4ClassRunnerBuilder(), this.getOptions());
        }
        catch (InitializationError e) {
            throw new RuntimeException("Unable to construct longevity suite", e);
        }
    }

    public Description getDescription() {
        return this.constructSuite().getDescription();
    }

    public void run(RunNotifier notifier) {
        LongevitySuite suite = this.constructSuite();
        for (Runner child : suite.getRunners()) {
            if (child instanceof IDeviceTest) {
                ((IDeviceTest)child).setDevice(this.mTestInfo.getDevice());
            }
            if (child instanceof IAbiReceiver) {
                ((IAbiReceiver)child).setAbi(this.mAbi);
            }
            if (child instanceof IBuildReceiver) {
                ((IBuildReceiver)child).setBuild(this.mTestInfo.getBuildInfo());
            }
            if (child instanceof IInvocationContextReceiver) {
                ((IInvocationContextReceiver)child).setInvocationContext(this.mTestInfo.getContext());
            }
            if (child instanceof ITestInformationReceiver) {
                ((ITestInformationReceiver)child).setTestInformation(this.mTestInfo);
            }
            try {
                OptionSetter setter = new OptionSetter(new Object[]{child});
                for (String kvPair : this.mKeyValueOptions) {
                    setter.setOptionValue("set-option", kvPair);
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        suite.run(notifier);
    }

    public int testCount() {
        return this.constructSuite().testCount();
    }
}

